<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform"
                              xmlns:wsdl="http://schemas.xmlsoap.org/wsdl/"
                              xmlns:wsdlsoap="http://schemas.xmlsoap.org/wsdl/soap/"
                              xmlns:wsdlsoap12="http://schemas.xmlsoap.org/wsdl/soap12/"
                              xmlns:wsaw="http://www.w3.org/2006/05/addressing/wsdl">
  <xsl:output method="xml" indent="yes"/>
  <xsl:param name="serviceName" select="''"/>
  <xsl:param name="portName" select="''"/>
  <xsl:param name="soapVersion" select="'1.1'"/>

  <xsl:template match="/">
    <xsl:apply-templates select="wsdl:definitions"/>
  </xsl:template>
  
  <xsl:template match="wsdl:definitions">
	<xsl:copy>
	  <xsl:copy-of select="* | @*"/>
      <xsl:apply-templates select="wsdl:portType"/>  
      <xsl:element name="wsdl:service">
        <xsl:attribute name="name">
          <xsl:value-of select="$serviceName"/>
        </xsl:attribute>
        <xsl:element name="wsdl:port">
          <xsl:attribute name="name">
            <xsl:value-of select="$portName"/>
          </xsl:attribute>
          <xsl:choose>
            <xsl:when test="$soapVersion = '1.2'">
              <xsl:attribute name="binding">
	            <xsl:value-of select="concat('tns:', $serviceName, 'Binding')"/>
	          </xsl:attribute>
	          <xsl:element name="wsdlsoap12:address">
	            <xsl:attribute name="location">http://localhost:9080/wsn</xsl:attribute>
	          </xsl:element>
	        </xsl:when>
	        <xsl:otherwise>
	          <xsl:attribute name="binding">
	            <xsl:value-of select="concat('tns:', $serviceName, 'Binding')"/>
	          </xsl:attribute>
	          <xsl:element name="wsdlsoap:address">
	            <xsl:attribute name="location">http://localhost:9080/wsn</xsl:attribute>
	          </xsl:element>
	        </xsl:otherwise>
          </xsl:choose>
        </xsl:element>
      </xsl:element>  	  
	</xsl:copy>
  </xsl:template>
  
  <xsl:template match="wsdl:portType">
	<xsl:element name="wsdl:binding">
      <xsl:choose>
        <xsl:when test="$soapVersion = '1.2'">
          <xsl:attribute name="name">
	        <xsl:value-of select="concat($serviceName, 'Binding')"/>
	      </xsl:attribute>
	      <xsl:attribute name="type">
	        <xsl:value-of select="concat('tns:', @name)"/>
	      </xsl:attribute>
          <xsl:element name="wsdlsoap12:binding">
            <xsl:attribute name="style">document</xsl:attribute>
            <xsl:attribute name="transport">http://schemas.xmlsoap.org/soap/http</xsl:attribute>
          </xsl:element>
        </xsl:when>
        <xsl:otherwise>
          <xsl:attribute name="name">
	        <xsl:value-of select="concat($serviceName, 'Binding')"/>
	      </xsl:attribute>
	      <xsl:attribute name="type">
	        <xsl:value-of select="concat('tns:', @name)"/>
	      </xsl:attribute>
          <xsl:element name="wsdlsoap:binding">
            <xsl:attribute name="style">document</xsl:attribute>
            <xsl:attribute name="transport">http://schemas.xmlsoap.org/soap/http</xsl:attribute>
          </xsl:element>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:element name="wsaw:UsingAddressing">
      	<xsl:attribute name="wsdl:required">true</xsl:attribute>      
      </xsl:element>
	  <xsl:apply-templates select="wsdl:operation"/>
	</xsl:element>
  </xsl:template>
  
  <xsl:template match="wsdl:operation">
    <xsl:element name="{name()}">
      <xsl:attribute name="name">
        <xsl:value-of select="@name"/>
      </xsl:attribute>    
      <xsl:choose>
        <xsl:when test="$soapVersion = '1.2'">
          <xsl:element name="wsdlsoap12:operation">
            <xsl:attribute name="soapAction"/>
          </xsl:element>
        </xsl:when>
        <xsl:otherwise>
          <xsl:element name="wsdlsoap:operation">
            <xsl:attribute name="soapAction"/>
          </xsl:element>
        </xsl:otherwise>
      </xsl:choose>
      <xsl:apply-templates select="wsdl:input|wsdl:output|wsdl:fault"/>
    </xsl:element>
  </xsl:template>
  
  <xsl:template match="wsdl:input">
    <xsl:element name="{name()}">
      <xsl:if test="@name">
        <xsl:attribute name="name">
          <xsl:value-of select="@name"/>
        </xsl:attribute>    
      </xsl:if>
      <xsl:choose>
        <xsl:when test="$soapVersion = '1.2'">
          <xsl:element name="wsdlsoap12:body">
            <xsl:attribute name="use">literal</xsl:attribute>
          </xsl:element>
        </xsl:when>
        <xsl:otherwise>
          <xsl:element name="wsdlsoap:body">
            <xsl:attribute name="use">literal</xsl:attribute>
          </xsl:element>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  
  <xsl:template match="wsdl:output">
    <xsl:element name="{name()}">
      <xsl:if test="@name">
        <xsl:attribute name="name">
          <xsl:value-of select="@name"/>
        </xsl:attribute>    
      </xsl:if>
      <xsl:choose>
        <xsl:when test="$soapVersion = '1.2'">
          <xsl:element name="wsdlsoap12:body">
            <xsl:attribute name="use">literal</xsl:attribute>
          </xsl:element>
        </xsl:when>
        <xsl:otherwise>
          <xsl:element name="wsdlsoap:body">
            <xsl:attribute name="use">literal</xsl:attribute>
          </xsl:element>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  
  <xsl:template match="wsdl:fault">
    <xsl:element name="{name()}">
      <xsl:if test="@name">
        <xsl:attribute name="name">
          <xsl:value-of select="@name"/>
        </xsl:attribute>    
      </xsl:if>
      <xsl:choose>
        <xsl:when test="$soapVersion = '1.2'">
          <xsl:element name="wsdlsoap12:fault">
	        <xsl:attribute name="name">
	          <xsl:value-of select="@name"/>
	        </xsl:attribute>    
            <xsl:attribute name="use">literal</xsl:attribute>
          </xsl:element>
        </xsl:when>
        <xsl:otherwise>
          <xsl:element name="wsdlsoap:fault">
	        <xsl:attribute name="name">
	          <xsl:value-of select="@name"/>
	        </xsl:attribute>    
            <xsl:attribute name="use">literal</xsl:attribute>
          </xsl:element>
        </xsl:otherwise>
      </xsl:choose>
    </xsl:element>
  </xsl:template>
  
</xsl:stylesheet>