#!/bin/ksh
# IBM Confidential OCO Source Material
# 5630-A36 (C) COPYRIGHT International Business Machines Corp. 1997, 2002
# The source code for this program is not published or otherwise divested
# of its trade secrets, irrespective of what has been deposited with the
# U.S. Copyright Office.

set -x
[ -d OS ] && rm -r OS
mkdir OS

function LSL
{
  Cmd=$1
  PATHcmd=$2
  lsl=$(  ls -l  $PATHcmd )
  lslL=$( ls -lL $PATHcmd )
  printf "%-20s : %-9s : %s\n" "$Cmd" "ls -l" "$lsl" >> OS/commands
  if [ "$lsl" != "$lslL" ]
    then
      printf "%-20s : %-9s : %s\n" "$Cmd" "ls -lL" "$lslL" >> OS/commands
  fi
}

function Path
{
  Cmd=$1
  PATHcmd=$( whence $Cmd )
  if [ 0 = $? ]
    then
      if [ "/" = $( echo $PATHcmd | cut -c 1 ) ]
        then
          printf "%-20s : %-9s : %s\n" $Cmd PATH "$PATHcmd"   >> OS/commands
          LSL $Cmd $PATHcmd
        else
          printf "%-20s : %-9s : %s\n" $Cmd shell "$PATHcmd"  >> OS/commands
      fi
      return 0
    else
      return 1
  fi
}

function Sbin
{
  Cmd=$1
  if [ -x /sbin/$Cmd ]
    then
      printf "%-20s : %-9s : %s\n" $Cmd sbin /sbin/$Cmd >> OS/commands
      LSL $Cmd /sbin/$Cmd
      return 0
    else
      return 1
  fi
}

function UsrSbin
{
  Cmd=$1
  if [ -x /usr/sbin/$Cmd ]
    then
      printf "%-20s : %-9s : %s\n" $Cmd usr/sbin /usr/sbin/$Cmd >> OS/commands
      LSL $Cmd /usr/sbin/$Cmd
      return 0
    else
      return 1
  fi
}

function FullPath
{
  PathCmd=$1
  Cmd=$( basename $PathCmd )
  if [ -x $PathCmd ]
    then
      printf "%-20s : %-9s : %s\n" $Cmd "full path" $PathCmd >> OS/commands
      LSL $Cmd $PathCmd
      return 0
    else
      return 1
  fi
}

function LookFor
{
  FullPathCmd=$1
  Cmd=$( basename $FullPathCmd )
  Path $Cmd
  if [ 1 = $? ]
    then
      Sbin $Cmd
      if [ 1 = $? ]
        then
          UsrSbin $Cmd
          if [ 1 = $? ]
            then
              if [ "/" = $( echo $FullPathCmd | cut -c 1 ) ]
                then
                  FullPath $FullPathCmd
                  if [ 1 = $? ]
                    then
                      printf "%-20s : %-s\n" $Cmd "*** Not Found ***" >> OS/commands
                  fi
                else
                  printf "%-20s : %-s\n" $Cmd "*** Not Found ***" >> OS/commands
              fi
          fi
      fi
  fi
}

echo "-----------------------------------------------------------" >> OS/commands
echo "PATH:"                                                       >> OS/commands
echo $PATH | tr ':' '\n'                                           >> OS/commands
echo "-----------------------------------------------------------" >> OS/commands
echo "Search for commands"                                         >> OS/commands
LookFor /usr/samples/kernel/vmtune
LookFor arp
LookFor bdf
LookFor bootinfo
LookFor date
LookFor df
LookFor dmesg
LookFor errpt
LookFor free
LookFor getconf
LookFor hostname
LookFor id
LookFor ifconfig
LookFor ioscan
LookFor iostat
LookFor isainfo
LookFor jar
LookFor java
LookFor jre
LookFor ksh
LookFor lanscan
LookFor lsattr
LookFor lscfg
LookFor lsdev
LookFor lsfs
LookFor lsgroup
LookFor lslicense
LookFor lsps
LookFor lspv
LookFor lssrc
LookFor lsuser
LookFor lsvg
LookFor model
LookFor ndd
LookFor netstat
LookFor nfsstat
LookFor no
LookFor nslookup
LookFor patchadd
LookFor prtconf
LookFor psrinfo
LookFor runlevel
LookFor sh
LookFor showmount
LookFor showrev
LookFor swap
LookFor swapinfo
LookFor swlist
LookFor sysdef
LookFor top
LookFor type
LookFor ulimit
LookFor uname
LookFor vmstat
LookFor whence
LookFor which
LookFor who
echo "-----------------------------------------------------------" >> OS/commands
