<?xml version="1.0" encoding="UTF-8"?> 
<xsl:stylesheet version="1.0" xmlns:xsl="http://www.w3.org/1999/XSL/Transform">
<xsl:output method="xml" indent="yes" omit-xml-declaration="yes" doctype-system="applied.dtd"/>

<!-- Parameter declaration begin -->

<!-- xsl:param name="wasinstallroot"/ -->
<xsl:param name="fileseparator"/>
<xsl:param name="logdirpath"/>
<xsl:param name="backupdirpath"/>

<xsl:param name="empty_string">
    <xsl:text></xsl:text>
</xsl:param>
<xsl:param name="notapplicable">
    <xsl:text>not applicable</xsl:text>
</xsl:param>
<xsl:param name="update_action_install">
    <xsl:text>install</xsl:text>
</xsl:param>
<xsl:param name="update_action_uninstall">
    <xsl:text>uninstall</xsl:text>
</xsl:param>
<xsl:param name="update_type_replace">
    <xsl:text>replace</xsl:text>
</xsl:param>

<!-- Parameter declaration end -->

    <xsl:template name="ptf_applied" match="maintenance-history">
        <xsl:element name="event-history">
            <xsl:for-each select="maintenance">
                <xsl:variable name="maintenance_name" select="@name"/>
                <xsl:variable name="package_filename">
                    <xsl:for-each select="param[@name='filename']">
                        <xsl:value-of select="@value"/>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:variable name="base_file_name">
                    <xsl:value-of select="substring-before($package_filename,'.pak')"/>
                </xsl:variable>
                <xsl:variable name="update_action">
                    <xsl:for-each select="param[@name='action']">
                        <xsl:value-of select="@value"/>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:variable name="update_type">
                    <xsl:value-of select="$update_type_replace"/>
                </xsl:variable> 
                <xsl:variable name="timestamp">
                    <xsl:for-each select="param[@name='timestamp']">
                        <xsl:value-of select="@value"/>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:variable name="isofficialfix">
                    <xsl:for-each select="param[@name='isofficialfix']">
                        <xsl:value-of select="@value"/>
                    </xsl:for-each>
                </xsl:variable>
                <xsl:variable name="log_name">
                    <xsl:value-of select="$logdirpath"/>
                    <xsl:value-of select="$fileseparator"/>
                    <xsl:value-of select="$base_file_name"/>
                    <xsl:text>.</xsl:text>
                    <xsl:value-of select="$update_action"/>
                    <xsl:value-of select="$fileseparator"/>
                    <xsl:text>updatelog.txt</xsl:text>
                </xsl:variable>
                <xsl:variable name="backup_name">
                    <xsl:choose>
                        <xsl:when test="$update_action = $update_action_install">
                            <xsl:value-of select="$backupdirpath"/>
                            <xsl:value-of select="$fileseparator"/>
                            <xsl:value-of select="$package_filename"/>
                        </xsl:when>
                        <xsl:otherwise>
                            <xsl:value-of select="$notapplicable"/>
                        </xsl:otherwise>
                    </xsl:choose>
                </xsl:variable>
                
                <xsl:element name="ptf-applied">   
                    <xsl:attribute name="ptf-id">
                        <xsl:value-of select="$base_file_name"/>
                    </xsl:attribute>
                    <xsl:for-each select="param[@name='component']">
                        <xsl:element name="component-applied">
                            <xsl:attribute name="component-name">
                                <xsl:value-of select="@value"/>
                            </xsl:attribute>
                            <xsl:attribute name="update-type">
                                <xsl:value-of select="$update_type"/>
                            </xsl:attribute>
                            <xsl:attribute name="log-name">
                                <xsl:value-of select="$log_name"/>
                            </xsl:attribute>
                            <xsl:attribute name="backup-name">
                                <xsl:value-of select="$backup_name"/>
                            </xsl:attribute>
                            <xsl:attribute name="time-stamp">
                                <xsl:value-of select="$timestamp"/>
                            </xsl:attribute>
                        </xsl:element>
                    </xsl:for-each>
                </xsl:element>
            </xsl:for-each>
        </xsl:element>
    </xsl:template>
</xsl:stylesheet>
                        
                
                