@echo off
setlocal enabledelayedexpansion

echo ==================================================
echo   Updating VPN CA certificate
echo ==================================================

:: --- Check for Administrator privileges ---
echo [INFO] Checking for Administrator privileges...
net session >nul 2>&1
if errorlevel 1 (
    echo [ERROR] This script requires Administrator privileges
    echo [ERROR] Please run this script as Administrator
    echo.
    pause
    exit /b 1
)
echo [SUCCESS] Running with Administrator privileges
echo.

:: --- Read DataPath from registry ---
for /f "tokens=2*" %%A in ('reg query "HKLM\SOFTWARE\WOW6432Node\Fiberlink\V360" /v DataPath 2^>nul') do (
    set "DataPath=%%B"
)

if not defined DataPath (
    echo [ERROR] Could not read DataPath from registry key:
    echo   HKLM\SOFTWARE\WOW6432Node\Fiberlink\V360\DataPath
    pause
    exit /b 1
)

:: --- Read InstallDir from registry ---
for /f "tokens=2*" %%A in ('reg query "HKLM\SOFTWARE\WOW6432Node\Fiberlink\V360" /v InstallDir 2^>nul') do (
    set "InstallDir=%%B"
)

if not defined InstallDir (
    echo [ERROR] Could not read InstallDir from registry key:
    echo   HKLM\SOFTWARE\WOW6432Node\Fiberlink\V360\InstallDir
    pause
    exit /b 1
)

:: Remove trailing backslash if present
if "%InstallDir:~-1%"=="\" set "InstallDir=%InstallDir:~0,-1%"

:: --- Build paths ---
set "CAPath=%DataPath%\AR\Data\VPN"
set "CAFile=%CAPath%\ca.crt"
set "BackupFile=%CAPath%\ca_bkp.crt"
set "VPNEXE=%InstallDir%\maas360vpn.exe"

echo [INFO] DataPath   = %DataPath%
echo [INFO] InstallDir = %InstallDir%
echo [INFO] CA file    = %CAFile%
echo [INFO] VPN exe    = %VPNEXE%
echo.

:: --- Verify VPN directory exists ---
if not exist "%CAPath%" (
    echo [ERROR] VPN directory does not exist: %CAPath%. Please ensure MaaS360 VPN module is configured properly.
    exit /b 1
)

:: If file does not exist, stop immediately
if not exist "%VPNEXE%" (
    echo [ERROR] maas360vpn.exe not found in "%InstallDir%".  Please ensure MaaS360 VPN module is configured properly.
    exit /b 1
)

:: --- Backup current ca.crt ---
if exist "%CAFile%" (
    if exist "%BackupFile%" (
        echo [INFO] Backup file ca_bkp.crt already exists, skipping backup creation
    ) else (
        echo [INFO] Backing up existing ca.crt to ca_bkp.crt...
        copy /Y "%CAFile%" "%BackupFile%" >nul 2>&1
        if errorlevel 1 (
            echo [ERROR] Failed to backup ca.crt
            pause
            exit /b 1
        )
        if not exist "%BackupFile%" (
            echo [ERROR] Backup file was not created
            pause
            exit /b 1
        )
        echo [SUCCESS] Backup created successfully
    )
    
    del /F /Q "%CAFile%" 2>nul
    if exist "%CAFile%" (
        echo [ERROR] Failed to delete old ca.crt file
        pause
        exit /b 1
    )
) else (
    echo [ERROR] No existing ca.crt found, aborting ca.crt update. Please ensure MaaS360 VPN module is configured properly.
    pause
    exit /b 1
)

:: --- Stop maas360vpn.exe if running ---
echo [INFO] Stopping maas360vpn.exe...
taskkill /IM maas360vpn.exe /F >nul 2>&1


:: --- Create new ca.crt from embedded certs ---
echo [INFO] Writing new ca.crt...


:: > "%CAFile%" This means: Everything echoed inside this block gets written to ca.crt.
::This loops through every line of the batch script itself.
::%~f0 = the full path of the currently running .bat file.
::So this loop reads your batch script as text, line by line.
::%%L holds each line.
::Marker Logic (Turning On/Off Copying) - When we see the start of either certificate section →
::if "!line!"=="SUBCA_BEGIN" set "writing=1"
::if "!line!"=="ROOTCA_BEGIN" set "writing=1"
::else stop copying 
::if "!line!"=="SUBCA_END" set "writing="
::if "!line!"=="ROOTCA_END" set "writing=" 
> "%CAFile%" (
    set "writing="
    for /f "usebackq delims=" %%L in ("%~f0") do (
        rem Normalize line (strip leading/trailing spaces)
        set "line=%%L"
        set "line=!line: =!"

        rem Check for markers
		::Marker Logic (Turning On/Off Copying)
        if "!line!"=="SUBCA_BEGIN" set "writing=1" 
        if "!line!"=="ROOTCA_BEGIN" set "writing=1"
        if "!line!"=="SUBCA_END" set "writing="
        if "!line!"=="ROOTCA_END" set "writing="

        rem Only write lines while inside cert block
        if defined writing (
            if not "!line!"=="SUBCA_BEGIN" if not "!line!"=="SUBCA_END" if not "!line!"=="ROOTCA_BEGIN" if not "!line!"=="ROOTCA_END" (
                echo %%L
            )
        )
    )
)


if exist "%CAFile%" (
    echo [SUCCESS] ca.crt updated successfully.
) else (
    echo [ERROR] Failed to create ca.crt.
    pause
    exit /b 1
)

echo [DEBUG] VPNEXE = "%VPNEXE%"

:: Otherwise, restart the VPN
echo [INFO] Restarting maas360vpn.exe...
start "" "%VPNEXE%"
echo [DONE] Operation complete.
exit /b 0

pause
endlocal
exit /b 0


:: ==================================================
:: Embedded Certificate Content
:: ==================================================
:EOF
SUBCA_BEGIN
-----BEGIN CERTIFICATE-----
MIIDdjCCAl6gAwIBAgICAUEwDQYJKoZIhvcNAQENBQAwYDEVMBMGCgmSJomT8ixk
ARkWBWxvY2FsMRowGAYKCZImiZPyLGQBGRYKcHJvZHVjdGlvbjErMCkGA1UEAwwi
TWFhUzM2MCBSb290IENlcnRpZmljYXRlIEF1dGhvcml0eTAeFw0yNTExMTgxMjA0
MzhaFw0zNTExMTYxMjA0MzhaMD0xCzAJBgNVBAYTAlVTMRAwDgYDVQQKDAdNYWFT
MzYwMRwwGgYDVQQDDBNNYWFTMzYwR0FURVdBWUNBIE00MIIBIjANBgkqhkiG9w0B
AQEFAAOCAQ8AMIIBCgKCAQEArYfthlGtAsz4bXpHfmifHtY3MTOuDIlu0SuHNDGh
pD3cnRJ+v3adFYMQiQchqWQEVGvRN8J30jezAc1Ugy9ZGfTm2VjH6WCNJH5Uau3K
7G/tldm4ek9iucfa+xk2FQTexIi1IYqTkW9C/oHudyKahwsYOaMCxAgbao0kKfux
mtWB1cuVUmhX3H+h4rSHmoIQP3bwEVrh6qjH6lysX9IjqYUfQqDELmy6JGQM6NOT
uVqE9W7W+knbpvdrL3n2nUdLiE/9ocTuQM7Zeqshg/nGm1xQtwSrjw5FBy/pkflE
rIp8iH3xftYn1Gy7/+DVvrxjI6EOsN6T4OMcgsqmYO1O/QIDAQABo10wWzAdBgNV
HQ4EFgQUjcvvOLR7LoGLNd20ajt9A8sp4AEwHwYDVR0jBBgwFoAUKGsGDKFpjZMI
L5/swUAKyOlLZKgwDAYDVR0TBAUwAwEB/zALBgNVHQ8EBAMCAQYwDQYJKoZIhvcN
AQENBQADggEBAEKTBUDpdvGgpSXWCh+urMn3g01w7G05X1KvqGc2JjKHmO1kKVVt
hiwrYHtLO/7NbXlWfLMK5+Ya+CJDxlPHQGZqkwaWr8Kef79neoelg06PYcpYqGE+
t5MzyjoZ7QKWKacK70v6T3N14loHrexKUIdXPm2LDX/Gv84ChjsFGEW4WNCBZyVm
89aIZOS8mheG9rU37wDxKqJl7n6RcGqyMWV0QGZakfAIjPp9kVj+eDsuWxVJ6d6F
Zyg04lwROl+fig/mjDHetCMooomjVmwOw/IznxsRckaAzEOqCwO2LfT8S8J8QBkN
E4r1G86sYenEs5q/uB+oI4/l1HA4iXXHsE8=
-----END CERTIFICATE-----
SUBCA_END
ROOTCA_BEGIN
-----BEGIN CERTIFICATE-----
MIIDozCCAougAwIBAgIJAIHoQMMGVE+OMA0GCSqGSIb3DQEBDQUAMGAxFTATBgoJ
kiaJk/IsZAEZFgVsb2NhbDEaMBgGCgmSJomT8ixkARkWCnByb2R1Y3Rpb24xKzAp
BgNVBAMMIk1hYVMzNjAgUm9vdCBDZXJ0aWZpY2F0ZSBBdXRob3JpdHkwHhcNMjUx
MTE3MTI1MjEzWhcNMzUxMTE1MTI1MjEzWjBgMRUwEwYKCZImiZPyLGQBGRYFbG9j
YWwxGjAYBgoJkiaJk/IsZAEZFgpwcm9kdWN0aW9uMSswKQYDVQQDDCJNYWFTMzYw
IFJvb3QgQ2VydGlmaWNhdGUgQXV0aG9yaXR5MIIBIjANBgkqhkiG9w0BAQEFAAOC
AQ8AMIIBCgKCAQEAv9/fVdqv7oo857K4oLOqjXqWIM5PxPNoANPnEaQ9K7qJLBtC
gVgGOsWzA1URyXvEkT4ODp4urytbZFtT3JliO5hEZrkweOUujfejknqckbC9ykNb
K2pVCNphVbbk8h0v6vUMGMpRNmj31+19PnkVCjWXLQoGDWfrwUCoVhklnENxWG/o
+6elBCx3pug/5EXGFASq77L7CQ/UdS7Rz9mwUFaAdcn+Pcybs96ZNTuOd8Jra0dz
3hQUldqNhxkv6MV+xweuNeI+J+LhpdJknf0jYs0AFcgtYI1mhmMQ1D33AxO4L+WP
78QmTCLHQ3b3mfcil7y2+dOtp+evmBXJw3zPbwIDAQABo2AwXjAdBgNVHQ4EFgQU
KGsGDKFpjZMIL5/swUAKyOlLZKgwHwYDVR0jBBgwFoAUKGsGDKFpjZMIL5/swUAK
yOlLZKgwDwYDVR0TAQH/BAUwAwEB/zALBgNVHQ8EBAMCAYYwDQYJKoZIhvcNAQEN
BQADggEBADCfFsPnPdYa90OuMzM6/Hg3VF10vndpyWUhlY4x+oeyUC6ncWCKS3pm
g3+Qy7Yi5fv4sPguYPK+6s1zqIIs4GD0lCmxd91WGX4HvmbxxIdll/KUNedbnDKH
iXgzFfn8eENIpml2Yuc1v4L+lFSiiLDsYAZZmLGlnv633QWylbqUm856UZrH/VPx
C4xSHKvtX/A7cKWjLbIaS0EAXL6YrCxbE57dOBvVoTa9prp0LO+jEZnU82vKjSBj
ApWjsDqJmTr1qRh9el3k11+06U/WjXccZOtulEZeF+r7vtyAHvSFlRkHQqiBH23y
6qUOwi1O4446ZJRP+wvxTR7/GjIrgpc=
-----END CERTIFICATE-----
ROOTCA_END