/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.swt.printing;

import org.eclipse.swt.SWT;
import org.eclipse.swt.graphics.Device;
import org.eclipse.swt.graphics.DeviceData;
import org.eclipse.swt.graphics.GCData;
import org.eclipse.swt.graphics.Point;
import org.eclipse.swt.graphics.Rectangle;
import org.eclipse.swt.internal.Callback;
import org.eclipse.swt.internal.Converter;
import org.eclipse.swt.internal.cairo.Cairo;
import org.eclipse.swt.internal.gtk.GdkVisual;
import org.eclipse.swt.internal.gtk.OS;
import org.eclipse.swt.printing.PrinterData;

public final class Printer
extends Device {
    static PrinterData[] printerList;
    static int findPrinter;
    static PrinterData findData;
    PrinterData data;
    int printer;
    int printJob;
    int settings;
    int pageSetup;
    int surface;
    int cairo;
    boolean isGCCreated = false;
    static byte[] settingsData;
    static int start;
    static int end;
    static final String GTK_LPR_BACKEND = "GtkPrintBackendLpr";
    static final String GTK_FILE_BACKEND = "GtkPrintBackendFile";
    static boolean disablePrinting;

    static {
        disablePrinting = System.getProperty("org.eclipse.swt.internal.gtk.disablePrinting") != null;
    }

    static void gtk_init() {
        if (OS.GLIB_VERSION < OS.VERSION(2, 32, 0) && !OS.g_thread_supported()) {
            OS.g_thread_init(0);
        }
        if (OS.GTK_VERSION < OS.VERSION(2, 24, 0)) {
            OS.gtk_set_locale();
        }
        if (!OS.gtk_init_check(new int[1], null)) {
            SWT.error(2, null, " [gtk_init_check() failed]");
        }
    }

    public static PrinterData[] getPrinterList() {
        printerList = new PrinterData[0];
        if (disablePrinting) {
            return printerList;
        }
        Printer.gtk_init();
        Callback printerCallback = new Callback(Printer.class, "GtkPrinterFunc_List", 2);
        int GtkPrinterFunc_List = printerCallback.getAddress();
        if (GtkPrinterFunc_List == 0) {
            SWT.error(3);
        }
        OS.gtk_enumerate_printers(GtkPrinterFunc_List, 0, 0, true);
        OS.gdk_threads_leave();
        printerCallback.dispose();
        return printerList;
    }

    static int GtkPrinterFunc_List(int printer, int user_data) {
        int length = printerList.length;
        PrinterData[] newList = new PrinterData[length + 1];
        System.arraycopy(printerList, 0, newList, 0, length);
        printerList = newList;
        Printer.printerList[length] = Printer.printerDataFromGtkPrinter(printer);
        if (Printer.printerList[length].driver.equals(GTK_LPR_BACKEND)) {
            return 1;
        }
        return 0;
    }

    public static PrinterData getDefaultPrinterData() {
        findData = null;
        if (disablePrinting) {
            return null;
        }
        Printer.gtk_init();
        Callback printerCallback = new Callback(Printer.class, "GtkPrinterFunc_Default", 2);
        int GtkPrinterFunc_Default = printerCallback.getAddress();
        if (GtkPrinterFunc_Default == 0) {
            SWT.error(3);
        }
        OS.gtk_enumerate_printers(GtkPrinterFunc_Default, 0, 0, true);
        OS.gdk_threads_leave();
        printerCallback.dispose();
        return findData;
    }

    static int GtkPrinterFunc_Default(int printer, int user_data) {
        if (OS.gtk_printer_is_default(printer)) {
            findData = Printer.printerDataFromGtkPrinter(printer);
            return 1;
        }
        return 0;
    }

    static int gtkPrinterFromPrinterData(PrinterData data) {
        Printer.gtk_init();
        Callback printerCallback = new Callback(Printer.class, "GtkPrinterFunc_FindNamedPrinter", 2);
        int GtkPrinterFunc_FindNamedPrinter = printerCallback.getAddress();
        if (GtkPrinterFunc_FindNamedPrinter == 0) {
            SWT.error(3);
        }
        findPrinter = 0;
        findData = data;
        OS.gtk_enumerate_printers(GtkPrinterFunc_FindNamedPrinter, 0, 0, true);
        OS.gdk_threads_leave();
        printerCallback.dispose();
        return findPrinter;
    }

    static int GtkPrinterFunc_FindNamedPrinter(int printer, int user_data) {
        PrinterData pd = Printer.printerDataFromGtkPrinter(printer);
        if (pd.driver.equals(Printer.findData.driver) && pd.name.equals(Printer.findData.name) || pd.driver.equals(GTK_FILE_BACKEND) && Printer.findData.printToFile && Printer.findData.driver == null && Printer.findData.name == null) {
            findPrinter = printer;
            OS.g_object_ref(printer);
            return 1;
        }
        return 0;
    }

    static PrinterData printerDataFromGtkPrinter(int printer) {
        int backend = OS.gtk_printer_get_backend(printer);
        int address = OS.G_OBJECT_TYPE_NAME(backend);
        int length = OS.strlen(address);
        byte[] buffer = new byte[length];
        OS.memmove(buffer, address, length);
        String backendType = new String(Converter.mbcsToWcs(null, buffer));
        address = OS.gtk_printer_get_name(printer);
        length = OS.strlen(address);
        buffer = new byte[length];
        OS.memmove(buffer, address, length);
        String name = new String(Converter.mbcsToWcs(null, buffer));
        return new PrinterData(backendType, name);
    }

    static void restore(byte[] data, int settings, int page_setup) {
        settingsData = data;
        end = 0;
        start = 0;
        while (end < settingsData.length && settingsData[end] != 0) {
            start = end;
            while (end < settingsData.length && settingsData[end] != 0) {
                ++end;
            }
            byte[] keyBuffer = new byte[++end - start];
            System.arraycopy(settingsData, start, keyBuffer, 0, keyBuffer.length);
            start = end;
            while (end < settingsData.length && settingsData[end] != 0) {
                ++end;
            }
            byte[] valueBuffer = new byte[++end - start];
            System.arraycopy(settingsData, start, valueBuffer, 0, valueBuffer.length);
            OS.gtk_print_settings_set(settings, keyBuffer, valueBuffer);
            if (!DEBUG) continue;
            System.out.println(String.valueOf(new String(Converter.mbcsToWcs(null, keyBuffer))) + ": " + new String(Converter.mbcsToWcs(null, valueBuffer)));
        }
        ++end;
        OS.gtk_page_setup_set_orientation(page_setup, Printer.restoreInt("orientation"));
        OS.gtk_page_setup_set_top_margin(page_setup, Printer.restoreDouble("top_margin"), 3);
        OS.gtk_page_setup_set_bottom_margin(page_setup, Printer.restoreDouble("bottom_margin"), 3);
        OS.gtk_page_setup_set_left_margin(page_setup, Printer.restoreDouble("left_margin"), 3);
        OS.gtk_page_setup_set_right_margin(page_setup, Printer.restoreDouble("right_margin"), 3);
        byte[] name = Printer.restoreBytes("paper_size_name", true);
        byte[] display_name = Printer.restoreBytes("paper_size_display_name", true);
        byte[] ppd_name = Printer.restoreBytes("paper_size_ppd_name", true);
        double width = Printer.restoreDouble("paper_size_width");
        double height = Printer.restoreDouble("paper_size_height");
        boolean custom = Printer.restoreBoolean("paper_size_is_custom");
        int paper_size = 0;
        paper_size = custom ? (ppd_name.length > 0 ? OS.gtk_paper_size_new_from_ppd(ppd_name, display_name, width, height) : OS.gtk_paper_size_new_custom(name, display_name, width, height, 3)) : OS.gtk_paper_size_new(name);
        OS.gtk_page_setup_set_paper_size(page_setup, paper_size);
        OS.gtk_paper_size_free(paper_size);
    }

    static byte[] uriFromFilename(String filename) {
        if (filename == null) {
            return null;
        }
        int length = filename.length();
        if (length == 0) {
            return null;
        }
        char[] chars = new char[length];
        filename.getChars(0, length, chars, 0);
        int[] error = new int[1];
        int utf8Ptr = OS.g_utf16_to_utf8(chars, chars.length, null, null, error);
        if (error[0] != 0 || utf8Ptr == 0) {
            return null;
        }
        int localePtr = OS.g_filename_from_utf8(utf8Ptr, -1, null, null, error);
        OS.g_free(utf8Ptr);
        if (error[0] != 0 || localePtr == 0) {
            return null;
        }
        int uriPtr = OS.g_filename_to_uri(localePtr, 0, error);
        OS.g_free(localePtr);
        if (error[0] != 0 || uriPtr == 0) {
            return null;
        }
        length = OS.strlen(uriPtr);
        byte[] uri = new byte[length + 1];
        OS.memmove(uri, uriPtr, length);
        OS.g_free(uriPtr);
        return uri;
    }

    static DeviceData checkNull(PrinterData data) {
        if (data == null) {
            data = new PrinterData();
        }
        if (data.driver == null || data.name == null) {
            int filePrinter;
            PrinterData defaultData = null;
            if (data.printToFile && (filePrinter = Printer.gtkPrinterFromPrinterData(data)) != 0) {
                defaultData = Printer.printerDataFromGtkPrinter(filePrinter);
                OS.g_object_unref(filePrinter);
            }
            if (defaultData == null && (defaultData = Printer.getDefaultPrinterData()) == null) {
                SWT.error(2);
            }
            data.driver = defaultData.driver;
            data.name = defaultData.name;
        }
        return data;
    }

    public Printer() {
        this(null);
    }

    public Printer(PrinterData data) {
        super(Printer.checkNull(data));
    }

    static int restoreInt(String key) {
        byte[] value = Printer.restoreBytes(key, false);
        return Integer.parseInt(new String(value));
    }

    static double restoreDouble(String key) {
        byte[] value = Printer.restoreBytes(key, false);
        return Double.parseDouble(new String(value));
    }

    static boolean restoreBoolean(String key) {
        byte[] value = Printer.restoreBytes(key, false);
        return Boolean.valueOf(new String(value));
    }

    static byte[] restoreBytes(String key, boolean nullTerminate) {
        start = end;
        while (end < settingsData.length && settingsData[end] != 0) {
            ++end;
        }
        byte[] keyBuffer = new byte[++end - start];
        System.arraycopy(settingsData, start, keyBuffer, 0, keyBuffer.length);
        start = end;
        while (end < settingsData.length && settingsData[end] != 0) {
            ++end;
        }
        int length = end - start;
        ++end;
        if (nullTerminate) {
            ++length;
        }
        byte[] valueBuffer = new byte[length];
        System.arraycopy(settingsData, start, valueBuffer, 0, length);
        if (DEBUG) {
            System.out.println(String.valueOf(new String(Converter.mbcsToWcs(null, keyBuffer))) + ": " + new String(Converter.mbcsToWcs(null, valueBuffer)));
        }
        return valueBuffer;
    }

    @Override
    public int internal_new_GC(GCData data) {
        int gc;
        int drawable = 0;
        if (OS.USE_CAIRO) {
            gc = this.cairo;
        } else {
            GdkVisual visual = new GdkVisual();
            OS.memmove(visual, OS.gdk_visual_get_system());
            drawable = OS.gdk_pixmap_new(OS.gdk_get_default_root_window(), 1, 1, visual.depth);
            gc = OS.gdk_gc_new(drawable);
        }
        if (gc == 0) {
            SWT.error(2);
        }
        if (data != null) {
            int mask;
            if (this.isGCCreated) {
                SWT.error(5);
            }
            if ((data.style & (mask = 0x6000000)) == 0) {
                data.style |= 0x2000000;
            }
            data.device = this;
            data.drawable = drawable;
            data.background = this.getSystemColor((int)1).handle;
            data.foreground = this.getSystemColor((int)2).handle;
            data.font = this.getSystemFont();
            Point dpi = this.getDPI();
            Point screenDPI = this.getIndependentDPI();
            data.width = (int)(OS.gtk_page_setup_get_paper_width(this.pageSetup, 1) * (double)dpi.x / (double)screenDPI.x);
            data.height = (int)(OS.gtk_page_setup_get_paper_height(this.pageSetup, 1) * (double)dpi.y / (double)screenDPI.y);
            if (this.cairo == 0) {
                SWT.error(2);
            }
            Cairo.cairo_identity_matrix(this.cairo);
            double printX = OS.gtk_page_setup_get_left_margin(this.pageSetup, 1);
            double printY = OS.gtk_page_setup_get_top_margin(this.pageSetup, 1);
            Cairo.cairo_translate(this.cairo, printX, printY);
            Cairo.cairo_scale(this.cairo, (float)screenDPI.x / (float)dpi.x, (float)screenDPI.y / (float)dpi.y);
            double[] matrix = new double[6];
            Cairo.cairo_get_matrix(this.cairo, matrix);
            data.identity = matrix;
            data.cairo = this.cairo;
            this.isGCCreated = true;
        }
        return gc;
    }

    @Override
    public void internal_dispose_GC(int hDC, GCData data) {
        int gc = hDC;
        if (data != null) {
            this.isGCCreated = false;
        }
        if (OS.USE_CAIRO) {
            return;
        }
        OS.g_object_unref(gc);
        if (data != null) {
            if (data.drawable != 0) {
                OS.g_object_unref(data.drawable);
            }
            data.cairo = 0;
            data.drawable = 0;
        }
    }

    @Override
    public boolean isAutoScalable() {
        return false;
    }

    public boolean startJob(String jobName) {
        this.checkDevice();
        byte[] buffer = Converter.wcsToMbcs(null, jobName, true);
        this.printJob = OS.gtk_print_job_new(buffer, this.printer, this.settings, this.pageSetup);
        if (this.printJob == 0) {
            return false;
        }
        this.surface = OS.gtk_print_job_get_surface(this.printJob, null);
        if (this.surface == 0) {
            OS.g_object_unref(this.printJob);
            this.printJob = 0;
            return false;
        }
        this.cairo = Cairo.cairo_create(this.surface);
        if (this.cairo == 0) {
            OS.g_object_unref(this.printJob);
            this.printJob = 0;
            return false;
        }
        return true;
    }

    @Override
    protected void destroy() {
        if (this.printer != 0) {
            OS.g_object_unref(this.printer);
        }
        if (this.settings != 0) {
            OS.g_object_unref(this.settings);
        }
        if (this.pageSetup != 0) {
            OS.g_object_unref(this.pageSetup);
        }
        if (this.cairo != 0) {
            Cairo.cairo_destroy(this.cairo);
        }
        if (this.printJob != 0) {
            OS.g_object_unref(this.printJob);
        }
        this.printJob = 0;
        this.cairo = 0;
        this.pageSetup = 0;
        this.settings = 0;
        this.printer = 0;
    }

    public void endJob() {
        this.checkDevice();
        if (this.printJob == 0) {
            return;
        }
        Cairo.cairo_surface_finish(this.surface);
        OS.gtk_print_job_send(this.printJob, 0, 0, 0);
        OS.g_object_unref(this.printJob);
        this.printJob = 0;
    }

    public void cancelJob() {
        this.checkDevice();
        if (this.printJob == 0) {
            return;
        }
        Cairo.cairo_surface_finish(this.surface);
        OS.g_object_unref(this.printJob);
        this.printJob = 0;
    }

    public boolean startPage() {
        this.checkDevice();
        if (this.printJob == 0) {
            return false;
        }
        double width = OS.gtk_page_setup_get_paper_width(this.pageSetup, 1);
        double height = OS.gtk_page_setup_get_paper_height(this.pageSetup, 1);
        int type = Cairo.cairo_surface_get_type(this.surface);
        switch (type) {
            case 2: {
                Cairo.cairo_ps_surface_set_size(this.surface, width, height);
                break;
            }
            case 1: {
                Cairo.cairo_pdf_surface_set_size(this.surface, width, height);
            }
        }
        return true;
    }

    public void endPage() {
        this.checkDevice();
        if (this.cairo != 0) {
            Cairo.cairo_show_page(this.cairo);
        }
    }

    @Override
    public Point getDPI() {
        this.checkDevice();
        int resolution = OS.gtk_print_settings_get_resolution(this.settings);
        if (DEBUG) {
            System.out.println("print_settings.resolution=" + resolution);
        }
        if (resolution == 0) {
            return new Point(72, 72);
        }
        return new Point(resolution, resolution);
    }

    @Override
    public Rectangle getBounds() {
        this.checkDevice();
        Point dpi = this.getDPI();
        Point screenDPI = this.getIndependentDPI();
        double width = OS.gtk_page_setup_get_paper_width(this.pageSetup, 1) * (double)dpi.x / (double)screenDPI.x;
        double height = OS.gtk_page_setup_get_paper_height(this.pageSetup, 1) * (double)dpi.y / (double)screenDPI.y;
        return new Rectangle(0, 0, (int)width, (int)height);
    }

    @Override
    public Rectangle getClientArea() {
        this.checkDevice();
        Point dpi = this.getDPI();
        Point screenDPI = this.getIndependentDPI();
        double width = OS.gtk_page_setup_get_page_width(this.pageSetup, 1) * (double)dpi.x / (double)screenDPI.x;
        double height = OS.gtk_page_setup_get_page_height(this.pageSetup, 1) * (double)dpi.y / (double)screenDPI.y;
        return new Rectangle(0, 0, (int)width, (int)height);
    }

    Point getIndependentDPI() {
        return new Point(72, 72);
    }

    public Rectangle computeTrim(int x, int y, int width, int height) {
        this.checkDevice();
        Point dpi = this.getDPI();
        Point screenDPI = this.getIndependentDPI();
        double printWidth = OS.gtk_page_setup_get_page_width(this.pageSetup, 1) * (double)dpi.x / (double)screenDPI.x;
        double printHeight = OS.gtk_page_setup_get_page_height(this.pageSetup, 1) * (double)dpi.y / (double)screenDPI.y;
        double paperWidth = OS.gtk_page_setup_get_paper_width(this.pageSetup, 1) * (double)dpi.x / (double)screenDPI.x;
        double paperHeight = OS.gtk_page_setup_get_paper_height(this.pageSetup, 1) * (double)dpi.y / (double)screenDPI.y;
        double printX = -OS.gtk_page_setup_get_left_margin(this.pageSetup, 1) * (double)dpi.x / (double)screenDPI.x;
        double printY = -OS.gtk_page_setup_get_top_margin(this.pageSetup, 1) * (double)dpi.y / (double)screenDPI.y;
        double hTrim = paperWidth - printWidth;
        double vTrim = paperHeight - printHeight;
        return new Rectangle(x + (int)printX, y + (int)printY, width + (int)hTrim, height + (int)vTrim);
    }

    @Override
    protected void create(DeviceData deviceData) {
        this.data = (PrinterData)deviceData;
        if (disablePrinting) {
            SWT.error(2);
        }
        this.printer = Printer.gtkPrinterFromPrinterData(this.data);
        if (this.printer == 0) {
            SWT.error(2);
        }
    }

    @Override
    protected void init() {
        byte[] uri;
        this.settings = OS.gtk_print_settings_new();
        this.pageSetup = OS.gtk_page_setup_new();
        if (this.data.otherData != null) {
            Printer.restore(this.data.otherData, this.settings, this.pageSetup);
        }
        if (this.data.printToFile && this.data.fileName != null && (uri = Printer.uriFromFilename(this.data.fileName)) != null) {
            OS.gtk_print_settings_set(this.settings, OS.GTK_PRINT_SETTINGS_OUTPUT_URI, uri);
        }
        OS.gtk_print_settings_set_n_copies(this.settings, this.data.copyCount);
        OS.gtk_print_settings_set_collate(this.settings, this.data.collate);
        if (this.data.duplex != -1) {
            int duplex = this.data.duplex == 1 ? 1 : (this.data.duplex == 2 ? 2 : 0);
            OS.gtk_print_settings_set_duplex(this.settings, duplex);
            String cupsDuplexType = null;
            if (duplex == 1) {
                cupsDuplexType = "DuplexNoTumble";
            } else if (duplex == 2) {
                cupsDuplexType = "DuplexTumble";
            }
            if (cupsDuplexType != null) {
                byte[] keyBuffer = Converter.wcsToMbcs(null, "cups-Duplex", true);
                byte[] valueBuffer = Converter.wcsToMbcs(null, cupsDuplexType, true);
                OS.gtk_print_settings_set(this.settings, keyBuffer, valueBuffer);
            }
        }
        int orientation = this.data.orientation == 2 ? 1 : 0;
        OS.gtk_page_setup_set_orientation(this.pageSetup, orientation);
        OS.gtk_print_settings_set_orientation(this.settings, orientation);
        super.init();
    }

    public PrinterData getPrinterData() {
        this.checkDevice();
        return this.data;
    }
}

