/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.ws.sync.internal.ui;

import com.ibm.cic.agent.core.Agent;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.ws.sync.internal.ui.ImportFix;
import java.util.ArrayList;
import java.util.List;

public class ImportOffering
implements Comparable {
    private final IOffering offering;
    private final List fixes;
    private boolean offeringInInventory;
    private String vendor = null;

    public ImportOffering(IOffering offering, boolean inInventory) {
        this.offering = offering;
        this.fixes = new ArrayList();
        this.offeringInInventory = inInventory;
        if (offering != null) {
            this.vendor = offering.getProperty("vendor.name");
        }
        if (this.vendor == null) {
            this.vendor = "";
        }
    }

    public String getOfferingId() {
        return this.offering != null ? this.offering.getIdentity().getId() : "";
    }

    public IOffering getOffering() {
        return this.offering;
    }

    public void addFix(ImportFix fix) {
        if (!this.fixes.contains(fix)) {
            this.fixes.add(fix);
        }
    }

    public ImportFix[] getFixes() {
        return this.fixes.toArray(new ImportFix[this.fixes.size()]);
    }

    public boolean isOfferingInInventory() {
        return this.offeringInInventory;
    }

    public void setOfferingInInventory(boolean inInventory) {
        this.offeringInInventory = inInventory;
    }

    public String getVendor() {
        return this.vendor;
    }

    public void setVendor(String vendor) {
        this.vendor = vendor;
    }

    public int compareTo(Object arg0) {
        int compareValue;
        if (!(arg0 instanceof ImportOffering)) {
            throw new ClassCastException("Type mismatch: Expecting an ImportOffering object");
        }
        IOffering offering2 = ((ImportOffering)arg0).getOffering();
        if (this.offering == null) {
            compareValue = 1;
        } else if (offering2 == null) {
            compareValue = -1;
        } else if (Agent.isSelfContainedOffering((IOffering)this.offering) && Agent.isExtensionOffering((IOfferingOrFix)offering2)) {
            compareValue = -1;
        } else if (Agent.isSelfContainedOffering((IOffering)offering2) && Agent.isExtensionOffering((IOfferingOrFix)this.offering)) {
            compareValue = 1;
        } else {
            compareValue = this.offering.getIdentity().getId().compareTo(offering2.getIdentity().getId());
            if (compareValue == 0) {
                compareValue = this.offering.compareVersion((IContent)offering2);
            }
        }
        return compareValue;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ImportOffering)) {
            return false;
        }
        return this.offering.equals(((ImportOffering)o).getOffering());
    }

    public int hashCode() {
        return this.offering != null ? this.offering.hashCode() : 0;
    }
}

