/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.xml.core.internal.model.schema;

import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.xml.core.internal.model.schema.ComplexType;
import com.ibm.cic.common.xml.core.internal.model.schema.Multiplicity;
import com.ibm.cic.common.xml.core.internal.model.schema.SchemaFactory;
import com.ibm.cic.common.xml.core.internal.model.schema.Type;
import com.ibm.cic.common.xml.core.internal.model.schema.XMLUtility;
import com.ibm.cic.common.xml.core.model.schema.IAttributeContainer;
import com.ibm.cic.common.xml.core.model.schema.IAttributeDefinition;
import com.ibm.cic.common.xml.core.model.schema.IContainerContainer;
import com.ibm.cic.common.xml.core.model.schema.IElementContainer;
import com.ibm.cic.common.xml.core.model.schema.IElementDefinition;
import com.ibm.cic.common.xml.core.model.schema.IReferencable;
import com.ibm.cic.common.xml.core.model.schema.ISchema;
import java.util.Iterator;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ElementDefinition
extends Type
implements IElementDefinition {
    private IReferencable fType;
    private String fRefTypeName;
    private IElementContainer fParent;
    private final Multiplicity fMulti = new Multiplicity();

    public ElementDefinition(Element domNode, ISchema schema) {
        super(domNode, schema);
        this.readContents();
    }

    @Override
    public void setParent(IElementContainer container) {
        this.fParent = container;
    }

    @Override
    public IElementContainer getParent() {
        return this.fParent;
    }

    private void readContents() {
        String min = this.fNode.getAttribute("minOccurs");
        String max = this.fNode.getAttribute("maxOccurs");
        this.fMulti.setMax(max);
        this.fMulti.setMin(min);
        String type = this.fNode.getAttribute("type");
        this.fRefTypeName = this.fNode.getAttribute("ref");
        if (!XMLUtility.isEmpty(type)) {
            this.fRefTypeName = type;
            return;
        }
        if (!XMLUtility.isEmpty(this.fRefTypeName)) {
            this.getElementType();
            return;
        }
        NodeList _children = this.fNode.getChildNodes();
        int i = 0;
        while (i < _children.getLength()) {
            Node n = _children.item(i);
            if (n.getNodeType() == 1) {
                this.fType = SchemaFactory.createType((Element)n, this.fSchema);
                if (this.fType != null) break;
            }
            ++i;
        }
    }

    @Override
    public String getName() {
        if (this.fName == null) {
            this.getElementType();
        }
        return this.fName;
    }

    public boolean equals(Object o) {
        if (!(o instanceof ElementDefinition)) {
            return false;
        }
        ElementDefinition other = (ElementDefinition)o;
        return other.fName != null && other.fName.equals(this.fName);
    }

    public int hashCode() {
        return Util.hashCode((Object)this.fName);
    }

    @Override
    public Multiplicity getMultiplicity() {
        return this.fMulti;
    }

    @Override
    public String getDocumentation() {
        if (this.getElementType() != null) {
            if (this.fType instanceof ElementDefinition) {
                return ((ElementDefinition)this.fType).getDocumentation();
            }
            if (this.fType instanceof ComplexType) {
                return ((ComplexType)this.fType).getDocumentation();
            }
        }
        return "";
    }

    @Override
    public String getReferenceName() {
        return String.valueOf(this.fSchema.getNamespace()) + ":" + this.fName;
    }

    @Override
    public byte getType() {
        return 6;
    }

    @Override
    public IElementDefinition getElementByName(String name) {
        if (this.getElementType() instanceof IElementContainer) {
            return ((IElementContainer)((Object)this.getElementType())).getElementByName(name);
        }
        return null;
    }

    @Override
    public ISchema getSchema() {
        return this.fSchema;
    }

    @Override
    public void addAttribute(IAttributeDefinition attr) {
        if (this.getElementType() instanceof IAttributeContainer) {
            ((IAttributeContainer)((Object)this.getElementType())).addAttribute(attr);
        }
    }

    @Override
    public Iterator attributeIterator() {
        if (this.getElementType() instanceof IAttributeContainer) {
            return ((IAttributeContainer)((Object)this.getElementType())).attributeIterator();
        }
        return null;
    }

    @Override
    public IElementContainer[] getContainers() {
        if (this.getElementType() instanceof IContainerContainer) {
            return ((IContainerContainer)((Object)this.getElementType())).containerList();
        }
        return null;
    }

    @Override
    public IAttributeDefinition[] getAttributes() {
        if (this.getElementType() instanceof IAttributeContainer) {
            return ((IAttributeContainer)((Object)this.getElementType())).getAttributes();
        }
        return new IAttributeDefinition[0];
    }

    @Override
    public IAttributeDefinition getAttribueDefinition(String name) {
        if (this.getElementType() instanceof IAttributeContainer) {
            return ((IAttributeContainer)((Object)this.getElementType())).getAttribueDefinition(name);
        }
        return null;
    }

    @Override
    public void addElement(IElementDefinition element) {
        if (this.getElementType() instanceof IElementContainer) {
            ((IElementContainer)((Object)this.getElementType())).addElement(element);
        }
    }

    @Override
    public IElementDefinition[] getElements() {
        if (this.getElementType() instanceof IElementContainer) {
            return ((IElementContainer)((Object)this.getElementType())).getElements();
        }
        return new IElementDefinition[0];
    }

    @Override
    public IReferencable getElementType() {
        if (this.fType == null && !XMLUtility.isEmpty(this.fRefTypeName)) {
            this.fType = this.fSchema.getResolver().lookupType(this.fRefTypeName);
            if (this.fType != null && this.fType instanceof IElementDefinition) {
                this.fName = ((IElementDefinition)this.fType).getName();
            }
        }
        return this.fType;
    }

    @Override
    public int getChildElementCount() {
        if (this.getElementType() instanceof IElementContainer) {
            return ((IElementContainer)((Object)this.getElementType())).getChildElementCount();
        }
        return 0;
    }

    @Override
    public boolean isForcedMultiLine() {
        if (this.fType instanceof Type) {
            return ((Type)this.fType).isForcedMultiLine();
        }
        return false;
    }

    public String toString() {
        return this.fRefTypeName;
    }

    @Override
    public IElementDefinition[] getLocalElements() {
        return new IElementDefinition[0];
    }

    @Override
    public boolean isReference() {
        return true;
    }

    @Override
    public String getTypeName() {
        return this.fRefTypeName;
    }
}

