/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm.portable;

import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.CustomNTLM;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.BitUtil;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.DecodeBytes;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.MessageField;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.Messages;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;

public class TargetInfo
extends MessageField {
    private static final Logger log = CustomNTLM.log;
    private static final String TARGET_INFO_NAME = "TargetInfo";
    private static final String MSV_AV_CHANNEL_BINDINGS = "MsvAvChannelBindings";
    private static final String MSV_AV_TARGET_NAME = "MsvAvTargetName";
    private static final String MSV_AV_RESTRICTIONS = "MsvAvRestrictions";
    private static final String MSV_AV_TIMESTAMP = "MsvAvTimestamp";
    private static final String MSV_AV_FLAGS = "MsvAvFlags";
    private static final String MSV_AV_DNS_TREE_NAME = "MsvAvDnsTreeName";
    private static final String MSV_AV_DNS_DOMAIN_NAME = "MsvAvDnsDomainName";
    private static final String MSV_AV_DNS_COMPUTER_NAME = "MsvAvDnsComputerName";
    private static final String MSV_AV_NB_DOMAIN_NAME = "MsvAvNbDomainName";
    private static final String MSV_AV_NB_COMPUTER_NAME = "MsvAvNbComputerName";
    private static final String MSV_AV_EOL = "MsvAvEol";
    public static final int ID_MSV_AV_EOL = 0;
    public static final int ID_MSV_AV_NB_COMPUTER_NAME = 1;
    public static final int ID_MSV_AV_NB_DOMAIN_NAME = 2;
    public static final int ID_MSV_AV_DNS_COMPUTER_NAME = 3;
    public static final int ID_MSV_AV_DNS_DOMAIN_NAME = 4;
    public static final int ID_MSV_AV_DNS_TREE_NAME = 5;
    public static final int ID_MSV_AV_FLAGS = 6;
    public static final int ID_MSV_AV_TIMESTAMP = 7;
    public static final int ID_MSV_AV_RESTRICTIONS = 8;
    public static final int ID_MSV_AV_TARGET_NAME = 9;
    public static final int ID_MSV_AV_CHANNEL_BINDINGS = 10;
    private final AvPairs avPairs = new AvPairs(this);

    public static TargetInfo decodeTargetInfo(DecodeBytes decode) throws DecodeBytes.DecodeBytesException, UnsupportedEncodingException {
        TargetInfo targetInfo = new TargetInfo(decode);
        return targetInfo;
    }

    private TargetInfo(DecodeBytes decode) throws UnsupportedEncodingException, DecodeBytes.DecodeBytesException {
        super(decode, TARGET_INFO_NAME);
    }

    public AVPair[] getAVPairs() {
        return this.avPairs.getAVPairs();
    }

    public AVPair getAVPair(int avId) {
        return this.avPairs.getAVPair(avId);
    }

    static class AVId {
        private final String literal;
        private final int value;

        public AVId(String idLiteral, short idValue) {
            this.literal = idLiteral;
            this.value = idValue;
        }

        public String getLiteral() {
            return this.literal;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            return this.literal;
        }
    }

    static class AVPair {
        private final AVId id;
        private final byte[] data;
        private Object value;

        public AVPair(String idLiteral, short idValue, byte[] data) {
            this.id = new AVId(idLiteral, idValue);
            this.data = data;
        }

        public void setValue(Object obj) {
            this.value = obj;
        }

        public AVId getId() {
            return this.id;
        }

        public byte[] getData() {
            return this.data;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.id);
            if (this.value != null) {
                sb.append(" '");
                sb.append(this.value);
                sb.append("'");
            }
            sb.append(" [");
            sb.append(BitUtil.bytesToHexString(this.data)).append("]");
            return sb.toString();
        }
    }

    static class AvPairs {
        ArrayList pairs = new ArrayList();

        public AvPairs(MessageField field) throws UnsupportedEncodingException, DecodeBytes.DecodeBytesException {
            if (field.getLen() == 0) {
                return;
            }
            DecodeBytes decode = new DecodeBytes(field.getData());
            this.decode(decode);
        }

        public AVPair[] getAVPairs() {
            return this.pairs.toArray(new AVPair[this.pairs.size()]);
        }

        public AVPair getAVPair(int avId) {
            for (AVPair pair : this.pairs) {
                if (pair.getId().getValue() != avId) continue;
                return pair;
            }
            return null;
        }

        private void decode(DecodeBytes decode) throws UnsupportedEncodingException, DecodeBytes.DecodeBytesException {
            AVPair pair;
            do {
                pair = this.decodeNextAvPair(decode);
                this.pairs.add(pair);
            } while (pair.getId().getValue() != 0);
        }

        private AVPair decodeNextAvPair(DecodeBytes decode) throws UnsupportedEncodingException, DecodeBytes.DecodeBytesException {
            short idValue = decode.getNextShort();
            switch (idValue) {
                case 0: {
                    short len = decode.getNextLen();
                    if (len != 0) {
                        log.error(Messages.TargetInfo_MsvEOLwithBadLen, new Object[]{len});
                    }
                    byte[] data = decode.getNextBytes(len);
                    return new AVPair(TargetInfo.MSV_AV_EOL, idValue, data);
                }
                case 1: {
                    return this.decodeUnicodeStringAVPair(decode, TargetInfo.MSV_AV_NB_COMPUTER_NAME, idValue);
                }
                case 2: {
                    return this.decodeUnicodeStringAVPair(decode, TargetInfo.MSV_AV_NB_DOMAIN_NAME, idValue);
                }
                case 3: {
                    return this.decodeUnicodeStringAVPair(decode, TargetInfo.MSV_AV_DNS_COMPUTER_NAME, idValue);
                }
                case 4: {
                    return this.decodeUnicodeStringAVPair(decode, TargetInfo.MSV_AV_DNS_DOMAIN_NAME, idValue);
                }
                case 5: {
                    return this.decodeUnicodeStringAVPair(decode, TargetInfo.MSV_AV_DNS_TREE_NAME, idValue);
                }
                case 6: {
                    short len = decode.getNextLen();
                    byte[] data = decode.getNextBytes(len);
                    return new AVPair(TargetInfo.MSV_AV_FLAGS, idValue, data);
                }
                case 7: {
                    short len = decode.getNextLen();
                    byte[] data = decode.getNextBytes(len);
                    return new AVPair(TargetInfo.MSV_AV_TIMESTAMP, idValue, data);
                }
                case 8: {
                    short len = decode.getNextLen();
                    byte[] data = decode.getNextBytes(len);
                    return new AVPair(TargetInfo.MSV_AV_RESTRICTIONS, idValue, data);
                }
                case 9: {
                    return this.decodeUnicodeStringAVPair(decode, TargetInfo.MSV_AV_TARGET_NAME, idValue);
                }
                case 10: {
                    short len = decode.getNextLen();
                    byte[] data = decode.getNextBytes(len);
                    return new AVPair(TargetInfo.MSV_AV_CHANNEL_BINDINGS, idValue, data);
                }
            }
            short len = decode.getNextLen();
            log.error(Messages.TargetInfo_foundUnknownAVPair, new Object[]{idValue});
            byte[] data = decode.getNextBytes(len);
            return new AVPair("MsvAvUNKNOWN", idValue, data);
        }

        private AVPair decodeUnicodeStringAVPair(DecodeBytes decode, String idLiteral, short idValue) throws UnsupportedEncodingException, DecodeBytes.DecodeBytesException {
            Short slen = null;
            byte[] data = null;
            try {
                short len = decode.getNextLen();
                slen = len;
                data = decode.getNextBytes(len);
            }
            catch (RuntimeException e) {
                if (slen == null) {
                    throw new DecodeBytes.DecodeBytesException(NLS.bind((String)Messages.TargetInfo_AVPairTruncated, (Object)idLiteral, (Object)idValue), e);
                }
                throw new DecodeBytes.DecodeBytesException(NLS.bind((String)Messages.TargetInfo_AVPairTruncatedOrBadLength, (Object[])new Object[]{idLiteral, idValue, slen}), e);
            }
            try {
                NTLMDecodeUnicodeString decodeUnicode = new NTLMDecodeUnicodeString(data);
                AVPair avp = new AVPair(idLiteral, idValue, data);
                avp.setValue(decodeUnicode.getString());
                return avp;
            }
            catch (RuntimeException e) {
                throw new DecodeBytes.DecodeBytesException(NLS.bind((String)Messages.TargetInfo_AVPairNotValidUnicode, (Object[])new Object[]{idLiteral, idValue, BitUtil.bytesToHexString(data)}));
            }
        }
    }

    static class NTLMDecodeUnicodeString
    extends DecodeBytes {
        private final String s;

        public NTLMDecodeUnicodeString(byte[] bytes) throws UnsupportedEncodingException {
            super(bytes);
            if (bytes.length % 2 != 0) {
                throw new IllegalArgumentException();
            }
            this.s = new String(bytes, "UTF-16LE");
        }

        public String getString() {
            return this.s;
        }
    }
}

