/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient.internal.ntlm.portable;

import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.CustomNTLM;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.ChallengeMessage;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.DecodeBytes;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.LogNTLMMessage;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.Messages;
import com.ibm.cic.common.transports.httpclient.internal.ntlm.portable.NTLMCrypto;
import com.ibm.cic.common.transports.httpclient.ntlm.INTLMAuthGenerator;
import com.ibm.cic.common.transports.httpclient.ntlm.NTLMAuthGeneratorException;
import com.ibm.cic.common.transports.httpclient.ntlm.NTLMUserCredentials;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.security.GeneralSecurityException;
import org.apache.commons.httpclient.auth.AuthenticationException;

public abstract class AbstractNTLMMessageGenerator
implements INTLMAuthGenerator {
    public static final Logger log = CustomNTLM.log;
    protected NTLMUserCredentials userCredentials;
    protected String clientWorkStation;
    protected byte[] lmChallengeResponse;
    protected byte[] ntChallengeResponse;
    protected ChallengeMessage challenge;

    public AbstractNTLMMessageGenerator(NTLMUserCredentials userCredentials, String clientWorkStation) {
        this.userCredentials = userCredentials;
        this.clientWorkStation = clientWorkStation;
    }

    @Override
    public byte[] genType1Message() throws NTLMAuthGeneratorException {
        try {
            byte[] bytes = this.createNegotiateMessage();
            return bytes;
        }
        catch (IOException e) {
            throw new NTLMAuthGeneratorException("NTLM negotiate message could not be created", e);
        }
    }

    protected abstract byte[] createNegotiateMessage() throws IOException;

    @Override
    public byte[] genType3Message(byte[] bChallenge) throws NTLMAuthGeneratorException {
        try {
            this.challenge = ChallengeMessage.decode(bChallenge);
            if (log.isDebugLoggable()) {
                LogNTLMMessage.logFlags(log, 2, this.challenge.getNegotiateFlags());
            }
            byte[] authenticate = this.computeAuthenticateMessage();
            return authenticate;
        }
        catch (DecodeBytes.DecodeBytesException e) {
            throw new NTLMAuthGeneratorException(NLS.bind((String)Messages.AbstractNTLMMessageGenerator_cantDecodeChallenge, (Object)e), e);
        }
        catch (UnsupportedEncodingException e) {
            throw new NTLMAuthGeneratorException(NLS.bind((String)Messages.AbstractNTLMMessageGenerator_cantDecodeChallenge, (Object)e), e);
        }
        catch (GeneralSecurityException e) {
            throw new NTLMAuthGeneratorException(NLS.bind((String)Messages.AbstractNTLMMessageGenerator_cantDecodeChallenge, (Object)e), e);
        }
        catch (IOException e) {
            throw new NTLMAuthGeneratorException(NLS.bind((String)Messages.AbstractNTLMMessageGenerator_cantDecodeChallenge, (Object)e), e);
        }
    }

    protected abstract byte[] computeAuthenticateMessage() throws UnsupportedEncodingException, GeneralSecurityException, DecodeBytes.DecodeBytesException, IOException;

    protected static byte[] genRandom(ChallengeMessage challenge) throws AuthenticationException {
        try {
            byte[] random = NTLMCrypto.getClientNonceProvider().nonce(challenge);
            assert (random.length == 8);
            return random;
        }
        catch (Exception e) {
            throw new AuthenticationException("NTLM authentication failed. Could not compute random number", (Throwable)e);
        }
    }
}

