/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.transports.httpclient;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.downloads.SocketEvents;
import com.ibm.cic.common.downloads.handlerImpl.DownloadCancelMonitorPerThread;
import java.io.IOException;
import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Socket;
import java.net.SocketTimeoutException;
import java.net.UnknownHostException;
import javax.net.SocketFactory;
import org.apache.commons.httpclient.params.HttpConnectionParams;
import org.apache.commons.httpclient.protocol.ProtocolSocketFactory;

public class EventFiringProtocolSocketFactory
implements ProtocolSocketFactory {
    public Socket createSocket(String host, int port, InetAddress clientHost, int clientPort) throws IOException, UnknownHostException {
        InetSocketAddress remoteInetAddress = new InetSocketAddress(host, port);
        InetSocketAddress localInetAddress = new InetSocketAddress(clientHost, clientPort);
        return this.createSocket(remoteInetAddress, localInetAddress, 0);
    }

    public Socket createSocket(String host, int port, InetAddress localAddress, int localPort, HttpConnectionParams params) throws IOException, UnknownHostException, SocketTimeoutException {
        InetSocketAddress remoteInetAddress = new InetSocketAddress(host, port);
        InetSocketAddress localInetAddress = new InetSocketAddress(localAddress, localPort);
        return this.createSocket(remoteInetAddress, localInetAddress, params);
    }

    private Socket createSocket(InetSocketAddress remoteInetAddress, InetSocketAddress localInetAddress, HttpConnectionParams params) throws IOException, UnknownHostException, SocketTimeoutException {
        if (params == null) {
            throw new IllegalArgumentException("Parameters may not be null");
        }
        int timeout = params.getConnectionTimeout();
        return this.createSocket(remoteInetAddress, localInetAddress, timeout);
    }

    private Socket createSocket() throws IOException {
        SocketFactory socketfactory = SocketFactory.getDefault();
        Socket socket = socketfactory.createSocket();
        if (CicCommonSettings.isWindowsVista()) {
            socket.setReuseAddress(true);
        }
        return socket;
    }

    private Socket createSocket(InetSocketAddress remoteInetAddress, InetSocketAddress localInetAddress, int timeout) throws IOException {
        Socket socket = this.createSocket();
        SocketEvents.SocketToConnect stc = new SocketEvents.SocketToConnect(socket, remoteInetAddress, localInetAddress);
        try {
            SocketEvents.FIRE.onBeforeSocketConnected(stc);
            socket.bind(localInetAddress);
            socket.connect(remoteInetAddress, timeout);
        }
        catch (IOException e) {
            SocketEvents.FIRE.onSocketConnectFailed(stc, (Throwable)e);
            throw e;
        }
        SocketEvents.FIRE.onSocketConnected(stc);
        return new SocketEvents.SocketEventEmittingWrapper(socket, DownloadCancelMonitorPerThread.INSTANCE.getThreadCancelMonitor());
    }

    public Socket createSocket(String host, int port) throws IOException, UnknownHostException {
        InetSocketAddress remoteInetAddress = host != null ? new InetSocketAddress(host, port) : new InetSocketAddress(InetAddress.getByName(null), port);
        InetSocketAddress localInetAddress = new InetSocketAddress(0);
        return this.createSocket(remoteInetAddress, localInetAddress, 0);
    }

    public boolean equals(Object obj) {
        return obj != null && obj.getClass().equals(this.getClass());
    }

    public int hashCode() {
        return EventFiringProtocolSocketFactory.class.hashCode();
    }
}

