/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.p2EclipseAdapterData.internal;

import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.IAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IAdapterDataParser;
import com.ibm.cic.common.core.model.adapterdata.IAdapterDataResolver;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IErrorReporter;
import com.ibm.cic.common.core.model.adapterdata.IInstallSizeInfo;
import com.ibm.cic.common.core.model.adapterdata.SizeInfoParserHelper;
import com.ibm.cic.common.downloads.SizeInfo;
import com.ibm.cic.common.p2EclipseAdapterData.IP2ReferenceData;
import com.ibm.cic.common.p2EclipseAdapterData.P2EclipseAdapterData;
import com.ibm.cic.common.p2EclipseAdapterData.P2ReferenceData;
import com.ibm.cic.common.p2EclipseAdapterData.P2SizeInfoData;
import com.ibm.cic.common.p2EclipseAdapterData.internal.IXMLConstants;
import com.ibm.cic.common.p2EclipseAdapterData.internal.P2ArtifactResolver;
import java.net.URL;
import org.xml.sax.Attributes;

public class P2EclipseAdapterDataParser
implements IXMLConstants,
IAdapterDataParser {
    private P2EclipseAdapterData fData;
    private IErrorReporter fReporter;
    private SizeInfoParserHelper fCommonParser;

    public Object getAdapter(Class adapter) {
        if (adapter.equals(IAdapterDataResolver.class)) {
            return P2ArtifactResolver.getInstance();
        }
        if (adapter.isInstance(this)) {
            return this;
        }
        return null;
    }

    public void characters(String chars) {
    }

    public void endArtifact() {
    }

    public void endElement(String uri, String name, String name2) {
    }

    public IAdapterData getAdapterData() {
        return this.fData;
    }

    public URL getSchema() {
        return null;
    }

    public void initialize(IInstallableUnit parentIU, IErrorReporter reporter) {
        this.fReporter = reporter;
        this.fData = new P2EclipseAdapterData();
        this.fCommonParser = new SizeInfoParserHelper(reporter);
    }

    public void addSizeInfo(final SizeInfo sizeInfo) {
        this.fData.addInstallSizeInfo(new IInstallSizeInfo(){

            public IArtifact getArtifact() {
                return null;
            }

            public long getInstallSize() {
                return sizeInfo.getInstallSize();
            }
        }, false);
    }

    public IArtifact startArtifact(String uri, String name, String name2, Attributes attributes, String key) {
        this.fReporter.unexpectedElement(name, attributes);
        return null;
    }

    public IArtifact startArtifactNoKey(String uri, String name, String name2, Attributes attributes, ArtifactCommonAttributes aca) {
        this.fReporter.unexpectedElement(name, attributes);
        return null;
    }

    public void startElement(String uri, String name, String name2, Attributes attributes) {
        if ("p2Unit".equals(name)) {
            this.fReporter.checkRequiredAttribute(name, "id", (Object)attributes.getValue("id"));
            this.fReporter.checkRequiredAttribute(name, "version", (Object)attributes.getValue("version"));
            String id = attributes.getValue("id");
            String ver = attributes.getValue("version");
            if (id != null && ver != null) {
                P2ReferenceData dat = new P2ReferenceData(id, ver);
                this.fData.addData(dat);
                this.setForceInstallAttribute(dat, name, attributes);
                SizeInfo sizeInfo = new SizeInfo();
                Long l = this.getLongAttribute(name, "downloadSize", attributes);
                if (l != null) {
                    sizeInfo.setDownloadSize(l.longValue());
                }
                if ((l = this.getLongAttribute(name, "installSize", attributes)) != null) {
                    sizeInfo.setInstallSize(l.longValue());
                }
                dat.setSizeInfo(sizeInfo);
            }
        } else if ("sizeInfo".equals(name)) {
            IInstallSizeInfo installSizeInfo = this.fCommonParser.parseSizeInfoElement(name, name2, attributes);
            if (installSizeInfo != null) {
                this.addSizeInfo(installSizeInfo);
            }
        } else {
            this.fReporter.unexpectedElement(name, attributes);
        }
    }

    private void setForceInstallAttribute(P2ReferenceData dat, String name, Attributes attributes) {
        String value = attributes.getValue("forceInstall");
        if (value != null) {
            value = value.trim();
            try {
                dat.setForceInstall(value);
            }
            catch (IllegalArgumentException e) {
                this.fReporter.invalidAttributeValue(name, "forceInstall", value);
                this.fReporter.error(e.toString());
            }
        } else {
            dat.setForceInstall(IP2ReferenceData.ForceInstall.DEFAULT);
        }
    }

    private Long getLongAttribute(String name, String attrName, Attributes attributes) {
        String value = attributes.getValue(attrName);
        if (value != null) {
            value = value.trim();
            try {
                long l = Long.parseLong(value);
                return l;
            }
            catch (NumberFormatException e) {
                this.fReporter.invalidAttributeValue(name, attrName, value);
            }
        }
        return null;
    }

    private void addSizeInfo(IInstallSizeInfo installSizeInfo) {
        P2SizeInfoData data = new P2SizeInfoData(installSizeInfo);
        this.fData.addData(data);
        boolean isActive = true;
        this.fData.addInstallSizeInfo(installSizeInfo, isActive);
    }
}

