/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.p2.model.internal;

import com.ibm.cic.p2.model.IFilterNode;
import com.ibm.cic.p2.model.IFilterParser;
import com.ibm.cic.p2.model.internal.FilterExpression;
import com.ibm.cic.p2.model.internal.FilterNode;
import com.ibm.cic.p2.model.internal.FilterOperator;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FilterParser
implements IFilterParser {
    private static final String ERR_MSG = "The filter expression is not well formed.";
    private char[] fFilterChars;
    private int fPos;
    private FilterNode fActive;
    private IFilterNode fRoot;
    private byte fState;
    private static final byte STATE_INITIAL = 0;
    private static final byte STATE_EXPR = 1;
    private static final byte STATE_OP = 2;
    private static final byte STATE_END = 3;

    @Override
    public IFilterNode parse(String filter) throws CoreException {
        this.fActive = null;
        this.fState = 0;
        this.fFilterChars = filter.trim().toCharArray();
        while (this.fPos < this.fFilterChars.length) {
            switch (this.fFilterChars[this.fPos]) {
                case '(': {
                    this.startNode();
                    break;
                }
                case ')': {
                    this.endNode();
                    ++this.fPos;
                    this.skipSpaces();
                    break;
                }
                default: {
                    throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", ERR_MSG));
                }
            }
        }
        return this.fRoot;
    }

    private void tryChangeState(byte newState) throws CoreException {
        if (this.fState == 3) {
            throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", ERR_MSG));
        }
        switch (newState) {
            case 1: {
                if (this.fState == 0 || this.fState == 2) break;
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", ERR_MSG));
            }
            case 2: {
                if (this.fState == 0 || this.fState == 2) break;
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", ERR_MSG));
            }
            case 3: {
                break;
            }
            default: {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", "Attempt to change state to unknown value.  Internal Error."));
            }
        }
    }

    private void startNode() throws CoreException {
        IFilterNode node = null;
        this.skipSpaces();
        if (this.isPosValid(this.fPos + 1)) {
            ++this.fPos;
            switch (this.fFilterChars[this.fPos]) {
                case '&': {
                    ++this.fPos;
                    this.tryChangeState((byte)2);
                    node = new FilterOperator(6);
                    break;
                }
                case '|': {
                    ++this.fPos;
                    this.tryChangeState((byte)2);
                    node = new FilterOperator(5);
                    break;
                }
                case '!': {
                    ++this.fPos;
                    this.tryChangeState((byte)2);
                    node = new FilterOperator(7);
                    break;
                }
                default: {
                    this.tryChangeState((byte)1);
                    node = this.readExpression();
                }
            }
        }
        this.skipSpaces();
        if (this.fActive == null) {
            this.fActive = (FilterNode)node;
            this.fRoot = node;
        } else {
            this.fActive.addChild(node);
            this.fActive = (FilterNode)node;
        }
    }

    private void endNode() throws CoreException {
        if (this.fActive != null) {
            IFilterNode parent = this.fActive.getParent();
            if (parent != null) {
                if (parent.getType() == 2) {
                    this.fState = (byte)2;
                    this.fActive = (FilterNode)parent;
                    return;
                }
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", ERR_MSG));
            }
            this.tryChangeState((byte)3);
            return;
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", ERR_MSG));
    }

    private IFilterNode readExpression() throws CoreException {
        this.skipSpaces();
        String name = this.readNextStringPart();
        byte comp = this.readCompPart();
        String val = this.readNextStringPart();
        FilterExpression exp = new FilterExpression(name, val, comp);
        return exp;
    }

    private byte readCompPart() throws CoreException {
        this.skipSpaces();
        switch (this.fFilterChars[this.fPos]) {
            case '=': {
                if (this.isPosValid(this.fPos + 1)) {
                    ++this.fPos;
                }
                return 10;
            }
            case '<': {
                if (this.isPosValid(this.fPos + 1)) {
                    ++this.fPos;
                }
                return 13;
            }
            case '>': {
                if (this.isPosValid(this.fPos + 1)) {
                    ++this.fPos;
                }
                return 12;
            }
            case '~': {
                if (this.isPosValid(this.fPos + 1)) {
                    ++this.fPos;
                }
                return 11;
            }
        }
        throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", "Unexpected charater found for operation in filter expression."));
    }

    private String readNextStringPart() throws CoreException {
        this.skipSpaces();
        StringBuffer part = new StringBuffer();
        while (!this.isControlChar(this.fFilterChars[this.fPos]) && !Character.isWhitespace(this.fFilterChars[this.fPos])) {
            part.append(this.fFilterChars[this.fPos]);
            if (!this.isPosValid(this.fPos + 1)) {
                throw new CoreException((IStatus)new Status(4, "com.ibm.cic.p2.model", "Unexpected termination of filter."));
            }
            ++this.fPos;
        }
        this.skipSpaces();
        return part.toString();
    }

    private boolean isControlChar(char c) {
        return c == '<' || c == '>' || c == '=' || c == '~' || c == '(' || c == ')';
    }

    private void skipSpaces() {
        while (this.isPosValid(this.fPos)) {
            if (!Character.isWhitespace(this.fFilterChars[this.fPos])) {
                return;
            }
            ++this.fPos;
        }
    }

    private boolean isPosValid(int pos) {
        return pos >= 0 && pos < this.fFilterChars.length;
    }
}

