/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging.parser;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.utils.XMLParser;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.logging.parser.EntryRecord;
import com.ibm.cic.common.logging.parser.LogRecord;
import com.ibm.cic.common.logging.parser.MessageRecord;
import com.ibm.cic.common.logging.parser.Messages;
import com.ibm.cic.common.logging.parser.StackRecord;
import com.ibm.icu.util.StringTokenizer;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.ParserConfigurationException;
import org.osgi.framework.BundleContext;
import org.xml.sax.Attributes;
import org.xml.sax.SAXException;
import org.xml.sax.helpers.DefaultHandler;

public class CicLogParser
extends XMLParser {
    private static final String ERROR_PREFIX = "ERROR:";
    private static final String WARNING_PREFIX = "WARNING:";
    private static final String INFO_PREFIX = "INFO:";
    private LogRecord logRecord;
    private EntryRecord currentEntry;

    public CicLogParser() {
        this(ComIbmCicCommonCorePlugin.getBundleContext());
    }

    public CicLogParser(BundleContext context) {
        super(context, ComIbmCicCommonCorePlugin.getPluginId());
    }

    public synchronized LogRecord parse(File logFile) throws IOException, ParserConfigurationException {
        this.logRecord = new LogRecord(logFile);
        try (FileInputStream in = new FileInputStream(logFile);){
            try {
                this.getParser().parse((InputStream)in, (DefaultHandler)this);
            }
            catch (SAXException sAXException) {
                ((InputStream)in).close();
            }
        }
        return this.logRecord;
    }

    @Override
    public void startDocument() {
    }

    @Override
    public void endDocument() {
    }

    @Override
    public void startElement(String uri, String name, String qName, Attributes attributes) {
        String finishedChars = this.finishCharacters();
        if (name.equals("log")) {
            this.parseLogAttributes(attributes);
        } else if (name.equals("entry")) {
            this.parseEntryAttributes(attributes);
        } else if (name.equals("message")) {
            this.parseMessageAttributes(attributes);
        } else if (name.equals("stack")) {
            if (finishedChars != null && this.currentEntry != null) {
                this.currentEntry.getThrownRecord().setThrown(finishedChars);
            }
        } else if (!(name.equals("logger") || name.equals("class") || name.equals("method") || name.equals("key") || name.equals("arg") || name.equals("exception"))) {
            this.unexpectedElement(name, attributes);
        }
    }

    private void parseLogAttributes(Attributes attrs) {
        int i = 0;
        while (i < attrs.getLength()) {
            String name = attrs.getLocalName(i);
            String value = attrs.getValue(i);
            if (name.equals("start")) {
                this.logRecord.setStartTime(value);
            }
            ++i;
        }
    }

    private void parseMessageAttributes(Attributes attrs) {
        int i = 0;
        while (i < attrs.getLength()) {
            String name = attrs.getLocalName(i);
            String value = attrs.getValue(i);
            if (name.equals("href") && this.currentEntry != null) {
                this.currentEntry.getMessageRecord().setHref(value);
            }
            ++i;
        }
    }

    private void parseEntryAttributes(Attributes attrs) {
        int num = 0;
        long time = 0L;
        String elapsedTime = null;
        int level = Level.MIN;
        String threadName = null;
        String uid = null;
        int i = 0;
        while (i < attrs.getLength()) {
            String name = attrs.getLocalName(i);
            String value = attrs.getValue(i);
            if (name.equals("num")) {
                num = Integer.parseInt(value);
            } else if (name.equals("time")) {
                time = Long.parseLong(value);
            } else if (name.equals("level")) {
                level = Level.getLevel(value);
            } else if (name.equals("elapsed")) {
                elapsedTime = value;
            } else if (name.equals("thread")) {
                threadName = value;
            } else if (!name.equals("startNum")) {
                if (name.equals("uid")) {
                    uid = value;
                } else {
                    this.unexpectedAttribute("entry", name, value);
                }
            }
            ++i;
        }
        this.currentEntry = level == Level.DEBUG ? null : new EntryRecord(num, time, level, elapsedTime, threadName, uid);
    }

    @Override
    public void endElement(String uri, String name, String qName) {
        if (this.currentEntry == null) {
            return;
        }
        String chars = this.finishCharacters();
        if (name.equals("entry")) {
            this.logRecord.addRecord(this.currentEntry);
            this.currentEntry = null;
        } else if (name.equals("logger")) {
            this.currentEntry.setLogger(chars);
        } else if (name.equals("class")) {
            this.currentEntry.setCallingClass(chars);
        } else if (name.equals("method")) {
            this.currentEntry.setCallingMethod(chars);
        } else if (name.equals("message")) {
            if (chars != null) {
                StringTokenizer tokenizer = new StringTokenizer(chars, LogUtil.NEWLINE);
                if (tokenizer.countTokens() > 1) {
                    boolean firstToken = true;
                    while (tokenizer.hasMoreTokens()) {
                        EntryRecord entry;
                        String msg = tokenizer.nextToken().trim();
                        if (msg.length() == 0) continue;
                        if (firstToken) {
                            entry = this.currentEntry;
                            firstToken = false;
                        } else {
                            entry = new EntryRecord(this.currentEntry);
                            this.currentEntry.addChild(entry);
                        }
                        if (msg.startsWith(ERROR_PREFIX)) {
                            entry.setLevel(Level.ERROR);
                            msg = msg.substring(ERROR_PREFIX.length());
                        } else if (msg.startsWith(WARNING_PREFIX)) {
                            entry.setLevel(Level.WARNING);
                            msg = msg.substring(WARNING_PREFIX.length());
                        } else if (msg.startsWith(INFO_PREFIX)) {
                            entry.setLevel(Level.INFO);
                            msg = msg.substring(INFO_PREFIX.length());
                        }
                        entry.getMessageRecord().setMessage(msg);
                    }
                } else {
                    MessageRecord msgRecord = this.currentEntry.getMessageRecord();
                    msgRecord.setMessage(chars);
                }
            }
        } else if (name.equals("key")) {
            this.currentEntry.getMessageRecord().setMessage(chars);
        } else if (name.equals("arg")) {
            this.currentEntry.getMessageRecord().addArg(chars);
        } else if (name.equals("stack")) {
            StackRecord stack = new StackRecord(chars);
            this.currentEntry.getThrownRecord().addStack(stack);
        }
    }

    @Override
    protected String getErrorMessage() {
        return Messages.CicLogParser_error_parsing_log_record;
    }

    @Override
    protected Logger getLogger() {
        return Logger.getLogger(CicLogParser.class);
    }

    @Override
    protected Object getRootObject() {
        return this.logRecord.getLogFile();
    }

    @Override
    protected String processCharacters(String trimmedChars) {
        return trimmedChars;
    }
}

