/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.LogEntry;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.cic.common.logging.StreamLog;
import com.ibm.cic.common.logging.XMLFormatter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.RandomAccessFile;
import java.util.LinkedList;

public class FileLog
extends StreamLog {
    private static final Logger log = Logger.getLogger(FileLog.class);
    public static final String LOG_EXTENSION = ".xml";
    public static final String LOG_XSL_FILE = "log.xsl";
    private static final String INDEX_FILE = "index.xml";
    private static final String INDEX_XSL_FILE = "index.xsl";
    private static final String INDEX_START_ELEMENT = "<logs>" + LogUtil.NEWLINE;
    private static final String INDEX_END_ELEMENT = "</logs>" + LogUtil.NEWLINE;
    private File file;
    private RandomAccessFile raf;
    private long lastEntryEnd;
    private LinkedList generatedFiles;
    private final XMLFormatter formatter;
    private final long startTime = System.currentTimeMillis();
    private int entries;
    private int errors;
    private int warnings;

    public FileLog() {
        this.formatter = new XMLFormatter(this.startTime);
        this.init();
    }

    public FileLog(File file) throws IOException {
        this();
        if (file != null) {
            this.setFile(file, false);
        }
    }

    private void init() {
        this.file = null;
        this.raf = null;
        this.lastEntryEnd = -1L;
        this.generatedFiles = new LinkedList();
        this.entries = 0;
        this.errors = 0;
        this.warnings = 0;
    }

    @Override
    public String format(LogEntry entry) {
        return this.formatter.format(entry);
    }

    public String toString() {
        return this.file == null ? "<no file>" : this.file.toString();
    }

    @Override
    public synchronized void logEntry(LogEntry entry) {
        if (this.writer != null) {
            try {
                String href;
                if (this.lastEntryEnd != -1L) {
                    this.raf.seek(this.lastEntryEnd);
                }
                if ((href = entry.getHref()) != null && this.getFile() != null) {
                    String logDir;
                    File hrefFile = new File(href);
                    if (hrefFile.isFile()) {
                        href = hrefFile.toURI().toURL().toString();
                    }
                    if (href.startsWith(logDir = this.getFile().getParentFile().toURI().toURL().toString())) {
                        entry.setHref(href.substring(logDir.length()));
                    }
                }
                super.logEntry(entry);
                this.lastEntryEnd = this.raf.getFilePointer();
                this.writer.write(this.formatter.getTail());
                this.flush();
                if (entry.getLevel() == Level.ERROR) {
                    ++this.errors;
                } else if (entry.getLevel() == Level.WARNING) {
                    ++this.warnings;
                }
                ++this.entries;
            }
            catch (IOException e) {
                FileLog.reportError(e);
            }
        }
    }

    public File getFile() {
        return this.file;
    }

    public void setFile(File file, boolean append) throws IOException {
        this.raf = new RandomAccessFile(file, "rw");
        if (append) {
            this.raf.seek(this.raf.length());
        }
        FileOutputStream fos = new FileOutputStream(this.raf.getFD());
        this.setOutputStream(fos);
        if (this.file == null) {
            this.writer.write(this.formatter.getHead(this.getXslFile(), this.getEncoding()));
            this.writer.flush();
        }
        this.file = file;
    }

    public int getErrorCount() {
        return this.errors;
    }

    public int getWarningCount() {
        return this.warnings;
    }

    protected String getXslFile() {
        return LOG_XSL_FILE;
    }

    /*
     * Unable to fully structure code
     */
    public void setDirectory(File dir) {
        if (this.file == null) {
            logFile = this.getLogFile(dir);
            FileLog.log.debug("New log file: {0}", new Object[]{logFile});
            try {
                this.setFile(logFile, false);
            }
            catch (Exception e) {
                FileLog.reportError(e);
                if (logFile != null) ** GOTO lbl25
                return;
            }
        } else {
            if (this.file.getParentFile().equals(dir)) {
                return;
            }
            for (File generatedFile : this.generatedFiles) {
                if (generatedFile == null) continue;
                FileLog.log.debug("Delete generated file: {0}", new Object[]{generatedFile});
                generatedFile.delete();
            }
            this.generatedFiles.clear();
            this.move(this.getLogFile(dir));
            FileLog.log.note(Messages.FileLog_Log_File, new Object[]{this.getFile()});
        }
lbl25:
        // 3 sources

        this.generatedFiles.add(this.createXSL("log.xsl"));
        this.generatedFiles.add(this.addToIndex());
        this.generatedFiles.add(this.createXSL("index.xsl"));
    }

    public void resetDirectory() {
        this.close();
        this.init();
    }

    @Override
    public synchronized void close() {
        if (this.raf != null && this.file != null) {
            this.tempClose();
            this.updateIndex();
        }
    }

    private void tempClose() {
        try {
            this.raf.close();
        }
        catch (IOException e) {
            ExceptionUtil.debugLogIOException(e);
        }
        super.close();
    }

    private void move(File toFile) {
        File fromFile = this.file;
        log.debug("Move log file from {0} to {1}", fromFile, toFile);
        if (fromFile.equals(toFile)) {
            return;
        }
        try {
            this.tempClose();
            FileUtil.mv(fromFile, toFile, true, null);
            this.setFile(toFile, true);
            if (fromFile.exists()) {
                log.warning(Messages.FileLog_Failed_To_Delete, fromFile);
            }
            Util.deleteEmptyDirs(fromFile.getParentFile());
        }
        catch (IOException e) {
            FileLog.reportError(e);
            this.tempClose();
            try {
                this.setFile(fromFile, true);
            }
            catch (IOException e2) {
                FileLog.reportError(e2);
            }
        }
    }

    private File addToIndex() {
        String contents;
        boolean createdFile = false;
        File indexFile = new File(this.file.getParentFile(), INDEX_FILE);
        if (indexFile.exists()) {
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(indexFile);
                    contents = FileUtil.readStream(in);
                }
                catch (IOException e) {
                    log.warning(Messages.FileLog_Error_Reading, indexFile, e.getMessage());
                    FileUtil.close(in);
                    return null;
                }
            }
            catch (Throwable throwable) {
                FileUtil.close(in);
                throw throwable;
            }
            FileUtil.close(in);
        } else {
            contents = String.valueOf(XMLFormatter.getXMLHeader(INDEX_XSL_FILE, this.getEncoding())) + INDEX_START_ELEMENT + INDEX_END_ELEMENT;
            createdFile = true;
        }
        int i = contents.lastIndexOf(INDEX_END_ELEMENT);
        if (i < 0) {
            log.warning(Messages.FileLog_Did_Not_Find_Element, INDEX_END_ELEMENT, indexFile);
            return null;
        }
        StringBuffer sb = new StringBuffer(contents.length() + 70);
        sb.append(contents.substring(0, i));
        sb.append(" <log date='");
        LogUtil.appendDate(sb, this.startTime);
        sb.append("' time='");
        LogUtil.appendTime(sb, this.startTime);
        sb.append("'>").append(this.file.getName());
        sb.append("</log>").append(LogUtil.NEWLINE);
        sb.append(contents.substring(i));
        try {
            FileUtil.writeFile(indexFile, sb.toString());
        }
        catch (IOException e) {
            log.warning(Messages.FileLog_Error_Writing, indexFile, e.getMessage());
            return null;
        }
        return createdFile ? indexFile : null;
    }

    protected void updateIndex() {
        String contents;
        File indexFile = new File(this.file.getParentFile(), INDEX_FILE);
        FileInputStream fin = null;
        try {
            try {
                fin = new FileInputStream(indexFile);
                contents = FileUtil.readStream(fin);
            }
            catch (IOException e) {
                FileUtil.close(fin);
                return;
            }
        }
        catch (Throwable throwable) {
            FileUtil.close(fin);
            throw throwable;
        }
        FileUtil.close(fin);
        int i = contents.lastIndexOf(">" + this.file.getName() + '<');
        StringBuffer sb = new StringBuffer(contents.length() + 32);
        sb.append(contents.substring(0, i));
        sb.append(" entries='").append(this.entries).append('\'');
        sb.append(" errors='").append(this.errors).append('\'');
        sb.append(" warnings='").append(this.warnings).append('\'');
        sb.append(contents.substring(i));
        try {
            FileUtil.writeFile(indexFile, sb.toString());
        }
        catch (IOException e) {
            ExceptionUtil.debugLogIOException(e);
        }
    }

    private File getLogFile(File dir) {
        return LogUtil.createLogFile(dir, this.startTime, LOG_EXTENSION);
    }

    private File createXSL(String name) {
        InputStream input;
        File dstFile = new File(this.file.getParentFile(), name);
        dstFile.exists();
        ClassLoader loader = FileLog.class.getClassLoader();
        String resource = String.valueOf(FileLog.class.getPackage().getName().replace('.', '/')) + '/' + name;
        InputStream inputStream = input = loader == null ? ClassLoader.getSystemResourceAsStream(resource) : loader.getResourceAsStream(resource);
        if (input == null) {
            log.warning(Messages.FileLog_Failed_To_Find_Resource, resource);
            return null;
        }
        String contents = null;
        try {
            try {
                contents = FileUtil.readStream(input);
            }
            catch (IOException e) {
                log.warning(Messages.FileLog_Error_Reading_Resource, resource, e.getMessage());
                try {
                    input.close();
                }
                catch (IOException e2) {
                    ExceptionUtil.debugLogIOException(e2);
                }
                return null;
            }
        }
        finally {
            try {
                input.close();
            }
            catch (IOException e) {
                ExceptionUtil.debugLogIOException(e);
            }
        }
        contents = contents.replaceAll("%Index_Title", Messages.FileLog_All_Log_Files);
        contents = contents.replaceAll("%Date", Messages.FileLog_Date);
        contents = contents.replaceAll("%Entries", Messages.FileLog_Entries);
        contents = contents.replaceAll("%Errors", Messages.FileLog_Errors);
        contents = contents.replaceAll("%Warnings", Messages.FileLog_Warnings);
        contents = contents.replaceAll("%Log_File", Messages.FileLog_Log_File_Heading);
        contents = contents.replaceAll("%Log_Title", Messages.FileLog_Install_Log);
        contents = contents.replaceAll("%Level", Messages.FileLog_Level);
        contents = contents.replaceAll("%Message_Id", Messages.FileLog_Message_Id);
        contents = contents.replaceAll("%Time", Messages.FileLog_Time);
        contents = contents.replaceAll("%Message", Messages.FileLog_Message);
        contents = contents.replaceAll("%Started_At", Messages.FileLog_Started_At);
        log.debug(Messages.FileLog_Creating, dstFile);
        try {
            FileUtil.writeFile(dstFile, contents);
        }
        catch (IOException e) {
            log.warning(Messages.FileLog_Error_Writing, dstFile, e.getMessage());
            return null;
        }
        return dstFile;
    }
}

