/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.logging;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.ILogListener;
import com.ibm.cic.common.logging.Level;
import com.ibm.cic.common.logging.LogEntry;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.StreamLog;
import java.io.OutputStream;
import org.eclipse.osgi.util.NLS;

public class ConsoleLog
implements ILogListener {
    private final long startTime = System.currentTimeMillis();
    private SysLog syserr = new SysLog(System.err);
    private SysLog sysout = new SysLog(System.out);
    private IFormatter formatter = new Formatter();

    public synchronized String format(LogEntry entry) {
        try {
            StringBuffer sb = new StringBuffer(128);
            this.formatter.format(sb, this.startTime, entry);
            return sb.toString();
        }
        catch (Throwable e) {
            return NLS.bind((String)Messages.ConsoleLog_Error_Formatting_Record, (Object)e);
        }
    }

    public static void formatFullHeading(int stackTraceLimit, StringBuffer sb, LogEntry entry, long startTime) {
        ConsoleLog.formatHeading(sb, entry, startTime);
        sb.append(LogUtil.NEWLINE).append("  ");
        ConsoleLog.formatNoHeading(stackTraceLimit, sb, entry);
    }

    public static void formatHeading(StringBuffer sb, LogEntry entry, long startTime) {
        LogUtil.appendElapsed(sb, entry.getTime() - startTime);
        sb.append(' ').append(Level.getName(entry.getLevel()));
        sb.append(" [").append(entry.getThreadName()).append(']');
        String className = entry.getCallingClass();
        sb.append(' ');
        sb.append(className != null ? className : entry.getLoggerName());
        String sourceMethod = entry.getCallingMethod();
        if (sourceMethod != null) {
            sb.append(' ').append(sourceMethod);
        }
    }

    public static void formatLevelHeading(int stackTraceLimit, StringBuffer sb, LogEntry entry) {
        sb.append(Level.getName(entry.getLevel()));
        sb.append(": ");
        ConsoleLog.formatNoHeading(stackTraceLimit, sb, entry);
    }

    public static void formatNoHeading(int stackTraceLimit, StringBuffer sb, LogEntry entry) {
        String msg = entry.getFormattedMessage();
        String uid = entry.getUid();
        if (!uid.isEmpty()) {
            msg = String.valueOf(uid) + ' ' + msg;
        }
        sb.append(LogUtil.indent(msg));
        Throwable e = entry.getException();
        if (e != null) {
            sb.append(LogUtil.NEWLINE);
            LogUtil.appendStackTrace(stackTraceLimit, sb, 1, e);
        }
        sb.append(LogUtil.NEWLINE);
    }

    @Override
    public void close() {
        this.syserr.close();
        this.sysout.close();
    }

    private SysLog checkLog(SysLog log, OutputStream os) {
        if (os == log.getOutputStream()) {
            return log;
        }
        log.close();
        return new SysLog(os);
    }

    @Override
    public synchronized void logEntry(LogEntry entry) {
        if (entry.getLevel() == Level.ERROR) {
            this.syserr = this.checkLog(this.syserr, System.err);
            this.syserr.logEntry(entry);
        } else {
            this.sysout = this.checkLog(this.sysout, System.out);
            this.sysout.logEntry(entry);
        }
    }

    public IFormatter getFormatter() {
        return this.formatter;
    }

    public void setFormatter(IFormatter formatter) {
        this.formatter = formatter;
    }

    private static class Formatter
    implements IFormatter {
        private LogEntry prevEntry = null;

        private Formatter() {
        }

        @Override
        public void format(StringBuffer sb, long startTime, LogEntry entry) {
            if (!this.omitHeading(entry)) {
                ConsoleLog.formatHeading(sb, entry, startTime);
                sb.append(LogUtil.NEWLINE);
            }
            ConsoleLog.formatNoHeading(4, sb, entry);
        }

        private boolean omitHeading(LogEntry entry) {
            boolean result = this.prevEntry != null && entry.getLevel() == Level.DEBUG && this.prevEntry.getLevel() == Level.DEBUG && entry.getLoggerName().equals(this.prevEntry.getLoggerName()) && Util.equals(entry.getCallingClass(), this.prevEntry.getCallingClass()) && Util.equals(entry.getCallingMethod(), this.prevEntry.getCallingMethod());
            this.prevEntry = entry;
            return result;
        }
    }

    public static interface IFormatter {
        public void format(StringBuffer var1, long var2, LogEntry var4);
    }

    private class SysLog
    extends StreamLog {
        private OutputStream os;

        public SysLog(OutputStream os) {
            this.setOutputStream(os);
            this.os = os;
        }

        public OutputStream getOutputStream() {
            return this.os;
        }

        @Override
        public String format(LogEntry entry) {
            return ConsoleLog.this.format(entry);
        }

        @Override
        public synchronized void close() {
            this.os = null;
        }

        @Override
        protected Encodings getEncoding() {
            return Encodings.DEFAULT;
        }
    }
}

