/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads.handlerImpl;

import com.ibm.cic.common.downloads.JavaProxyAuthenticator;
import com.ibm.cic.common.downloads.JavaProxyUtilities;
import com.ibm.cic.common.downloads.ProxyInfo;
import com.ibm.cic.common.downloads.RequestStatus;
import java.net.Authenticator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedList;

public abstract class AuthenticationContext {
    private static ArrayList listeners = new ArrayList();

    public static void addTestListener(AuthenticationContext ac) {
        listeners.add(ac);
    }

    public static void removeTestListener(AuthenticationContext ac) {
        listeners.remove(ac);
    }

    public void release() {
        for (AuthenticationContext ac : listeners) {
            if (ac == this) continue;
            ac.release();
        }
    }

    public synchronized void onState(RequestStatus state, Throwable exception) {
        for (AuthenticationContext ac : listeners) {
            if (ac == this) continue;
            ac.onState(state, exception);
        }
    }

    public abstract int getAskedCount();

    public abstract boolean checkThreadCanceled(boolean var1);

    public static class CompositeAuthContext
    extends AuthenticationContext {
        private final Collection contexts = new LinkedList();

        public void add(AuthenticationContext ac) {
            this.contexts.add(ac);
        }

        @Override
        public void release() {
            for (AuthenticationContext ac : this.contexts) {
                ac.release();
            }
        }

        @Override
        public void onState(RequestStatus state, Throwable exception) {
            for (AuthenticationContext ac : this.contexts) {
                ac.onState(state, exception);
            }
        }

        @Override
        public boolean checkThreadCanceled(boolean reset) {
            boolean status = false;
            for (AuthenticationContext ac : this.contexts) {
                status |= ac.checkThreadCanceled(reset);
            }
            return status;
        }

        @Override
        public int getAskedCount() {
            int n = 0;
            for (AuthenticationContext ac : this.contexts) {
                n += ac.getAskedCount();
            }
            return n;
        }

        public AuthenticationContext getAuthenticationContext(Class clazz) {
            for (AuthenticationContext ac : this.contexts) {
                if (!ac.getClass().equals(clazz)) continue;
                return ac;
            }
            return null;
        }
    }

    public static class NoSocksProxy
    extends AuthenticationContext {
        public static final NoSocksProxy INSTANCE = new NoSocksProxy();

        private NoSocksProxy() {
        }

        public NoSocksProxy init() {
            NoSocksProxy.clearSocksProxyInfo();
            return this;
        }

        public static void clearSocksProxyInfo() {
            JavaProxyUtilities.clearSocksProxySystemProperties();
        }

        @Override
        public int getAskedCount() {
            return 0;
        }

        @Override
        public boolean checkThreadCanceled(boolean reset) {
            return false;
        }
    }

    public static class SocksAuthenticationContext
    extends AuthenticationContext {
        private ProxyInfo proxyInfo;

        public SocksAuthenticationContext init(ProxyInfo curProxyInfo) {
            this.proxyInfo = curProxyInfo;
            JavaProxyUtilities.setSocksProxySystemProperties(true, curProxyInfo.getHost(), Integer.toString(curProxyInfo.getPort()));
            Authenticator.setDefault(JavaProxyAuthenticator.INSTANCE);
            JavaProxyAuthenticator.INSTANCE.getAuthenticator().addHostInfo(curProxyInfo);
            return this;
        }

        @Override
        public void release() {
            super.release();
            JavaProxyAuthenticator.INSTANCE.getAuthenticator().removeHostInfo(this.proxyInfo);
        }

        @Override
        public void onState(RequestStatus state, Throwable exception) {
            super.onState(state, exception);
            JavaProxyAuthenticator.INSTANCE.getAuthenticator().setResult(this.proxyInfo, state);
        }

        @Override
        public boolean checkThreadCanceled(boolean reset) {
            return JavaProxyAuthenticator.INSTANCE.getAuthenticator().checkThreadCanceled(this.proxyInfo, reset);
        }

        @Override
        public int getAskedCount() {
            return JavaProxyAuthenticator.INSTANCE.getAuthenticator().getAskedCount();
        }
    }
}

