/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.downloads.CicX509TrustManager;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.downloads.INonsecureConnectionPrompter;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.downloads.NonsecureConnectionPrompter;
import com.ibm.cic.common.downloads.NonsecureConnectionSessionState;
import com.ibm.cic.common.downloads.PreferencesHolder;
import com.ibm.cic.common.logging.Logger;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Enumeration;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.TrustManager;
import javax.security.auth.x500.X500Principal;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Plugin;

public class NonsecureConnectionManager {
    static final Logger log = Logger.getLogger(NonsecureConnectionManager.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    public static final NonsecureConnectionManager INSTANCE = new NonsecureConnectionManager();
    private static ThreadLocal perThreadHost = new ThreadLocal();
    private SSLContext sslContext;
    private final ArrayList listeners = new ArrayList();
    private static final String LITERAL_DNEQ = "CN=";

    private NonsecureConnectionManager() {
    }

    private static SSLContext createSSLContext() throws NoSuchAlgorithmException, KeyManagementException, KeyStoreException {
        SSLContext context = null;
        context = "macosx".equals(Platform.getOS()) ? SSLContext.getInstance("TLSv1.2") : SSLContext.getInstance("SSL_TLSv2");
        context.init(null, new TrustManager[]{new CicX509TrustManager()}, null);
        return context;
    }

    public synchronized SSLContext getSSLContext() throws KeyManagementException, NoSuchAlgorithmException, KeyStoreException {
        if (this.sslContext == null) {
            this.sslContext = NonsecureConnectionManager.createSSLContext();
        }
        return this.sslContext;
    }

    public static void onBeforeSSLConnect(String host) {
        String lcHost = host.toLowerCase();
        perThreadHost.set(lcHost);
    }

    public static void onPostSSLConnect() {
        perThreadHost.set(null);
    }

    public static String getSSLConnectingHost() {
        return (String)perThreadHost.get();
    }

    public synchronized void addListener(IDropConnectionsListener listener) {
        this.listeners.add(listener);
    }

    public synchronized void removeListener(IDropConnectionsListener listener) {
        this.listeners.remove(listener);
    }

    public synchronized void dropConnections() {
        log.debug("dropping connections");
        for (IDropConnectionsListener dropListener : this.listeners) {
            dropListener.dropConnections();
        }
        if (this.sslContext != null) {
            SSLSessionContext sessionContext = this.sslContext.getClientSessionContext();
            if (sessionContext != null) {
                Enumeration<byte[]> ids = sessionContext.getIds();
                while (ids.hasMoreElements()) {
                    byte[] id = ids.nextElement();
                    SSLSession session = sessionContext.getSession(id);
                    session.invalidate();
                }
            }
            this.sslContext = null;
        }
    }

    public synchronized boolean continueConnectionWithInvalidCertificates(String host, X509Certificate[] certificates, String authType, CertificateException ce) {
        NonsecureConnectionSessionState sessionState = NonsecureConnectionSessionState.INSTANCE;
        if (sessionState.isNonsecureMode()) {
            this.warnNonsecureConnection(host, certificates, authType, ce);
            return true;
        }
        if (PreferencesHolder.INSTANCE.isSSLNonsecureMode()) {
            this.warnNonsecureConnection(host, certificates, authType, ce);
            return true;
        }
        NonsecureConnectionPrompter prompterHolder = NonsecureConnectionPrompter.INSTANCE;
        INonsecureConnectionPrompter prompter = prompterHolder.getPrompter();
        if (prompter == null) {
            log.debug("No nonsecure connection prompter registered");
            return false;
        }
        int response = prompter.promptEnterNonsecureSSLMode(host, certificates, authType, ce);
        if (response == 2) {
            this.warnNonsecureConnection(host, certificates, authType, ce);
            sessionState.setNonsecureMode(true);
            return true;
        }
        if (response == 4) {
            this.warnNonsecureConnection(host, certificates, authType, ce);
            return true;
        }
        if (response == 1) {
            CicPreferenceManager prefMan = CicPreferenceManager.getInstance();
            if (prefMan != null) {
                prefMan.setBoolean(ICicPreferenceConstants.SSL_NONSECURE_MODE, true);
            }
            this.warnNonsecureConnection(host, certificates, authType, ce);
            return true;
        }
        assert (response == 3);
        return false;
    }

    private void warnNonsecureConnection(String host, X509Certificate[] certificates, String authType, CertificateException ce) {
        X509Certificate certificate = certificates[0];
        X500Principal subjectDNP = certificate.getSubjectX500Principal();
        String subjectCN = this.getSubjectCN(subjectDNP);
        if (subjectCN == null) {
            log.warning(Messages.NonsecureConnectionManager_FailedToParseCertificateSubject, subjectDNP.getName());
            log.warning(Messages.NonsecureConnectionManager_WarningNonsecureConnectionNoSubjectCommonName, host, ce);
        } else {
            log.warning(Messages.NonsecureConnectionManager_WarningNonsecureConnectionWithSubjectCommonName, host, subjectCN, ce);
        }
    }

    private String getSubjectCN(X500Principal subjectDNP) {
        if (subjectDNP == null) {
            return null;
        }
        String subjectCN = NonsecureConnectionManager.getCN(subjectDNP.getName());
        return subjectCN;
    }

    public static String getCN(String principalName) {
        if (principalName == null) {
            return null;
        }
        String str = principalName;
        int i = str.indexOf(LITERAL_DNEQ);
        if (i == -1) {
            return null;
        }
        CharSequence rest = str.subSequence(i + LITERAL_DNEQ.length(), str.length());
        i = NonsecureConnectionManager.eatWS(rest, 0);
        while (i < rest.length()) {
            char c = rest.charAt(i);
            if (c == '\\') {
                ++i;
            } else if (c == ',') break;
            ++i;
        }
        return rest.subSequence(0, i).toString().trim();
    }

    private static int eatWS(CharSequence chars, int i) {
        int len = chars.length();
        while (i < len && NonsecureConnectionManager.isWS(chars.charAt(i))) {
            ++i;
        }
        return i;
    }

    private static boolean isWS(char c) {
        return c == ' ';
    }

    public static interface IDropConnectionsListener {
        public void dropConnections();
    }
}

