/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.downloads;

import com.ibm.cic.common.core.internal.downloads.NullHasIsCanceledMonitor;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreDateTrace;
import com.ibm.cic.common.core.internal.utils.CicCommonCorePluginTrace;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import com.ibm.cic.common.core.utils.JettyDataKeeper;
import com.ibm.cic.common.downloads.DownloadEvents;
import com.ibm.cic.common.downloads.DownloadHandlerDefaultRetryLevel;
import com.ibm.cic.common.downloads.DownloadHandlerRequest;
import com.ibm.cic.common.downloads.DownloadProperties;
import com.ibm.cic.common.downloads.DownloadRetryLevel;
import com.ibm.cic.common.downloads.DownloadTrace;
import com.ibm.cic.common.downloads.DownloadUI;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadContext;
import com.ibm.cic.common.downloads.IDownloadListener;
import com.ibm.cic.common.downloads.IDownloadUI;
import com.ibm.cic.common.downloads.IHasIsCanceled;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.ProxySupport;
import com.ibm.cic.common.downloads.handlerImpl.DownloadCancelMonitorPerThread;
import com.ibm.cic.common.downloads.handlerImpl.DownloadCancelMonitorUtil;
import com.ibm.cic.common.downloads.handlerImpl.DownloadHandlerUtil;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;

public abstract class DownloadHandler {
    protected static final CicCommonCoreTrace dlTrace = DownloadTrace.traceIssues;
    protected static final CicCommonCoreDateTrace dlTraceHappy = DownloadTrace.traceHappy;
    protected static final CicCommonCoreDateTrace traceHeartBeat = DownloadTrace.traceHeartBeat;
    protected static final CicCommonCorePluginTrace pluginTrace = DownloadHandlerUtil.pluginTrace;
    protected static final CicCommonCoreTrace traceProxySettings = DownloadHandlerUtil.traceProxySettings;
    protected static final CicCommonCoreTrace debugProgress = DownloadHandlerUtil.debugProgress;
    public static final long UNKNOWN_SIZE = -1L;

    public final IContentInfo download(IDownloadContext ctxt, String urlString, String destination, ITransferMonitor transferPerformance, long[] outBytesRead) throws IOException {
        DownloadHandlerRequest.DownloadRequest dlr = DownloadHandlerRequest.FACTORY.createDownloadRequest(ctxt, urlString, destination, -1L);
        return this.download(dlr, transferPerformance, outBytesRead);
    }

    public static boolean isCanceled(DownloadHandlerRequest request) {
        IHasIsCanceled cancelMonitor = DownloadCancelMonitorUtil.getDownloadCancelMonitor(request.getDownloadContext());
        if (cancelMonitor != null) {
            return cancelMonitor.isCanceled() && !JettyDataKeeper.INSTANCE.isUISessionDestroyed();
        }
        return false;
    }

    public static boolean isCanceledWithCheckWait(DownloadHandlerRequest r) {
        if (DownloadHandler.isCanceled(r)) {
            return true;
        }
        return DownloadHandler.waitUntilResumeOrRetry(r) && DownloadHandler.isCanceled(r);
    }

    public static IDownloadListener fireDownloadEvents(DownloadHandlerRequest request) {
        IDownloadListener fire = DownloadEvents.getFire(request.getDownloadContext());
        return fire;
    }

    public static IHasIsCanceled getCancelMonitor(DownloadHandlerRequest request) {
        IDownloadContext ctxt = request.getDownloadContext();
        IHasIsCanceled cancelMonitor = DownloadCancelMonitorUtil.getDownloadCancelMonitor(ctxt);
        if (cancelMonitor == null) {
            return NullHasIsCanceledMonitor.INSTANCE;
        }
        return cancelMonitor;
    }

    public static boolean waitUntilResumeOrRetry(DownloadHandlerRequest request) {
        IDownloadContext ctxt = request.getDownloadContext();
        IDownloadUI ui = DownloadUI.getDownloadUI(ctxt);
        return DownloadUI.waitUntilResumeOrRetry(ui);
    }

    public final IContentInfo download(IDownloadContext ctxt, String urlString, String destination, long expectedSize, ITransferMonitor transferPerformance, long[] outBytesRead) throws IOException {
        DownloadHandlerRequest.DownloadRequest dlr = DownloadHandlerRequest.FACTORY.createDownloadRequest(ctxt, urlString, destination, expectedSize);
        return this.download(dlr, transferPerformance, outBytesRead);
    }

    public DownloadRetryLevel retryLevel(Exception exception) {
        return DownloadHandlerDefaultRetryLevel.retryLevel(exception);
    }

    public static boolean shouldRetry(IDownloadUI downloadUI, DownloadRetryLevel retryLevel) {
        boolean failFast = downloadUI.autoRetryOnTimeoutOnly();
        if (failFast) {
            int retryCode = retryLevel.getValue();
            switch (retryCode) {
                case 80: 
                case 90: {
                    return true;
                }
            }
            return false;
        }
        return DownloadHandler.shouldRetryIfCanSucceed(retryLevel);
    }

    private static boolean shouldRetryIfCanSucceed(DownloadRetryLevel retryLevel) {
        int retryCode = retryLevel.getValue();
        switch (retryCode) {
            case 50: 
            case 60: 
            case 70: 
            case 80: 
            case 90: {
                return true;
            }
        }
        return false;
    }

    private final IContentInfo download(DownloadHandlerRequest.DownloadRequest request, ITransferMonitor transferPerformance, final long[] outBytesRead) throws IOException {
        IDownloadListener fire = DownloadHandler.fireDownloadEvents(request);
        fire.enter(request);
        IHasIsCanceled cancelMonitor = DownloadHandler.getCancelMonitor(request);
        DownloadCancelMonitorPerThread.DownloadCancelMonitorPerThreadSetRestoreHelper perThreadCancelMonitorHelper = new DownloadCancelMonitorPerThread.DownloadCancelMonitorPerThreadSetRestoreHelper(cancelMonitor);
        try {
            final IContentInfo ci = this.implementDownload(request, transferPerformance, outBytesRead);
            fire.exit(request, new Object(){

                public String toString() {
                    StringBuffer sb = new StringBuffer();
                    sb.append(ci);
                    if (outBytesRead != null) {
                        sb.append(" outBytesRead=");
                        sb.append(outBytesRead[0]);
                    }
                    return sb.toString();
                }
            });
            IContentInfo iContentInfo = ci;
            return iContentInfo;
        }
        catch (IOException e) {
            fire.exit(request, e);
            throw e;
        }
        catch (Error | RuntimeException e) {
            fire.exit(request, e);
            dlTrace.getLog().error(e);
            throw e;
        }
        finally {
            perThreadCancelMonitorHelper.restore();
        }
    }

    protected abstract IContentInfo implementDownload(DownloadHandlerRequest.DownloadSinkRequest var1, ITransferMonitor var2, long[] var3) throws IOException;

    protected abstract IContentInfo implementDownload(DownloadHandlerRequest.DownloadRequest var1, ITransferMonitor var2, long[] var3) throws IOException;

    protected abstract boolean implementExists(DownloadHandlerRequest.ExistsRequest var1) throws IOException;

    public final boolean exists(IDownloadContext ctxt, String urlString) throws IOException {
        DownloadHandlerRequest.ExistsRequest er = DownloadHandlerRequest.FACTORY.createExistsRequest(ctxt, urlString);
        return this.exists(er);
    }

    private final boolean exists(DownloadHandlerRequest.ExistsRequest request) throws IOException {
        IDownloadListener fire = DownloadHandler.fireDownloadEvents(request);
        fire.enter(request);
        IHasIsCanceled cancelMonitor = DownloadHandler.getCancelMonitor(request);
        DownloadCancelMonitorPerThread.DownloadCancelMonitorPerThreadSetRestoreHelper perThreadCancelMonitorHelper = new DownloadCancelMonitorPerThread.DownloadCancelMonitorPerThreadSetRestoreHelper(cancelMonitor);
        try {
            boolean retVal = this.implementExists(request);
            fire.exit(request, retVal);
            boolean bl = retVal;
            return bl;
        }
        catch (IOException e) {
            fire.exit(request, e);
            throw e;
        }
        catch (Error | RuntimeException e) {
            fire.exit(request, e);
            dlTrace.getLog().error(e);
            throw e;
        }
        finally {
            perThreadCancelMonitorHelper.restore();
        }
    }

    protected final InputStream privateOpenStream(DownloadHandlerRequest.OpenStreamRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws IOException {
        IDownloadListener fire = DownloadHandler.fireDownloadEvents(request);
        fire.enter(request);
        IHasIsCanceled cancelMonitor = DownloadHandler.getCancelMonitor(request);
        DownloadCancelMonitorPerThread.DownloadCancelMonitorPerThreadSetRestoreHelper perThreadCancelMonitorHelper = new DownloadCancelMonitorPerThread.DownloadCancelMonitorPerThreadSetRestoreHelper(cancelMonitor);
        try {
            InputStream is = this.implementOpenStream(request, transferPerformance, outContentInfo);
            fire.exit(request, outContentInfo != null ? outContentInfo[0] : null);
            InputStream inputStream = is;
            return inputStream;
        }
        catch (IOException e) {
            fire.exit(request, e);
            throw e;
        }
        catch (Error | RuntimeException e) {
            fire.exit(request, e);
            dlTrace.getLog().error(e);
            throw e;
        }
        finally {
            perThreadCancelMonitorHelper.restore();
        }
    }

    protected InputStream implementOpenStream(DownloadHandlerRequest.OpenStreamRequest request, ITransferMonitor transferPerformance, IContentInfo[] outContentInfo) throws IOException {
        throw new UnsupportedOperationException();
    }

    public abstract ProxySupport getProxySupport();

    public boolean shouldUseMultipleThreads(URL url) {
        return true;
    }

    public final DownloadProperties queryProperties(IDownloadContext ctxt, String urlString) throws IOException {
        DownloadHandlerRequest.QueryContentInfoRequest request = DownloadHandlerRequest.FACTORY.createQueryContentInfoRequest(ctxt, urlString);
        return this.queryProperties(request);
    }

    protected DownloadProperties queryProperties(DownloadHandlerRequest.QueryContentInfoRequest request) throws IOException {
        IDownloadListener fire = DownloadHandler.fireDownloadEvents(request);
        fire.enter(request);
        IHasIsCanceled cancelMonitor = DownloadHandler.getCancelMonitor(request);
        DownloadCancelMonitorPerThread.DownloadCancelMonitorPerThreadSetRestoreHelper perThreadCancelMonitorHelper = new DownloadCancelMonitorPerThread.DownloadCancelMonitorPerThreadSetRestoreHelper(cancelMonitor);
        DownloadProperties dp = null;
        try {
            try {
                dp = this.implementQueryProperties(request);
                fire.exit(request, dp);
            }
            catch (IOException e) {
                fire.exit(request, e);
                throw e;
            }
            catch (Error | RuntimeException e) {
                fire.exit(request, e);
                dlTrace.getLog().error(e);
                throw e;
            }
        }
        finally {
            perThreadCancelMonitorHelper.restore();
        }
        return dp;
    }

    public boolean canQueryProperties() {
        return false;
    }

    protected DownloadProperties implementQueryProperties(DownloadHandlerRequest.QueryContentInfoRequest request) throws IOException {
        return DownloadProperties.EMPTY_DOWNLOAD_PROPERTIES;
    }
}

