/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.volrepo;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IArtifactSessionFactory;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.repository.RepositoryInfo;
import com.ibm.cic.common.core.internal.volrepo.DiskMounter;
import com.ibm.cic.common.core.internal.volrepo.IDiskMounterFactory;
import com.ibm.cic.common.core.internal.volrepo.VolumeArtifactRepository;
import com.ibm.cic.common.core.internal.volrepo.VolumeAtocUtil;
import com.ibm.cic.common.core.internal.volrepo.VolumeSetReader;
import com.ibm.cic.common.core.internal.volrepo.VolumeSetReaderHelperClassic;
import com.ibm.cic.common.core.internal.volrepo.VolumeSetReaderHelperViaMasterDisk;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.utils.OfferingUtil;
import com.ibm.cic.common.core.repository.AbstractBaseRepository;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryContext;
import com.ibm.cic.common.core.repository.RepositorySiteProperties;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.utils.SplitIdVersionUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.core.volrepo.DiskTagFile;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class VolumeRepository
extends AbstractBaseRepository {
    public static final String REPOSITORY_TYPE = "Volume";
    public static final String REPOSITORY_VERSION = "0.0.0.1";
    public static final String PROP_ASKFOR_DISK1 = "AskForDisk1";
    public static final String PROP_DISK_SET_ID = "diskSetId";
    public static final String PROP_DISK1_LOCATION = "disk1Location";
    public static final String PROP_OPEN_FROM_ANY_ESD_DISK_LOCATION = "AllowOpenFromAnyESDDisk";
    public static final String PROP_DISK_SET_LABEL = "diskSetLabel";
    public static final String PROP_EXTERNAL_DISK1_INFO = "extDisk1Info";
    public static final Logger log = Logger.getLogger(VolumeRepository.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private VolumeSetReader vsr;
    private IRepository metaDataRepoForDisposeOnly;
    private IRepository previousMetaDataReference;
    private IReadArtifactRepo artifactRepo;

    public VolumeRepository() {
        super(REPOSITORY_TYPE, REPOSITORY_VERSION);
    }

    private static void log(IStatus status) {
        log.status(status);
    }

    private static void log(Exception e) {
        Status status = new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
        VolumeRepository.log((IStatus)status);
    }

    private IRepository getMetaRepo(IProgressMonitor monitor) throws IOException, CoreException {
        return this.vsr.getMetaRepo(monitor);
    }

    @Override
    protected void setSerializeRepositoryInfoCustomMap(Map customMap) {
        super.setSerializeRepositoryInfoCustomMap(customMap);
        customMap.put(PROP_EXTERNAL_DISK1_INFO, null);
        customMap.put(PROP_ASKFOR_DISK1, null);
    }

    @Override
    public String serializeRepositoryInfo() {
        String s = super.serializeRepositoryInfo();
        RepositoryInfo repoInfo = (RepositoryInfo)this.getRepositoryInfo();
        IExtDisk1Info extMasterDisk = (IExtDisk1Info)repoInfo.getProperty(PROP_EXTERNAL_DISK1_INFO);
        if (extMasterDisk != null) {
            try {
                StringBuffer sb = new StringBuffer(s);
                IArtifactSession session = IArtifactSessionFactory.INSTANCE.createArtifactSession();
                VolumeAtocUtil datoc = this.vsr.getVolumeArtifactToc(session, (IProgressMonitor)new NullProgressMonitor());
                session.close();
                String diskLabel = datoc.getDiskSet().getLabel();
                if (diskLabel != null) {
                    sb.append(",");
                    RepositoryInfo.serializeCustomValue(sb, PROP_DISK_SET_LABEL, diskLabel, null);
                }
                return sb.toString();
            }
            catch (CoreException e) {
                log.status(e.getStatus());
            }
            catch (IOException e) {
                log.error(e);
            }
        }
        return s;
    }

    @Override
    public IRepository getRepositoryReference() {
        return super.getRepositoryReference();
    }

    @Override
    public List getAllFixes(boolean includeUnavailable, IProgressMonitor monitor) {
        try {
            return this.getMetaRepo(monitor).getAllFixes(includeUnavailable, monitor);
        }
        catch (IOException e) {
            VolumeRepository.log(e);
        }
        catch (CoreException e) {
            VolumeRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllAssemblies(IProgressMonitor monitor) {
        try {
            return this.getMetaRepo(monitor).getAllAssemblies(monitor);
        }
        catch (IOException e) {
            VolumeRepository.log(e);
        }
        catch (CoreException e) {
            VolumeRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllSus(IProgressMonitor monitor) {
        try {
            return this.getMetaRepo(monitor).getAllSus(monitor);
        }
        catch (IOException e) {
            VolumeRepository.log(e);
        }
        catch (CoreException e) {
            VolumeRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllSuFragments(IProgressMonitor monitor) {
        try {
            return this.getMetaRepo(monitor).getAllSuFragments(monitor);
        }
        catch (IOException e) {
            VolumeRepository.log(e);
        }
        catch (CoreException e) {
            VolumeRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllIus(IProgressMonitor monitor) {
        try {
            return this.getMetaRepo(monitor).getAllIus(monitor);
        }
        catch (IOException e) {
            VolumeRepository.log(e);
        }
        catch (CoreException e) {
            VolumeRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllOfferings(boolean includeUnavailable, IProgressMonitor monitor) {
        try {
            return this.getMetaRepo(monitor).getAllOfferings(includeUnavailable, monitor);
        }
        catch (IOException e) {
            VolumeRepository.log(e);
        }
        catch (CoreException e) {
            VolumeRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllUpdates(IIdentity offeringId, Version offeringVersion, IProgressMonitor progressMonitor) {
        return this.getAllUpdates(false, offeringId, offeringVersion, progressMonitor);
    }

    @Override
    public List getAllUpdates(boolean includeUnavailable, IIdentity offeringId, Version offeringVersion, IProgressMonitor progressMonitor) {
        try {
            return this.getMetaRepo(progressMonitor).getAllUpdates(includeUnavailable, offeringId, offeringVersion, progressMonitor);
        }
        catch (IOException e) {
            VolumeRepository.log(e);
        }
        catch (CoreException e) {
            VolumeRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public IStatus unsetUpdateOffering(IOffering updateOffering) {
        try {
            return this.getMetaRepo(null).unsetUpdateOffering(updateOffering);
        }
        catch (IOException e) {
            VolumeRepository.log(e);
        }
        catch (CoreException e) {
            VolumeRepository.log(e.getStatus());
            return e.getStatus();
        }
        throw new UnsupportedOperationException();
    }

    @Override
    public List getAllShareableEntities(IProgressMonitor monitor) {
        try {
            return this.getMetaRepo(monitor).getAllShareableEntities(monitor);
        }
        catch (IOException e) {
            VolumeRepository.log(e);
        }
        catch (CoreException e) {
            VolumeRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllContentElements(IProgressMonitor monitor) {
        try {
            return this.getMetaRepo(monitor).getAllContentElements(monitor);
        }
        catch (IOException e) {
            VolumeRepository.log(e);
        }
        catch (CoreException e) {
            VolumeRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public IContentRepository getContentRepository(IContent element) {
        try {
            return this.getMetaRepo((IProgressMonitor)new NullProgressMonitor()).getContentRepository(element);
        }
        catch (IOException e) {
            VolumeRepository.log(e);
        }
        catch (CoreException e) {
            VolumeRepository.log(e.getStatus());
        }
        return null;
    }

    @Override
    public boolean containsMetadata() {
        return true;
    }

    @Override
    public boolean containsArtifacts() {
        return true;
    }

    @Override
    public boolean canStoreMetadata() {
        return false;
    }

    @Override
    public boolean canStoreArtifacts() {
        return false;
    }

    public static boolean getAskForDisk1(IRepositoryInfo repInfo) {
        Boolean askForDiskProp = (Boolean)repInfo.getProperty(PROP_ASKFOR_DISK1);
        boolean askForDisk1 = askForDiskProp != null ? askForDiskProp : false;
        return askForDisk1;
    }

    @Override
    public IStatus canAddExistingRepository(IProgressMonitor progressMonitor) {
        IStatus return_value = super.canAddExistingRepository(progressMonitor);
        if (return_value.isOK()) {
            IRepositoryInfo repoInfo = this.getRepositoryInfo();
            IExtDisk1Info extMasterDisk = (IExtDisk1Info)repoInfo.getProperty(PROP_EXTERNAL_DISK1_INFO);
            if (extMasterDisk == null) {
                ICicLocation location = this.getLocation();
                try {
                    VolumeSetReaderHelperClassic helper;
                    String requireContext;
                    TempUtil.UniqueTempDir cdsetCacheFolder = TempUtil.getUniqueTempDir(null, "cicvolcache");
                    String requestedDiskSetId = repoInfo.getStringProperty(PROP_DISK_SET_ID);
                    Boolean b = (Boolean)repoInfo.getProperty(PROP_OPEN_FROM_ANY_ESD_DISK_LOCATION);
                    boolean allowOpenFromAnyESDDiskLocation = b != null ? b : false;
                    boolean askForDisk1 = false;
                    if (!allowOpenFromAnyESDDiskLocation) {
                        askForDisk1 = VolumeRepository.getAskForDisk1(this.getRepositoryInfo());
                    }
                    if ((requireContext = (helper = VolumeSetReaderHelperClassic.open(askForDisk1, location, requestedDiskSetId, allowOpenFromAnyESDDiskLocation, cdsetCacheFolder, progressMonitor)).getDiskTagProperties().getProperty("RequireContext")) != null) {
                        HashMap<String, String> map = new HashMap<String, String>();
                        map.put("RequireContext", requireContext);
                        IStatus statusCheckContext = RepositoryContext.getInstance().checkRequiredContext(this.getRepositoryInfo(), map);
                        if (statusCheckContext.matches(4)) {
                            throw new CoreException(statusCheckContext);
                        }
                        if (statusCheckContext.matches(2)) {
                            log.status(statusCheckContext);
                        }
                    }
                    String diskSetId = helper.getDiskTagProperties().getProperty(PROP_DISK_SET_ID);
                    this.getRepositoryInfo().setProperty(PROP_DISK_SET_ID, diskSetId);
                    this.getRepositoryInfo().setProperty(PROP_DISK1_LOCATION, helper.getDisk1Location());
                    helper.dispose();
                    return_value = Status.OK_STATUS;
                }
                catch (CoreException e) {
                    return e.getStatus();
                }
            } else {
                String diskSetId = extMasterDisk.getDiskSetId();
                this.getRepositoryInfo().setProperty(PROP_DISK_SET_ID, diskSetId);
                return_value = Status.OK_STATUS;
            }
        }
        return return_value;
    }

    @Override
    public IStatus getStatus(boolean reEvaluate, IProgressMonitor monitor) {
        if (this.vsr == null) {
            return Status.OK_STATUS;
        }
        return this.vsr.getStatus(reEvaluate, monitor);
    }

    @Override
    public IStatus isRepInfoMatchingRepositoryObject(IRepositoryInfo repInfo) {
        IStatus status = super.isRepInfoMatchingRepositoryObject(repInfo);
        if (!status.isOK()) {
            return status;
        }
        if (repInfo.getProperty(PROP_DISK_SET_ID) != null && !repInfo.getProperty(PROP_DISK_SET_ID).equals(this.getRepositoryInfo().getProperty(PROP_DISK_SET_ID))) {
            return Statuses.ERROR.get(6001, Messages.Repo_CantAddExistingRepository, new Object[0]);
        }
        return Status.OK_STATUS;
    }

    @Override
    protected void updateRepositoryInfo(IRepositoryInfo repInfo) throws CoreException, IOException {
        super.updateRepositoryInfo(repInfo);
        this.setWritable(false);
        IExtDisk1Info extMasterDisk = (IExtDisk1Info)repInfo.getProperty(PROP_EXTERNAL_DISK1_INFO);
        ICicLocation location = repInfo.getLocation();
        if (extMasterDisk == null) {
            TempUtil.UniqueTempDir cdsetCacheFolder = TempUtil.getUniqueTempDir(null, "cicvolcache");
            cdsetCacheFolder.create();
            String requestedDiskSetId = repInfo.getStringProperty(PROP_DISK_SET_ID);
            boolean askForDisk1 = VolumeRepository.getAskForDisk1(repInfo);
            VolumeSetReaderHelperClassic helper = VolumeSetReaderHelperClassic.open(askForDisk1, location, requestedDiskSetId, false, cdsetCacheFolder, (IProgressMonitor)new NullProgressMonitor());
            this.vsr = new VolumeSetReader(helper);
            this.vsr.setOuterRepo(this);
            IRepository metadataRepo = null;
            try {
                metadataRepo = this.vsr.getMetaRepo((IProgressMonitor)new NullProgressMonitor());
            }
            catch (CoreException e) {
                this.vsr.dispose();
                throw e;
            }
            catch (IOException e) {
                this.vsr.dispose();
                throw e;
            }
            if (metadataRepo != null) {
                this.metaDataRepoForDisposeOnly = metadataRepo;
                this.previousMetaDataReference = metadataRepo.getRepositoryReference();
                metadataRepo.setRepositoryReference(this.getRepositoryReference());
                String diskLabel = VolumeRepository.readDiskLabel(metadataRepo, repInfo, this.vsr.getDiskTagProperties(), (IProgressMonitor)new NullProgressMonitor());
                if (diskLabel != null) {
                    helper.setDiskLabel(diskLabel);
                    repInfo.setProperty(PROP_DISK_SET_LABEL, diskLabel);
                }
            }
        } else {
            VolumeSetReaderHelperViaMasterDisk helper = new VolumeSetReaderHelperViaMasterDisk(extMasterDisk);
            this.vsr = new VolumeSetReader(helper);
            this.vsr.setOuterRepo(this);
        }
        this.artifactRepo = new VolumeArtifactRepository(location.toString()){

            @Override
            public VolumeSetReader getVolumeSetReader() {
                return VolumeRepository.this.vsr;
            }

            @Override
            public IRepository getRepository() {
                return VolumeRepository.this;
            }
        };
    }

    public static String readDiskLabel(IRepository repo, IRepositoryInfo repoInfo, DiskTagFile.DiskTagProperties diskProperties, IProgressMonitor monitor) {
        Version version;
        String id;
        IOffering offering;
        String diskSetId = diskProperties.getProperty(PROP_DISK_SET_ID);
        if (repoInfo != null) {
            repoInfo.setProperty(PROP_DISK_SET_ID, diskSetId);
        }
        Object[] idAndVersion = SplitIdVersionUtil.splitIdUnderscoreVersion(diskSetId);
        String diskLabel = null;
        if (idAndVersion[1] != null && (offering = repo.findOffering(new SimpleIdentity(id = (String)idAndVersion[0]), version = (Version)idAndVersion[1], monitor)) != null) {
            boolean showInternalVersion = false;
            diskLabel = OfferingUtil.getOfferingOrFixLabel(offering, showInternalVersion);
        }
        return diskLabel;
    }

    private void disposeContained() {
        if (this.metaDataRepoForDisposeOnly != null && this.previousMetaDataReference != null) {
            this.metaDataRepoForDisposeOnly.setRepositoryReference(this.previousMetaDataReference);
        }
        if (this.vsr != null) {
            this.vsr.dispose();
        }
    }

    @Override
    public void doDelete() {
        this.disposeContained();
    }

    @Override
    public void dispose() {
        this.disposeContained();
        super.dispose();
    }

    @Override
    public void refresh() {
        this.vsr.refresh();
    }

    @Override
    public Object getAdapter(Class adapter) {
        Object o = this.artifactRepo.getAdapter(adapter);
        if (o != null) {
            return o;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return this.artifactRepo.getArtifactTocCapabilities();
    }

    @Override
    public boolean hasArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.artifactRepo.hasArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.artifactRepo.readArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) throws CoreException {
        return this.artifactRepo.readCachedArtifactToc(session, tocCache, monitor);
    }

    @Override
    public IStatus canCreateRepository() {
        return RepositoryStatus.createErrorStatus(6014, Messages.ERROR_CANT_CREATE_REPOSITORY_OF_TYPE, this.getType(), this.getLocationStr());
    }

    @Override
    protected IStatus doImportP2Repository(File p2RepositoryFile, IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus deleteP2Repository(IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus exportP2Repository(File destinationFile, IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsP2Repository(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus addNLSFile(String fileName, InputStream source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus deleteNLSFile(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getNLSFileList() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InputStream openNLSFileStream(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public RepositorySiteProperties getSiteProperties() {
        try {
            return this.getMetaRepo((IProgressMonitor)new NullProgressMonitor()).getSiteProperties();
        }
        catch (Exception ex) {
            return super.getSiteProperties();
        }
    }

    public static interface IExtDisk1Info {
        public void refresh();

        public String getDiskSetId();

        public VolumeAtocUtil getVolumeAtocUtil(IArtifactSession var1, IProgressMonitor var2) throws CoreException, IOException;

        public void createMasterDiskSetMetadataRepoInVolumeRepo(IRepository var1, IProgressMonitor var2) throws CoreException, IOException;

        public IRepository getInnerMetaRepo();

        public IRepository getMasterDiskSetArtifactRepo(IProgressMonitor var1) throws CoreException, IOException;

        public DiskMounter findDisk(int var1);

        public IDiskMounterFactory getDiskMounterFactory(String var1);

        public DiskTagFile.DiskTagProperties getDiskTagProperties();

        public boolean canFindAvailableDisks(DiskMounter var1);
    }
}

