/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.definitions.CommonDef;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.SimpleIdentity;
import com.ibm.cic.common.core.model.internal.CICWriter;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.MapSet;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UnsupportedOperationException;
import com.ibm.cic.common.downloads.ProgressMonitorInputStream;
import com.ibm.cic.common.logging.ExceptionUtil;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Set;
import java.util.TreeSet;
import java.util.zip.GZIPInputStream;
import java.util.zip.ZipEntry;
import java.util.zip.ZipInputStream;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Platform;
import org.eclipse.core.runtime.Status;
import org.eclipse.osgi.util.NLS;

public class Util {
    public static final Iterator EMPTY_ITERATOR = new Iterator(){

        @Override
        public boolean hasNext() {
            return false;
        }

        public Object next() {
            throw new NoSuchElementException();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    };

    public static boolean equals(Object o1, Object o2) {
        return o1 == o2 || o1 != null && o1.equals(o2);
    }

    public static int hashCode(Object o) {
        return o == null ? 0 : o.hashCode();
    }

    public static int hashCode(Object ... objects) {
        return Arrays.hashCode(objects);
    }

    public static StringBuffer trimEnd(StringBuffer sb) {
        int l = sb.length();
        while (l > 0) {
            if (sb.charAt(l - 1) > ' ') break;
            --l;
        }
        if (l < sb.length()) {
            sb.setLength(l);
        }
        return sb;
    }

    public static String[] toStringArray(Collection collection) {
        return collection.isEmpty() ? CommonDef.EmptyStringArray : collection.toArray(new String[collection.size()]);
    }

    public static String[] slice(String[] array, int first, int last) {
        if (first == 0 && last == array.length) {
            return array;
        }
        if (last <= first) {
            return new String[0];
        }
        String[] result = new String[last - first];
        System.arraycopy(array, first, result, 0, last - first);
        return result;
    }

    public static <T> T[] splice(T[] array, T ... elems) {
        int length = array.length + elems.length;
        Object[] result = (Object[])Array.newInstance(array.getClass().getComponentType(), length);
        System.arraycopy(array, 0, result, 0, array.length);
        System.arraycopy(elems, 0, result, array.length, elems.length);
        return result;
    }

    public static IStatus unzipFile(boolean isUndoable, File zipFile, File outputDir, boolean sync) {
        return Util.unzipFile(isUndoable, zipFile, outputDir, null, sync, null);
    }

    public static IStatus unzipFile(boolean isUndoable, File zipFile, File outputDir) {
        boolean sync = false;
        return Util.unzipFile(isUndoable, zipFile, outputDir, null, sync, null);
    }

    public static IStatus unzipFile(boolean isUndoable, File zipFile, File outputDir, String taskName, boolean sync, IProgressMonitor monitor) {
        CicMultiStatus result;
        block15: {
            result = Statuses.ST.createMultiStatus();
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(zipFile);
                    Util.unzipStream(result, isUndoable, in, zipFile.length(), outputDir, taskName, sync, monitor);
                }
                catch (FileNotFoundException e) {
                    result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e2) {
                            result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e2.toString(), null));
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
                }
            }
        }
        if (!result.isOK()) {
            result.setMessage(NLS.bind((String)Messages.Util_Error_Unzipping, (Object)zipFile, (Object)result.getChildren()[0].getMessage()));
        }
        return result;
    }

    public static IStatus unzipStream(boolean isUndoable, Object source, InputStream in, long size, File outDir, String taskName, IProgressMonitor monitor) {
        return Util.unzipStream(isUndoable, source, in, size, (IUnzipEntryHelper)new DefaultUnzipToFileHelper(outDir, false), taskName, monitor);
    }

    public static IStatus unzipStream(boolean isUndoable, Object source, InputStream in, long size, IUnzipEntryHelper unzipToFileHelper, String taskName, IProgressMonitor monitor) {
        CicMultiStatus result = Statuses.ST.createMultiStatus();
        try {
            Util.unzipStream(result, isUndoable, in, size, unzipToFileHelper, taskName, monitor);
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (IOException e) {
                    result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
                }
            }
        }
        if (!result.isOK()) {
            result.setMessage(NLS.bind((String)Messages.Util_Error_Unzipping, (Object)source, (Object)result.getChildren()[0].getMessage()));
        }
        return result;
    }

    public static OutputStream makeOutputStream(CicMultiStatus result, final ZipEntry ze, final File outFile, boolean sync) throws IOException {
        if (ze.isDirectory()) {
            IStatus status = FileUtil.makeDirectories(outFile);
            if (!status.isOK()) {
                result.add(status);
            }
        } else {
            if (outFile.exists()) {
                outFile.delete();
            } else {
                IStatus status = FileUtil.makeDirectories(outFile.getParentFile());
                if (!status.isOK()) {
                    result.add(status);
                    return null;
                }
            }
            if (sync) {
                return new FileUtil.SyncOnCloseFileOutputStream(outFile){
                    boolean setLastModifiedCalled;
                    {
                        super($anonymous0);
                        this.setLastModifiedCalled = false;
                    }

                    @Override
                    public void close() throws IOException {
                        super.close();
                        if (!this.setLastModifiedCalled) {
                            this.setLastModifiedCalled = true;
                            outFile.setLastModified(ze.getTime());
                        }
                    }
                };
            }
            return new FileUtil.NoFinalizeCloseFileOutputStream(outFile){
                boolean setLastModifiedCalled;
                {
                    super($anonymous0);
                    this.setLastModifiedCalled = false;
                }

                @Override
                public void close() throws IOException {
                    super.close();
                    if (!this.setLastModifiedCalled) {
                        this.setLastModifiedCalled = true;
                        outFile.setLastModified(ze.getTime());
                    }
                }
            };
        }
        return null;
    }

    private static void unzipStream(CicMultiStatus result, boolean isUndoable, InputStream stream, long size, File outputDir, String taskName, boolean sync, IProgressMonitor monitor) {
        Util.unzipStream(result, isUndoable, stream, size, (IUnzipEntryHelper)new DefaultUnzipToFileHelper(outputDir, sync), taskName, monitor);
    }

    private static void unzipStream(CicMultiStatus result, boolean isUndoable, InputStream stream, long size, IUnzipEntryHelper unzipEntryHelper, String taskName, IProgressMonitor monitor) {
        if (stream == null) {
            throw new NullPointerException();
        }
        InputStream is = monitor == null ? stream : new ProgressMonitorInputStream(stream, size, size, taskName, monitor);
        ZipInputStream in = new ZipInputStream(is);
        ZipEntry ze = null;
        try {
            ze = in.getNextEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ze == null) {
            result.add(Statuses.ERROR.get(Messages.Util_Invalid_Zip_File_Format, new Object[0]));
            try {
                in.close();
            }
            catch (IOException e) {
                result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
            }
            return;
        }
        do {
            try {
                int bufSize = 8192;
                OutputStream out = unzipEntryHelper.makeOutputStream(result, ze);
                if (out != null) {
                    Util.copyStream(new BufferedInputStream(in, bufSize), false, out, true, bufSize);
                    unzipEntryHelper.doneUsingStream(ze, out);
                }
            }
            catch (IOException e) {
                result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
                if (isUndoable) break;
            }
            try {
                in.closeEntry();
                ze = in.getNextEntry();
            }
            catch (IOException e) {
                result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
                ze = null;
            }
        } while (ze != null);
        try {
            in.close();
        }
        catch (IOException e) {
            result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
        }
    }

    public static IStatus checkCanUnzipFile(File zipFile, String taskName, IProgressMonitor monitor) {
        CicMultiStatus result;
        block15: {
            result = Statuses.ST.createMultiStatus();
            FileInputStream in = null;
            try {
                try {
                    in = new FileInputStream(zipFile);
                    Util.checkCanUnzipStream(result, in, zipFile.length(), taskName, monitor);
                }
                catch (FileNotFoundException e) {
                    result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
                    if (in != null) {
                        try {
                            ((InputStream)in).close();
                        }
                        catch (IOException e2) {
                            result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e2.toString(), null));
                        }
                    }
                    break block15;
                }
            }
            catch (Throwable throwable) {
                if (in != null) {
                    try {
                        ((InputStream)in).close();
                    }
                    catch (IOException e) {
                        result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
                    }
                }
                throw throwable;
            }
            if (in != null) {
                try {
                    ((InputStream)in).close();
                }
                catch (IOException e) {
                    result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
                }
            }
        }
        if (!result.isOK()) {
            result.setMessage(NLS.bind((String)Messages.Util_Error_Unzipping, (Object)zipFile, (Object)result.getChildren()[0].getMessage()));
        }
        return result;
    }

    private static void checkCanUnzipStream(CicMultiStatus result, InputStream stream, long size, String taskName, IProgressMonitor monitor) {
        InputStream is = monitor == null ? stream : new ProgressMonitorInputStream(stream, size, size, taskName, monitor);
        ZipInputStream in = new ZipInputStream(is);
        ZipEntry ze = null;
        try {
            ze = in.getNextEntry();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (ze == null) {
            result.add(Statuses.ERROR.get(Messages.Util_Invalid_Zip_File_Format, new Object[0]));
            try {
                in.close();
            }
            catch (IOException e) {
                result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
            }
            return;
        }
        do {
            try {
                Util.copyStream(in, false, new NullOutputStream(), true);
            }
            catch (IOException e) {
                result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
            }
            try {
                in.closeEntry();
                ze = in.getNextEntry();
            }
            catch (IOException e) {
                result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
                ze = null;
            }
        } while (ze != null);
        try {
            in.close();
        }
        catch (IOException e) {
            result.add((IStatus)new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, e.toString(), null));
        }
    }

    public static void deleteEmptyDirs(File dir) throws IOException {
        FileUtil.deleteEmptyDirs(dir);
    }

    public static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut) throws IOException {
        int bufSize = 16384;
        return Util.copyStream(in, closeIn, out, closeOut, bufSize);
    }

    public static int copyStream(InputStream in, boolean closeIn, OutputStream out, boolean closeOut, int bufSize) throws IOException {
        try {
            int len;
            int written = 0;
            byte[] buffer = new byte[bufSize];
            while ((len = in.read(buffer)) != -1) {
                out.write(buffer, 0, len);
                written += len;
            }
            int n = written;
            return n;
        }
        finally {
            try {
                if (closeIn) {
                    in.close();
                }
            }
            finally {
                if (closeOut) {
                    out.close();
                }
            }
        }
    }

    public static Set toSelectors(IShareableEntity entity, Set selectorIds) {
        if (selectorIds == null) {
            return entity.getSelectors();
        }
        LinkedHashSet<IContentSelector> result = new LinkedHashSet<IContentSelector>(selectorIds.size());
        for (String selectorId : selectorIds) {
            IContentSelector sel = entity.getSelector(new SimpleIdentity(selectorId), false);
            if (sel == null) continue;
            result.add(sel);
        }
        return result;
    }

    public static IContentSelector[] toSelectors(IShareableEntity entity, String[] selectorIds) {
        if (selectorIds == null) {
            Set selectors = entity.getSelectors();
            return selectors.toArray(new IContentSelector[selectors.size()]);
        }
        LinkedHashSet<IContentSelector> selectors = new LinkedHashSet<IContentSelector>(selectorIds.length);
        String[] stringArray = selectorIds;
        int n = selectorIds.length;
        int n2 = 0;
        while (n2 < n) {
            String selectorId = stringArray[n2];
            IContentSelector sel = entity.getSelector(new SimpleIdentity(selectorId), false);
            if (sel != null) {
                selectors.add(sel);
            }
            ++n2;
        }
        IContentSelector[] result = new IContentSelector[selectors.size()];
        selectors.toArray(result);
        return result;
    }

    public static IContentSelector[] toSelectors(IShareableEntity entity, String selectorIds) {
        return Util.toSelectors(entity, selectorIds == null ? null : selectorIds.split(","));
    }

    public static boolean addAll(Collection collection, Object[] array) {
        boolean result = false;
        Object[] objectArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            Object element = objectArray[n2];
            result |= collection.add(element);
            ++n2;
        }
        return result;
    }

    public static boolean addUnique(Collection to, Collection from) {
        boolean result = false;
        for (Object o : from) {
            if (to.contains(o)) continue;
            to.add(o);
            result = true;
        }
        return result;
    }

    public static List concatenate(Collection c1, Collection c2) {
        ArrayList result = new ArrayList(c1.size() + c2.size());
        result.addAll(c1);
        result.addAll(c2);
        return result;
    }

    public static <T> Set<T> setDiff(Collection<T> c1, Collection<T> c2) {
        LinkedHashSet<T> result = new LinkedHashSet<T>(c1);
        result.removeAll(c2);
        return result;
    }

    public static String toSelectorIdString(Set selectors) {
        return Util.toString((Collection)selectors, new Formatter(){

            @Override
            public String format(Object object) {
                IContentSelector selector = (IContentSelector)object;
                return selector.getIdentity().toString();
            }
        });
    }

    public static String toFeatureIdString(Collection features) {
        return Util.toString(features, new Formatter(){

            @Override
            public String format(Object object) {
                return ((IFeature)object).getIdentity().toString();
            }
        });
    }

    public static String toFeatureIdString(IFeature[] features) {
        return Util.toString(features, new Formatter(){

            @Override
            public String format(Object object) {
                return ((IFeature)object).getIdentity().toString();
            }
        });
    }

    public static String toPlatformString(MapSet<String, String> platforms) {
        TreeSet<String> p = new TreeSet<String>();
        for (String os : platforms.keySet()) {
            for (String arch : platforms.get(os)) {
                p.add(String.valueOf(os) + "." + arch);
            }
        }
        return Util.toString(p, new Formatter());
    }

    public static Set toOrderedSet(String str, char sep) {
        return Util.toOrderedSet(str, sep, null);
    }

    public static Set toOrderedSet(String str, char sep, String initialValue) {
        if (str.length() == 0) {
            return initialValue == null ? Collections.EMPTY_SET : Collections.singleton(initialValue);
        }
        Set<String> result = new LinkedHashSet<String>();
        if (initialValue != null) {
            result.add(initialValue);
        }
        int start = 0;
        int end = str.indexOf(sep);
        while (start < end && end < str.length()) {
            result.add(str.substring(start, end).trim());
            start = end + 1;
            end = str.indexOf(sep, start);
        }
        String lastItem = str.substring(start).trim();
        if (result.isEmpty()) {
            result = Collections.singleton(lastItem);
        } else {
            result.add(lastItem);
        }
        return result;
    }

    public static List<String> toList(String str, char sep, String initialValue) {
        if (str.length() == 0) {
            return initialValue == null ? Collections.EMPTY_LIST : Collections.singletonList(initialValue);
        }
        ArrayList<String> return_value = new ArrayList<String>();
        if (initialValue != null) {
            return_value.add(initialValue);
        }
        int start = 0;
        int end = str.indexOf(sep);
        while (start < end && end < str.length()) {
            return_value.add(str.substring(start, end).trim());
            start = end + 1;
            end = str.indexOf(sep, start);
        }
        String lastItem = str.substring(start).trim();
        if (return_value.isEmpty()) {
            return_value = Collections.singletonList(lastItem);
        } else {
            return_value.add(lastItem);
        }
        return return_value;
    }

    public static String toString(Set set, char sep) {
        return Util.toString((Collection)set, new Formatter(String.valueOf(sep)));
    }

    public static boolean xmlEquals(IInstallableUnit iu1, IInstallableUnit iu2) {
        if (iu1 == null || iu2 == null) {
            return iu1 == iu2;
        }
        CICWriter w = new CICWriter();
        w.setMode(1);
        String iu1_xml = CICWriter.toXML(w, iu1);
        String iu2_xml = CICWriter.toXML(w, iu2);
        return iu1_xml.equals(iu2_xml);
    }

    public static int sum(int[] array) {
        int result = 0;
        int[] nArray = array;
        int n = array.length;
        int n2 = 0;
        while (n2 < n) {
            int element = nArray[n2];
            result += element;
            ++n2;
        }
        return result;
    }

    public static int indexOf(Object[] array, Object object) {
        int i = 0;
        while (i < array.length) {
            if (object == null ? array[i] == null : object.equals(array[i])) {
                return i;
            }
            ++i;
        }
        return -1;
    }

    public static String toString(Collection collection, Formatter formatter) {
        return Util.toString(collection.iterator(), formatter);
    }

    public static String toString(Object[] array, Formatter formatter) {
        return Util.toString(new ArrayIterator(array), formatter);
    }

    private static String toString(Iterator iterator, Formatter formatter) {
        if (!iterator.hasNext()) {
            return formatter.emptyString();
        }
        String first = formatter.format(iterator.next());
        if (!iterator.hasNext()) {
            return first;
        }
        String separator = formatter.getSeparator();
        StringBuffer sb = new StringBuffer(4 * (first.length() + separator.length()));
        sb.append(first);
        do {
            sb.append(separator).append(formatter.format(iterator.next()));
        } while (iterator.hasNext());
        return sb.toString();
    }

    public static String toString(Map map, final MapFormatter formatter) {
        return Util.toString(map.entrySet().iterator(), new Formatter(formatter.getValueSeparator()){

            @Override
            protected String emptyString() {
                return formatter.emptyString();
            }

            @Override
            protected String format(Object object) {
                Map.Entry entry = (Map.Entry)object;
                return String.valueOf(formatter.formatKey(entry.getKey())) + formatter.getKeySeparator() + formatter.formatValue(entry.getValue());
            }
        });
    }

    public static <T> Iterable<T> reverse(final List<T> list) {
        return new Iterable<T>(){

            @Override
            public Iterator<T> iterator() {
                return new ReverseIterator(list);
            }
        };
    }

    public static <E> Iterable<E> join(final Iterable<E> i1, final Iterable<E> i2) {
        return new Iterable<E>(){

            @Override
            public Iterator<E> iterator() {
                return new JoinIterator(i1, i2);
            }
        };
    }

    public static void gunzipAndCopy(InputStream in, OutputStream out) throws IOException {
        int size = 8192;
        byte[] bytes = new byte[size];
        int count = 0;
        GZIPInputStream gis = null;
        try {
            gis = new GZIPInputStream(in);
            while ((count = gis.read(bytes, 0, size)) != -1) {
                out.write(bytes, 0, count);
            }
        }
        finally {
            gis = null;
            bytes = null;
        }
    }

    public static boolean isValidUrl(String url) {
        if (url != null && url.length() > 0) {
            try {
                new URL(url);
                return true;
            }
            catch (MalformedURLException ex) {
                ExceptionUtil.debugLogMalformedURLException(ex);
            }
        }
        return false;
    }

    public static String[] splitString(String str, String expr) {
        String[] strArray = str.split(expr);
        int i = 0;
        while (i < strArray.length) {
            strArray[i] = strArray[i].trim();
            ++i;
        }
        return strArray;
    }

    public static List splitStringAsList(String str, String expr) {
        return Arrays.asList(Util.splitString(str, expr));
    }

    public static String toVersionsString(List<IOffering> rollbackVersions) {
        return Util.toString(rollbackVersions, new Formatter(){

            @Override
            protected String format(Object object) {
                return ((IOffering)object).getVersion().toString();
            }
        });
    }

    public static String getSecurityAlgorihm() {
        String ibmAlgorithm = "PBEWithSHAAnd3KeyTripleDES";
        String sunAlgorithm = "PBEWithSHA1AndDESede";
        if ("linux".equals(Platform.getOS()) && "ia64".equals(Platform.getOSArch())) {
            return ibmAlgorithm;
        }
        String jvmVendor = System.getProperty("java.vendor");
        if (jvmVendor.equals("Sun Microsystems Inc.") || jvmVendor.equals("Oracle Corporation")) {
            return sunAlgorithm;
        }
        return ibmAlgorithm;
    }

    public static class ArrayIterator
    implements Iterator {
        private final Object[] array;
        private int next;

        public ArrayIterator(Object[] array) {
            this.array = array;
            this.next = 0;
        }

        @Override
        public boolean hasNext() {
            return this.next < this.array.length;
        }

        public Object next() throws NoSuchElementException {
            try {
                return this.array[this.next++];
            }
            catch (ArrayIndexOutOfBoundsException e) {
                throw new NoSuchElementException();
            }
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    static class DefaultUnzipToFileHelper
    implements IUnzipEntryHelper {
        private final File outDir;
        private final boolean sync;

        public DefaultUnzipToFileHelper(File outDir, boolean sync) {
            this.outDir = outDir;
            this.sync = sync;
        }

        @Override
        public OutputStream makeOutputStream(CicMultiStatus result, ZipEntry ze) throws IOException {
            File outFile = new File(this.outDir, ze.getName());
            return Util.makeOutputStream(result, ze, outFile, this.sync);
        }

        @Override
        public void doneUsingStream(ZipEntry entry, OutputStream out) {
        }
    }

    public static class Formatter {
        public static final Formatter DEFAULT = new Formatter();
        private final String separator;

        public Formatter() {
            this(",");
        }

        public Formatter(String separator) {
            this.separator = separator;
        }

        protected String emptyString() {
            return "";
        }

        protected String format(Object object) {
            return String.valueOf(object);
        }

        protected String getSeparator() {
            return this.separator;
        }
    }

    public static interface IUnzipEntryHelper {
        public OutputStream makeOutputStream(CicMultiStatus var1, ZipEntry var2) throws IOException;

        public void doneUsingStream(ZipEntry var1, OutputStream var2);
    }

    public static class JoinIterator<E>
    implements Iterator<E> {
        private final Iterator<E> i1;
        private final Iterator<E> i2;

        public JoinIterator(Iterable<E> i1, Iterable<E> i2) {
            this(i1.iterator(), i2.iterator());
        }

        public JoinIterator(Iterator<E> i1, Iterator<E> i2) {
            this.i1 = i1;
            this.i2 = i2;
        }

        @Override
        public boolean hasNext() {
            return this.i1.hasNext() || this.i2.hasNext();
        }

        @Override
        public E next() {
            return this.i1.hasNext() ? this.i1.next() : this.i2.next();
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static class MapFormatter {
        public static final MapFormatter DEFAULT = new MapFormatter();
        private final String keySeparator;
        private final String valueSeparator;

        public MapFormatter() {
            this(": ", "\n");
        }

        public MapFormatter(String keySeparator, String valueSeparator) {
            this.keySeparator = keySeparator;
            this.valueSeparator = valueSeparator;
        }

        protected String emptyString() {
            return "";
        }

        protected String formatKey(Object key) {
            return String.valueOf(key);
        }

        protected String formatValue(Object value) {
            return String.valueOf(value);
        }

        protected String getKeySeparator() {
            return this.keySeparator;
        }

        protected String getValueSeparator() {
            return this.valueSeparator;
        }
    }

    public static abstract class Mapper {
        protected abstract Object map(Object var1);

        public List on(Object[] array) {
            return this.on(Arrays.asList(array));
        }

        public List on(Collection collection) {
            return (List)this.fromTo(collection.iterator(), new ArrayList(collection.size()));
        }

        public Collection fromTo(Collection src, Collection dst) {
            return this.fromTo(src.iterator(), dst);
        }

        public Collection fromTo(Iterator iter, Collection dst) {
            while (iter.hasNext()) {
                Object mapped = this.map(iter.next());
                if (mapped == null) continue;
                dst.add(mapped);
            }
            return dst;
        }
    }

    public static class NullOutputStream
    extends OutputStream {
        @Override
        public void close() throws IOException {
            super.close();
        }

        @Override
        public void flush() throws IOException {
            super.flush();
        }

        @Override
        public void write(byte[] b, int off, int len) throws IOException {
            super.write(b, off, len);
        }

        @Override
        public void write(byte[] b) throws IOException {
            super.write(b);
        }

        @Override
        public void write(int b) {
        }
    }

    public static class ReverseIterator<T>
    implements Iterator<T> {
        private final ListIterator<T> iterator;

        public ReverseIterator(List<T> list) {
            this.iterator = list.listIterator(list.size());
        }

        @Override
        public boolean hasNext() {
            return this.iterator.hasPrevious();
        }

        @Override
        public T next() {
            return this.iterator.previous();
        }

        @Override
        public void remove() {
            this.iterator.remove();
        }
    }
}

