/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

public class UserNames {
    public static final String NO_NAME = "";
    private final String pureLogicalName;
    private final String pureSystemName;

    public UserNames(String logicalName, String systemName) {
        this.pureLogicalName = logicalName == null ? NO_NAME : logicalName;
        String string = this.pureSystemName = systemName == null ? NO_NAME : systemName;
        if (NO_NAME.equals(this.pureLogicalName) && NO_NAME.equals(this.pureSystemName)) {
            throw new IllegalArgumentException("At least one name must be non empty");
        }
    }

    public boolean hasDistinctSystemName() {
        String name = this.getPureSystemName();
        return !name.equals(NO_NAME);
    }

    public String getSystemName() {
        String name = this.getPureSystemName();
        if (name.equals(NO_NAME)) {
            name = this.getPureLogicalName();
        }
        return name;
    }

    public boolean hasDistinctLogicalName() {
        String name = this.getPureLogicalName();
        return !name.equals(NO_NAME);
    }

    public String getLogicalName() {
        String name = this.getPureLogicalName();
        if (name.equals(NO_NAME)) {
            name = this.getPureSystemName();
        }
        return name;
    }

    public String getPureSystemName() {
        return this.pureSystemName;
    }

    public String getPureLogicalName() {
        return this.pureLogicalName;
    }
}

