/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.utils.AbstractPlatformPolicyFactory;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.downloads.ITransferMonitor;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import org.eclipse.core.runtime.Path;

class PPFileUtil
extends AbstractPlatformPolicyFactory {
    static PPFileUtil m_factory = new PPFileUtil();

    PPFileUtil() {
    }

    @Override
    protected Object createLinuxPolicy() {
        return new PPLinux();
    }

    @Override
    protected Object createHpuxPolicy() {
        return new PPHPUX();
    }

    @Override
    protected Object createOS400Policy() {
        return new PPOS400();
    }

    @Override
    protected Object createWindowsPolicy() {
        return new PPWindows();
    }

    static PPCommon getPolicy() {
        return (PPCommon)m_factory.getPlatformPolicy();
    }

    abstract class PPCommon {
        PPCommon() {
        }

        abstract String processPathForComparison(File var1);

        abstract File fixLongFileName(File var1);

        void copyFile(File file, File destination, long blockSize, boolean syncOnClose, ITransferMonitor transferPerformance, long[] outBytesCopied) throws IOException, FileNotFoundException {
            FileUtil.copyFile(FileUtil.DEFAULT_CHANNEL_TRANSFER, file, destination, blockSize, syncOnClose, transferPerformance, outBytesCopied);
        }

        void copyFile(File file, File destination) throws IOException, FileNotFoundException {
            FileUtil.copyFile(FileUtil.DEFAULT_CHANNEL_TRANSFER, file, destination);
        }

        abstract boolean canRead(File var1);

        abstract boolean canWrite(File var1);
    }

    class PPHPUX
    extends PPLinux {
        PPHPUX() {
        }

        @Override
        void copyFile(File file, File destination, long blockSize, boolean syncOnClose, ITransferMonitor transferPerformance, long[] outBytesCopied) throws IOException, FileNotFoundException {
            FileInputStream fin = new FileInputStream(file);
            FileUtil.copyStream(fin, destination, null);
            outBytesCopied[0] = destination.length();
        }
    }

    class PPLinux
    extends PPCommon {
        PPLinux() {
        }

        @Override
        String processPathForComparison(File path) {
            String path1 = FileUtil.getCanonicalPath(path);
            if (path1.endsWith(File.separator)) {
                path1 = path1.substring(0, path1.length() - File.separator.length());
            }
            return path1;
        }

        @Override
        File fixLongFileName(File file) {
            return file;
        }

        @Override
        boolean canRead(File file) {
            boolean return_value = false;
            if (file != null) {
                try {
                    return_value = file.canRead();
                }
                catch (SecurityException se) {
                    return_value = false;
                }
            }
            return return_value;
        }

        @Override
        boolean canWrite(File file) {
            boolean return_value = false;
            if (file != null) {
                try {
                    return_value = file.canWrite();
                }
                catch (SecurityException se) {
                    return_value = false;
                }
            }
            return return_value;
        }
    }

    class PPOS400
    extends PPLinux {
        PPOS400() {
        }

        @Override
        void copyFile(File file, File destination, long blockSize, boolean syncOnClose, ITransferMonitor transferPerformance, long[] outBytesCopied) throws IOException, FileNotFoundException {
            FileInputStream fin = new FileInputStream(file);
            outBytesCopied[0] = FileUtil.copyStream(file.length(), fin, destination, syncOnClose, transferPerformance);
        }

        @Override
        void copyFile(File file, File destination) throws IOException, FileNotFoundException {
            FileInputStream fin = new FileInputStream(file);
            FileUtil.copyStream(fin, destination, null);
        }
    }

    class PPWindows
    extends PPCommon {
        PPWindows() {
        }

        @Override
        String processPathForComparison(File path) {
            String path1 = FileUtil.getCanonicalPath(path);
            if ((path1 = path1.toLowerCase()).endsWith(File.separator)) {
                path1 = path1.substring(0, path1.length() - File.separator.length());
            }
            return path1;
        }

        @Override
        File fixLongFileName(File file) {
            String filename = file.getAbsolutePath();
            if (filename.length() >= 256) {
                String prefix = "\\\\?\\";
                String UNCPrefix = "\\\\?\\UNC\\";
                Path path = new Path(filename);
                if (path.isUNC()) {
                    if (!filename.startsWith(UNCPrefix)) {
                        return new File(String.valueOf(UNCPrefix) + path.toOSString());
                    }
                } else if (!filename.startsWith(prefix)) {
                    return new File(String.valueOf(prefix) + path.toOSString());
                }
            }
            return file;
        }

        @Override
        boolean canRead(File file) {
            boolean return_value = false;
            if (file != null && file.exists()) {
                SecurityManager security = System.getSecurityManager();
                if (security != null) {
                    try {
                        security.checkRead(file.getPath());
                        return_value = true;
                    }
                    catch (SecurityException securityException) {}
                } else if (file.isDirectory()) {
                    return_value = file.list() != null;
                } else {
                    try {
                        Reader reader = Encodings.UTF8.reader(file);
                        return_value = true;
                        reader.close();
                    }
                    catch (FileNotFoundException fileNotFoundException) {
                    }
                    catch (IOException iOException) {
                        // empty catch block
                    }
                }
            }
            return return_value;
        }

        @Override
        boolean canWrite(File file) {
            boolean return_value;
            block17: {
                return_value = false;
                if (file != null && file.exists()) {
                    SecurityManager security = System.getSecurityManager();
                    if (security != null) {
                        try {
                            security.checkWrite(file.getPath());
                            return_value = true;
                        }
                        catch (SecurityException securityException) {}
                    } else if (file.isDirectory()) {
                        File testFile = null;
                        try {
                            try {
                                testFile = FileUtil.createTempFile("testCanWrite", null, file);
                                return_value = true;
                            }
                            catch (IOException iOException) {
                                if (testFile != null && testFile.exists()) {
                                    return_value = FileUtil.delete(testFile) && return_value;
                                }
                                break block17;
                            }
                        }
                        catch (Throwable throwable) {
                            if (testFile != null && testFile.exists()) {
                                return_value = FileUtil.delete(testFile) && return_value;
                            }
                            throw throwable;
                        }
                        if (testFile != null && testFile.exists()) {
                            return_value = FileUtil.delete(testFile) && return_value;
                        }
                    } else {
                        try {
                            Writer writer = Encodings.UTF8.writer(file);
                            return_value = true;
                            writer.close();
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
            }
            return return_value;
        }
    }
}

