/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.preferences.CicCommonSettings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Messages;
import com.ibm.cic.common.core.utils.PlatformUtils;
import java.io.File;
import java.io.IOException;

public class JettyDataKeeper {
    public static final JettyDataKeeper INSTANCE = new JettyDataKeeper();
    private static final String RESTART_DATA_FILE = "restart.data";
    private String passcode = null;
    private boolean restartInProgress = false;
    private boolean isUISessionDestroyed = false;

    private JettyDataKeeper() {
    }

    public String getPasscode() {
        return this.passcode;
    }

    public void setPasscode(String passcode) {
        this.passcode = passcode;
    }

    public boolean isRestarting() {
        return this.restartInProgress;
    }

    public void saveBeforeRestart() {
        String parent = CicCommonSettings.getApplicationDataLocation();
        File file = new File(parent, RESTART_DATA_FILE);
        try {
            if (file.exists()) {
                file.delete();
            }
            String contents = this.passcode != null ? this.passcode : "";
            FileUtil.writeFile(file, contents);
            if (!CicCommonSettings.isWindows()) {
                PlatformUtils.chmod(new String[]{file.getPath()}, "u+r", false);
            }
        }
        catch (IOException e) {
            System.out.println(Messages.JettyDataKeeper_UnableToSavePasswordForRestart);
        }
    }

    public void load() {
        String parent = CicCommonSettings.getApplicationDataLocation();
        File file = new File(parent, RESTART_DATA_FILE);
        if (file.exists()) {
            this.restartInProgress = true;
            try {
                try {
                    String value = FileUtil.readFile(file);
                    if (value != null && !value.isEmpty()) {
                        this.passcode = value;
                    }
                }
                catch (IOException e) {
                    System.out.println(Messages.JettyDataKeeper_UnableToRestorePasswordAfterRestart);
                    file.delete();
                }
            }
            finally {
                file.delete();
            }
        }
    }

    public synchronized boolean isUISessionDestroyed() {
        return this.isUISessionDestroyed;
    }

    public synchronized void setUISessionDestroyed(boolean value) {
        this.isUISessionDestroyed = value;
    }
}

