/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.utils;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IFeature;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IIncludedShareableEntity;
import com.ibm.cic.common.core.model.IIncludedSuFragment;
import com.ibm.cic.common.core.model.IRequiredShareableEntity;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.ISuFragmentSelector;
import com.ibm.cic.common.core.model.IncludedShareableEntitySelector;
import com.ibm.icu.text.Collator;
import com.ibm.icu.text.RuleBasedCollator;
import java.lang.ref.SoftReference;
import java.util.Comparator;
import java.util.Locale;
import org.eclipse.osgi.service.resolver.VersionRange;
import org.osgi.framework.Version;

public class Comparators {
    public static final Comparator<IIdentity> IDENTITY = new Comparator<IIdentity>(){

        @Override
        public int compare(IIdentity id1, IIdentity id2) {
            return Comparators.compare(id1, id2);
        }
    };
    public static final Comparator<IContent> CONTENT_COMPARATOR = new Comparator<IContent>(){

        @Override
        public int compare(IContent unit1, IContent unit2) {
            return Comparators.compare(unit1, unit2);
        }
    };
    public static final Comparator<IContent> CONTENT_NAME_VERSION = new Comparator<IContent>(){

        @Override
        public int compare(IContent a, IContent b) {
            return Comparators.compareNameVersion(a, b);
        }
    };
    public static final Comparator<IContentSelector> CONTENT_SELECTOR = new Comparator<IContentSelector>(){

        @Override
        public int compare(IContentSelector sel1, IContentSelector sel2) {
            return Comparators.compare(sel1.getIdentity(), sel2.getIdentity());
        }
    };
    public static final Comparator<ISuFragmentSelector> SU_FRAGMENT_SELECTOR = new Comparator<ISuFragmentSelector>(){

        @Override
        public int compare(ISuFragmentSelector sel1, ISuFragmentSelector sel2) {
            return Comparators.compare(sel1.getIdentity(), sel2.getIdentity());
        }
    };
    public static final Comparator<IFeature> FEATURE = new Comparator<IFeature>(){

        @Override
        public int compare(IFeature feature1, IFeature feature2) {
            return Comparators.compare(feature1.getIdentity(), feature2.getIdentity());
        }
    };
    public static final Comparator<IShareableEntity> SE_VERSION = new Comparator<IShareableEntity>(){

        @Override
        public int compare(IShareableEntity se1, IShareableEntity se2) {
            if (!$assertionsDisabled && !se1.getIdentity().equals(se2.getIdentity())) {
                throw new AssertionError();
            }
            return se2.getVersion().compareTo(se1.getVersion());
        }
    };
    public static final Comparator<VersionRange> VERSION_RANGE = new Comparator<VersionRange>(){

        @Override
        public int compare(VersionRange range1, VersionRange range2) {
            return Comparators.compare(range1, range2);
        }
    };
    public static final Comparator<IIncludedShareableEntity> ISE_COMPARATOR = new Comparator<IIncludedShareableEntity>(){

        @Override
        public int compare(IIncludedShareableEntity s0, IIncludedShareableEntity s1) {
            return Comparators.compare(s0.getIdentity(), s0.getVersion(), s1.getIdentity(), s1.getVersion());
        }
    };
    public static final Comparator<IIncludedSuFragment> ISUF_COMPARATOR = new Comparator<IIncludedSuFragment>(){

        @Override
        public int compare(IIncludedSuFragment s0, IIncludedSuFragment s1) {
            return Comparators.compare(s0.getIdentity(), s0.getVersion(), s1.getIdentity(), s1.getVersion());
        }
    };
    public static final Comparator<IRequiredShareableEntity> RSE_COMPARATOR = new Comparator<IRequiredShareableEntity>(){

        @Override
        public int compare(IRequiredShareableEntity s0, IRequiredShareableEntity s1) {
            return Comparators.compare(s0.getShareableId(), s1.getShareableId());
        }
    };
    public static final Comparator<IncludedShareableEntitySelector> ISES_COMPARATOR = new Comparator<IncludedShareableEntitySelector>(){

        @Override
        public int compare(IncludedShareableEntitySelector s0, IncludedShareableEntitySelector s1) {
            return Comparators.compare(s0.getSelectorId(), s1.getSelectorId());
        }
    };

    public static Comparator<String> getIcuComparator() {
        return CachedIcuComparator.get();
    }

    public static int compare(IContent unit1, IContent unit2) {
        return Comparators.compare(unit1.getIdentity(), unit1.getVersion(), unit2.getIdentity(), unit2.getVersion());
    }

    public static int compareNameVersion(IContent unit1, IContent unit2) {
        return Comparators.compareNameVersion(unit1, unit2, true);
    }

    public static int compareNameVersion(IContent unit1, IContent unit2, boolean increasingVersion) {
        int cmp = Comparators.getIcuComparator().compare(unit1.getName(), unit2.getName());
        if (cmp != 0) {
            return cmp;
        }
        IIdentity id1 = unit1.getIdentity();
        IIdentity id2 = unit2.getIdentity();
        Version v1 = unit1.getVersion();
        Version v2 = unit2.getVersion();
        return increasingVersion ? Comparators.compare(id1, v1, id2, v2) : Comparators.compare(id1, v2, id2, v1);
    }

    public static int compare(IIdentity id1, IIdentity id2) {
        return id1.getId().compareTo(id2.getId());
    }

    public static int compare(VersionRange r1, VersionRange r2) {
        int cmp = r1.getMinimum().compareTo(r2.getMinimum());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Comparators.compare(r1.getIncludeMinimum(), r2.getIncludeMinimum());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Comparators.compare(r1.getRight(), r2.getRight());
        if (cmp != 0) {
            return cmp;
        }
        cmp = Comparators.compare(r1.getIncludeMaximum(), r2.getIncludeMaximum());
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }

    public static int compare(Version v1, Version v2) {
        if (v1 == null) {
            return v2 == null ? 0 : 1;
        }
        if (v2 == null) {
            return -1;
        }
        return v1.compareTo(v2);
    }

    public static int compare(boolean b1, boolean b2) {
        return b1 == b2 ? 0 : (b1 ? 1 : -1);
    }

    private static int compare(IIdentity id1, Version v1, IIdentity id2, Version v2) {
        int cmp = Comparators.compare(id1, id2);
        return cmp != 0 ? cmp : v1.compareTo(v2);
    }

    private static class CachedIcuComparator {
        private static SoftReference<CmpAndLocale> ref = new SoftReference<Object>(null);

        private CachedIcuComparator() {
        }

        static Comparator<String> get() {
            Locale locale = Locale.getDefault();
            CmpAndLocale c = ref.get();
            if (c != null && c.locale.equals(locale)) {
                return c.cmp;
            }
            RuleBasedCollator collator = (RuleBasedCollator)Collator.getInstance();
            collator.setStrength(15);
            ref = new SoftReference<CmpAndLocale>(new CmpAndLocale((Comparator<String>)collator, locale));
            return collator;
        }

        private static class CmpAndLocale {
            final Comparator<String> cmp;
            final Locale locale;

            CmpAndLocale(Comparator<String> cmp, Locale locale) {
                this.cmp = cmp;
                this.locale = locale;
            }
        }
    }
}

