/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository.digest;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.repository.SliceUtils;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

class PlatformSlice {
    private static final Logger log = Logger.getLogger();
    private static final String PLATFORMS_PREFIX = "PLATFORMS_";
    private static final String KEY_SEP = "~";
    private static final String VALUE_SEP = ";";
    private static final String OS_PAT = "os=([^,;]*)";
    private static final String ARCH_PAT = "arch=([^,;]*)";
    private static final String VALUE_PAT = NLS.bind("{0}|{1}(?:,{0})?", (Object)"arch=([^,;]*)", (Object)"os=([^,;]*)");
    public static final PlatformSlice NULL = new NullPlatformSlice();
    private final List<Platform> platforms;

    public static String getPropertyKey(IIdentity id, Version version) {
        return PLATFORMS_PREFIX + id + KEY_SEP + version;
    }

    public PlatformSlice(String platformsProperty) {
        this(PlatformSlice.parsePlatformsProperty(platformsProperty));
    }

    PlatformSlice(String os, String arch) {
        this(Collections.singletonList(new Platform(os, arch)));
    }

    PlatformSlice(List<Platform> platforms) {
        this.platforms = platforms;
    }

    public String toString() {
        if (this.platforms.isEmpty()) {
            return "Not sliced by platform";
        }
        return "Platforms: " + this.toPropertyValue();
    }

    String toPropertyValue() {
        return Util.toString(this.platforms, new Util.Formatter(VALUE_SEP));
    }

    public PlatformSlice add(PlatformSlice other) {
        ArrayList<Platform> newPlatforms = new ArrayList<Platform>(this.platforms);
        for (Platform platform : other.platforms) {
            if (this.checkPlatform(platform.os, platform.arch).isOK()) continue;
            newPlatforms.add(platform);
        }
        return newPlatforms.isEmpty() ? this : new PlatformSlice(newPlatforms);
    }

    public PlatformSlice add(String os, String arch) {
        if (this.checkPlatform(os, arch).isOK()) {
            return this;
        }
        ArrayList<Platform> newPlatforms = new ArrayList<Platform>(this.platforms.size() + 1);
        newPlatforms.addAll(this.platforms);
        newPlatforms.add(new Platform(os, arch));
        return new PlatformSlice(newPlatforms);
    }

    public IStatus checkPlatform(String os, String arch) {
        if (this.platforms.isEmpty()) {
            return Status.OK_STATUS;
        }
        for (Platform platform : this.platforms) {
            if (!platform.matches(os, arch)) continue;
            return Statuses.OK.get(Messages.Repo_Applicable_Platform, platform);
        }
        if (this.platforms.size() == 1) {
            return Statuses.ERROR.get(Messages.Repo_Repository_Only_Contains_Files_For_Platform, this.platforms.get(0).getDisplayName());
        }
        return Statuses.ERROR.get(Messages.Repo_Only_Contains_Files_For_Platforms, Util.toString(this.platforms, new Util.Formatter("\n    "){

            @Override
            protected String format(Object object) {
                return ((Platform)object).getDisplayName();
            }
        }));
    }

    public List<String> getPlatformSliceDisplayNames() {
        ArrayList<String> platformDisplayNames = new ArrayList<String>();
        for (Platform platform : this.platforms) {
            platformDisplayNames.add(platform.getDisplayName());
        }
        return platformDisplayNames;
    }

    private static List<Platform> parsePlatformsProperty(String platformsProperty) {
        Pattern valuePat = Pattern.compile(VALUE_PAT);
        String[] values = Util.splitString(platformsProperty, VALUE_SEP);
        ArrayList<Platform> result = new ArrayList<Platform>(values.length);
        String[] stringArray = values;
        int n = values.length;
        int n2 = 0;
        while (n2 < n) {
            String value = stringArray[n2];
            Matcher valueMatcher = valuePat.matcher(value);
            if (!valueMatcher.matches()) {
                log.error(Messages.Repo_Malformed_Platform_Property_Value, value, platformsProperty);
            } else {
                String os = valueMatcher.group(2);
                String arch = valueMatcher.group(1);
                if (arch == null) {
                    arch = valueMatcher.group(3);
                }
                result.add(new Platform(os, arch));
            }
            ++n2;
        }
        return result;
    }

    private static class NullPlatformSlice
    extends PlatformSlice {
        NullPlatformSlice() {
            super(Collections.emptyList());
        }

        @Override
        public String toString() {
            return "Not a slice";
        }

        @Override
        public IStatus checkPlatform(String os, String arch) {
            return Statuses.OK.get(Messages.Repo_Applicable_Due_To_Not_A_Slice, new Object[0]);
        }

        @Override
        public List<String> getPlatformSliceDisplayNames() {
            return Collections.emptyList();
        }
    }

    private static class Platform {
        final String os;
        final String arch;

        Platform(String os, String arch) {
            this.os = os;
            this.arch = arch;
        }

        public String toString() {
            return SliceUtils.platformToString(this.os, this.arch);
        }

        public boolean equals(Object o) {
            if (!(o instanceof Platform)) {
                return false;
            }
            Platform that = (Platform)o;
            return Util.equals(this.os, that.os) && Util.equals(this.arch, that.arch);
        }

        public int hashCode() {
            return Util.hashCode((Object)this.os) ^ Util.hashCode((Object)this.arch);
        }

        boolean matches(String o, String a) {
            return (this.os == null || this.os.equals(o)) && (this.arch == null || this.arch.equals(a) || this.arch.equals("sparc64") && a.equals("sparcv9") || this.arch.equals("sparcv9") && a.equals("sparc64"));
        }

        public String getDisplayName() {
            return SliceUtils.platformToDisplayName(this.os, this.arch);
        }
    }
}

