/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.repository.EnclosingContextChecker;
import com.ibm.cic.common.core.repository.EnclosingVolumeRepositoryContextChecker;
import com.ibm.cic.common.core.repository.IRepositoryContext;
import com.ibm.cic.common.core.repository.IRepositoryContextChecker;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.InstallKitContextChecker;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.NamedArgumentParserUtil;
import com.ibm.cic.common.core.utils.ParserUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserOptions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RepositoryContext
implements IRepositoryContextChecker {
    public static final String REPOSITORY_PROPERTY_REQUIRE_CONTEXT = "RequireContext";
    public static final String CONTEXT_ANY_ID = "<any>";
    public static final String REPO_INFO_REPOSITORY_CONTEXT_PREFIX = "RepositoryContext.";
    public static final String REPO_INFO_CHECKED_REQUIRED_CONTEXT_PREFIX = "CheckedRequiredContext.";
    public static final String REPO_INFO_FORCE_SUCCEED_REQUIRED_CONTEXT_PREFIX = "RepositoryContextForcedToSucceed.";
    private final List checkers = new ArrayList();
    private static final RepositoryContext INSTANCE = new RepositoryContext();

    public RepositoryContext() {
        this.checkers.add(new InstallKitContextChecker());
        this.checkers.add(new EnclosingContextChecker());
        this.checkers.add(new EnclosingVolumeRepositoryContextChecker());
    }

    public String[] getContextIds() {
        ArrayList<String> ids = new ArrayList<String>(this.checkers.size());
        for (IRepositoryContext repoContext : this.checkers) {
            ids.add(repoContext.getRepositoryContextId());
        }
        return ids.toArray(new String[ids.size()]);
    }

    public static final RepositoryContext getInstance() {
        return INSTANCE;
    }

    public IRepositoryContext findContext(String id) {
        for (IRepositoryContext repoContext : this.checkers) {
            if (!repoContext.getRepositoryContextId().equals(id)) continue;
            return repoContext;
        }
        return null;
    }

    @Override
    public IStatus checkRequiredContext(IRepositoryInfo repoInfo, Map repoProperties) {
        block4: {
            if (UserOptions.CIC_REPO_DISABLE_REQUIRECONTEXT.isSet()) {
                return Status.OK_STATUS;
            }
            try {
                for (IRepositoryContext repoContext : this.checkers) {
                    IStatus status = repoContext.checkRequiredContext(repoInfo, repoProperties);
                    if (this.isForcedToSucceed(repoInfo, repoContext.getRepositoryContextId()) || !status.matches(4)) continue;
                    return status;
                }
            }
            catch (IllegalArgumentException e) {
                ICicStatus status = Statuses.ERROR.get(6020, e, Messages.RepositoryContext_checkRequiredContextFailsBadSyntax, repoInfo.getLocationStr());
                RepositoryContext.setCheckedContext(repoInfo, CONTEXT_ANY_ID, null, status);
                if (this.isForcedToSucceed(repoInfo, CONTEXT_ANY_ID)) break block4;
                return status;
            }
        }
        return Status.OK_STATUS;
    }

    public static void setForceSucceed(IRepositoryInfo repoInfo, String id) {
        repoInfo.setProperty(REPO_INFO_FORCE_SUCCEED_REQUIRED_CONTEXT_PREFIX + id, Boolean.TRUE.toString());
    }

    public void setSerializeRepositoryInfoCustomMap(Map customMap) {
        String[] contextIds;
        String[] stringArray = contextIds = RepositoryContext.getInstance().getContextIds();
        int n = contextIds.length;
        int n2 = 0;
        while (n2 < n) {
            String contextId = stringArray[n2];
            customMap.put(REPO_INFO_FORCE_SUCCEED_REQUIRED_CONTEXT_PREFIX + contextId, null);
            customMap.put(REPO_INFO_CHECKED_REQUIRED_CONTEXT_PREFIX + contextId, null);
            ++n2;
        }
        customMap.put("RepositoryContextForcedToSucceed.<any>", null);
        customMap.put("CheckedRequiredContext.<any>", null);
    }

    protected boolean isForcedToSucceed(IRepositoryInfo repoInfo, String contextId) {
        String propName = REPO_INFO_FORCE_SUCCEED_REQUIRED_CONTEXT_PREFIX + contextId;
        if (this.isTrue(repoInfo, propName)) {
            return true;
        }
        propName = "RepositoryContextForcedToSucceed.<any>";
        return this.isTrue(repoInfo, propName);
    }

    private boolean isTrue(IRepositoryInfo repoInfo, String propName) {
        String s = (String)repoInfo.getProperty(propName);
        boolean bool = s != null && Boolean.valueOf(s) != false;
        return bool;
    }

    public static void setRequiredContext(IRepositoryInfo repoInfo, String id) {
        repoInfo.setProperty(REPO_INFO_REPOSITORY_CONTEXT_PREFIX + id, Boolean.TRUE);
    }

    public static RequiredContextInfo getCheckedRequiredContext(IRepositoryInfo repoInfo, String id) {
        Object[] arr = (Object[])repoInfo.getProperty(REPO_INFO_CHECKED_REQUIRED_CONTEXT_PREFIX + id);
        if (arr == null) {
            return null;
        }
        return (RequiredContextInfo)arr[0];
    }

    public static IStatus getCheckedContextStatus(IRepositoryInfo repoInfo, String id) {
        Object[] arr = (Object[])repoInfo.getProperty(REPO_INFO_CHECKED_REQUIRED_CONTEXT_PREFIX + id);
        if (arr == null) {
            return null;
        }
        return (IStatus)arr[1];
    }

    protected static void setCheckedContext(IRepositoryInfo repoInfo, String id, RequiredContextInfo requiredContextInfo, IStatus status) {
        repoInfo.setProperty(REPO_INFO_CHECKED_REQUIRED_CONTEXT_PREFIX + id, new Object[]{requiredContextInfo, status});
    }

    protected static abstract class AbstractRepositoryContext
    implements IRepositoryContext {
        protected RequiredContextInfo requiredContextInfo;
        protected String contextId;

        protected AbstractRepositoryContext(String contextId) {
            this.contextId = contextId;
        }

        @Override
        public String getRepositoryContextId() {
            return this.contextId;
        }

        protected IStatus result(IRepositoryInfo repoInfo, IStatus status) {
            RepositoryContext.setCheckedContext(repoInfo, this.contextId, this.requiredContextInfo, status);
            return status;
        }

        protected boolean hasThisRequireContext(Map repoProperties) throws IllegalArgumentException {
            String requireContextValue = (String)repoProperties.get(RepositoryContext.REPOSITORY_PROPERTY_REQUIRE_CONTEXT);
            if (requireContextValue == null) {
                return false;
            }
            String s = requireContextValue.trim();
            int i = s.indexOf(58);
            String id = null;
            if (i == -1) {
                id = s;
                s = "";
            } else {
                id = requireContextValue.substring(0, i).trim();
                s = requireContextValue.substring(i + 1);
            }
            IStatus status = ParserUtil.validateId(id);
            if (status.matches(4)) {
                String msg = NLS.bind(Messages.RepositoryContext_requireContextInvalidId, RepositoryContext.REPOSITORY_PROPERTY_REQUIRE_CONTEXT, id, status.getMessage());
                throw new IllegalArgumentException(msg);
            }
            if (!id.equals(this.contextId)) {
                return false;
            }
            s = this.skipWhiteSpace(s, 0);
            this.requiredContextInfo = new RequiredContextInfo(this.contextId, s);
            return true;
        }

        protected boolean hasThisContext(IRepositoryInfo repoInfo) {
            String propName = RepositoryContext.REPO_INFO_REPOSITORY_CONTEXT_PREFIX + this.contextId;
            Object obj = repoInfo.getProperty(propName);
            boolean hasThisContext = false;
            if (obj instanceof Boolean) {
                Boolean b = (Boolean)obj;
                hasThisContext = b;
            }
            return hasThisContext;
        }

        private String skipWhiteSpace(String s, int start) {
            int i = start;
            while (i < s.length()) {
                char ch = s.charAt(i);
                if (ch != ' ' && ch != '\t' && ch != '\n') {
                    return s.substring(i);
                }
                ++i;
            }
            return "";
        }

        protected void parseNamedArguments() throws IllegalArgumentException {
            RepositoryContextNamedArgumentParser parser = new RepositoryContextNamedArgumentParser();
            try {
                parser.parse(this.requiredContextInfo.getContextValue());
            }
            catch (NamedArgumentParserUtil.ParseException e) {
                throw new IllegalArgumentException(e.getMessage());
            }
            this.requiredContextInfo.setNamedArguments(parser.getResult());
        }

        protected Map getNamedArguments() {
            return this.requiredContextInfo.getNamedArguments();
        }

        protected String getArgument(Map args, String argument, String expectedFormat) {
            String value = (String)args.get(argument);
            if (value == null || value.length() == 0) {
                throw new IllegalArgumentException(Messages.bind((String)Messages.RepositoryContext_requireContextMissingArgument, (Object[])new Object[]{RepositoryContext.REPOSITORY_PROPERTY_REQUIRE_CONTEXT, argument, expectedFormat}));
            }
            return value;
        }

        protected String getOptionalArgument(Map args, String argument) {
            String value = (String)args.get(argument);
            if (value == null || value.length() == 0) {
                return null;
            }
            return value;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.contextId);
            sb.append(':');
            sb.append(this.requiredContextInfo);
            return sb.toString();
        }
    }

    private static class RepositoryContextNamedArgumentParser
    extends NamedArgumentParserUtil.NamedArgumentParser {
        private LinkedHashMap parsed;

        @Override
        public void parse(String arg0) throws NamedArgumentParserUtil.ParseException {
            super.parse(arg0);
        }

        public Map getResult() {
            return Collections.unmodifiableMap(this.parsed);
        }

        @Override
        protected void onParsedArgsCount(int n) {
            this.parsed = new LinkedHashMap(n);
        }

        @Override
        protected void onParsedNameValue(String name, String value) throws NamedArgumentParserUtil.ParseException {
            if (this.parsed.containsKey(name)) {
                throw new NamedArgumentParserUtil.ParseException(NLS.bind(com.ibm.cic.common.core.model.internal.Messages.AdapterDataParseUtil_argumentUsedMoreThanOnce, (Object)name));
            }
            this.parsed.put(name.toLowerCase(Locale.ENGLISH), value);
        }

        @Override
        protected void onParsedNameOnly(String name) {
            this.parsed.put(name.toLowerCase(Locale.ENGLISH), "");
        }

        @Override
        protected void onEmptyArg() {
        }
    }

    public static class RequiredContextInfo {
        private final String contextId;
        private final String contextValue;
        private Map namedArguments;

        public RequiredContextInfo(String contextId, String contextValue) {
            assert (contextId != null && contextValue != null);
            this.contextId = contextId;
            this.contextValue = contextValue;
            this.namedArguments = Collections.EMPTY_MAP;
        }

        public String getContextId() {
            return this.contextId;
        }

        public String getContextValue() {
            return this.contextValue;
        }

        public Map getNamedArguments() {
            return this.namedArguments;
        }

        public void setNamedArguments(Map namedArguments) {
            this.namedArguments = namedArguments != null ? namedArguments : Collections.EMPTY_MAP;
        }

        public String toString() {
            return this.contextValue;
        }
    }
}

