/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.repository;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractWriteArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTableOfContents;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactToPathUtil;
import com.ibm.cic.common.core.artifactrepo.impl.ContentInfoComputation;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.internal.artifactrepo.URLRemoteArtifactLocator;
import com.ibm.cic.common.core.internal.repository.DigestTableOfContents;
import com.ibm.cic.common.core.internal.repository.TableOfContents;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.SimpleContentInfo;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.net.URL;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;
import org.eclipse.osgi.util.NLS;

public abstract class RemoteArtifactRepository
extends AbstractReadArtifactRepo {
    public static IStatus createErrorCantDetermineLocation(IArtifact artifact) {
        String msg = NLS.bind((String)Messages.couldnt_determine_target_location, (Object)artifact.toUserString());
        return Statuses.ERROR.get(9, msg, new Object[0]);
    }

    protected static IPath getUpdateSiteCompatiblePath(IArtifact artifact) throws CoreException {
        IPath relPath = ArtifactToPathUtil.getUpdateSiteCompatiblePath(artifact);
        if (relPath == null) {
            throw new CoreException(RemoteArtifactRepository.createErrorCantDetermineLocation(artifact));
        }
        return relPath;
    }

    protected static URL makeURL(ICicLocation baseLocation, IPath relPath) {
        ICicLocation location = baseLocation.append(relPath.toString());
        URL url = location.toURL();
        return url;
    }

    @Override
    public IStatus initializeArtifactRepository(IRepositoryInfo repInfo) {
        return super.initializeArtifactRepository(repInfo);
    }

    protected URL getRepositoryURL(IArtifactSession session, IArtifact artifact, IProgressMonitor monitor) throws CoreException {
        ICicLocation repositoryLocation = this.getRepository().getLocation();
        IPath relPath = RemoteArtifactRepository.getUpdateSiteCompatiblePath(artifact);
        URL url = RemoteArtifactRepository.makeURL(repositoryLocation, relPath);
        return url;
    }

    @Override
    protected IStatus doGetArtifactLocator(IArtifactSession session, IArtifact artifact, IContentInfo tocContentInfo, IProgressMonitor monitor, IArtifactLocator[] result) {
        URL artifactURL;
        monitor.beginTask("", 1);
        try {
            artifactURL = this.getRepositoryURL(session, artifact, (IProgressMonitor)new SubProgressMonitor(monitor, 1));
            if (artifactURL == null) {
                IStatus iStatus = RemoteArtifactRepository.createGetArtifactLocatorError(artifact, null, null);
                return iStatus;
            }
        }
        catch (CoreException e) {
            IStatus iStatus = RemoteArtifactRepository.createGetArtifactLocatorError(artifact, e.getStatus(), null);
            return iStatus;
        }
        {
            SimpleContentInfo contentInfo = tocContentInfo != null ? new SimpleContentInfo(tocContentInfo) : new SimpleContentInfo();
            IArtifact artifactForLocator = AbstractWriteArtifactRepo.getArtifactForToc(artifact, contentInfo);
            result[0] = new URLRemoteArtifactLocator(this.getRepository(), artifactURL, artifactForLocator, artifact.getContentInfo());
            IStatus iStatus = Status.OK_STATUS;
            return iStatus;
        }
        finally {
            monitor.done();
        }
    }

    public static IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IRepositoryInfo repoInfo, IProgressMonitor monitor) throws CoreException {
        ArtifactTableOfContents.TocHolder tocHolder;
        String repoLocation = repoInfo.getLocationStr();
        URL repoUrl = repoInfo.getLocation().toURL();
        try {
            IContentInfo contentInfo = ContentInfo.EMPTY_CONTENT_INFO;
            ArtifactTableOfContents.Parameters atocParams = RemoteArtifactRepository.getAtocParameters(repoInfo);
            if (atocParams.supportDigests()) {
                SplitProgressMonitor spm = new SplitProgressMonitor(monitor, 2);
                URL digestURL = repoInfo.getLocation().append("").toURL();
                try {
                    String atocRelativeName;
                    TableOfContents.TocEntry tocEntry;
                    TableOfContents.Toc toc = DigestTableOfContents.getDigestToc(digestURL, spm.next());
                    if (toc != null && (tocEntry = toc.getEntry(atocRelativeName = atocParams.getAtocFilePathAsString())) != null) {
                        contentInfo = tocEntry.getContentInfo();
                    }
                }
                catch (FileNotFoundException e) {
                    DigestTableOfContents.log.debug(e);
                }
            }
            tocHolder = ArtifactTableOfContents.getToc((IDownloadSession)session, atocParams, repoUrl, contentInfo, monitor);
        }
        catch (FileNotFoundException e) {
            return null;
        }
        catch (IOException io) {
            ICicStatus status = Statuses.ERROR.get(120, io, Messages.read_artifact_toc_failed, repoLocation);
            throw new CoreException((IStatus)status);
        }
        catch (CoreException ce) {
            if (ce.getStatus().matches(8)) {
                throw ce;
            }
            ICicStatus status = Statuses.ERROR.get(120, ce, Messages.read_artifact_toc_failed, repoLocation);
            throw new CoreException((IStatus)status);
        }
        catch (Exception e) {
            ICicStatus status = Statuses.ERROR.get(120, e, Messages.read_artifact_toc_failed, repoLocation);
            throw new CoreException((IStatus)status);
        }
        return tocHolder;
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return RemoteArtifactRepository.readArtifactToc(session, this.getRepository().getRepositoryInfo(), monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) {
        throw new AssertionError((Object)"NYI");
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return new IReadArtifactRepo.IArtifactTocCapabilities(){

            @Override
            public boolean isTocSupported() {
                return true;
            }

            @Override
            public String getPreferredDigestAlgorithm() {
                return this.getDigestAlgorithms()[0];
            }

            @Override
            public String[] getDigestAlgorithms() {
                return ContentInfoComputation.getPreferredAlgorithms();
            }
        };
    }
}

