/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.preferences;

import com.ibm.cic.common.core.internal.preferences.ProxyPreferenceInternalUtil;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.preferences.PreferenceUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;

public class ProxyPreferenceUtil {
    public static final ProxyPreferenceUtil INSTANCE = new ProxyPreferenceUtil();
    public static final String PROXY_TYPE_NONE = "NO_PROXY";
    public static final String SOCKS = "SOCKS";
    public static final String HTTP11 = "HTTP11";
    private static final String TRUE_STRING = "true";
    private static final String FALSE_STRING = "false";
    private final HashMap protocolsFor = new HashMap(ProxyPreferenceInternalUtil.getValidTargetProtocols().size());

    private ProxyPreferenceUtil() {
    }

    public Set getTargetProtocols() {
        return ProxyPreferenceInternalUtil.getValidTargetProtocols();
    }

    public IStatus checkValidPreferenceValue(String key, String value) {
        ProxyPreferenceInternalUtil pi = ProxyPreferenceInternalUtil.INSTANCE;
        for (ProxyPreferenceInternalUtil.ProxyTagsKey ptKey : pi.getValidProxyKeys()) {
            ProxyPreferenceInternalUtil.ProxyTags pt = pi.getProxyTags(ptKey);
            if (PreferenceUtil.isKey(key, pt.getHostTag())) {
                return Status.OK_STATUS;
            }
            if (PreferenceUtil.isKey(key, pt.getPortTag())) {
                return Status.OK_STATUS;
            }
            ProxyPreferenceInternalUtil.ProxySelectTags pst = pi.getProxySelectTags(ptKey.getTargetProtocol());
            if (PreferenceUtil.isKey(key, pst.getEnabledTag())) {
                return Status.OK_STATUS;
            }
            if (!PreferenceUtil.isKey(key, pst.getUseSocksTag())) continue;
            return Status.OK_STATUS;
        }
        return PreferenceUtil.getUnknownPreferenceError(key);
    }

    public List getProxyProtocols(String targetProtocol) {
        ProxyPreferenceInternalUtil.checkTargetProtocol(targetProtocol);
        Object o = this.protocolsFor.get(targetProtocol);
        if (o == null) {
            ProxyPreferenceInternalUtil pi = ProxyPreferenceInternalUtil.INSTANCE;
            LinkedHashSet<String> set = new LinkedHashSet<String>();
            for (ProxyPreferenceInternalUtil.ProxyTagsKey key : pi.getValidProxyKeys()) {
                if (!key.targetProtocol.equals(targetProtocol)) continue;
                set.add(key.proxyProtocol);
            }
            this.protocolsFor.put(targetProtocol, Collections.unmodifiableList(new ArrayList(set)));
            o = this.protocolsFor.get(targetProtocol);
        }
        return (List)o;
    }

    public List getActiveProxies(IEclipsePreferences prefs) {
        ArrayList<ProxyForProtocol> proxies = new ArrayList<ProxyForProtocol>(ProxyPreferenceInternalUtil.getValidTargetProtocols().size());
        for (String targetProtocol : ProxyPreferenceInternalUtil.getValidTargetProtocols()) {
            ProxyForProtocol proxySet = this.getActiveProxy(prefs, targetProtocol);
            if (proxySet == null) continue;
            proxies.add(proxySet);
        }
        return Collections.unmodifiableList(proxies);
    }

    public List getActiveProxies() {
        return this.getActiveProxies(this.getEclipseProxyPrefs());
    }

    private ProxyForProtocol getActiveProxy(IEclipsePreferences prefs, String targetProtocol, boolean commonOnly) {
        ProxyPreferenceInternalUtil pi = ProxyPreferenceInternalUtil.INSTANCE;
        ProxyPreferenceInternalUtil.ProxySelectTags stags = pi.getProxySelectTags(targetProtocol);
        String strEnabled = prefs.get(stags.getEnabledTag().key(), null);
        if (strEnabled == null) {
            if (targetProtocol.equals("https")) {
                ProxyForProtocol pfp = this.getActiveProxy(prefs, "http", true);
                if (pfp != null) {
                    pfp.setTargetProtocol(targetProtocol);
                }
                return pfp;
            }
            return null;
        }
        if (!pi.isProxyEnabled(stags, prefs)) {
            return ProxyForProtocol.getNoneProxy(targetProtocol);
        }
        String usedProtocol = "ftp".equals(targetProtocol) ? SOCKS : (pi.useSocksProxy(stags, prefs) ? SOCKS : HTTP11);
        return this.getPrefProxy(prefs, usedProtocol, targetProtocol, commonOnly);
    }

    public ProxyForProtocol getActiveProxy(IEclipsePreferences prefs, String targetProtocol) {
        boolean commonOnly = false;
        return this.getActiveProxy(prefs, targetProtocol, commonOnly);
    }

    public ProxyForProtocol getPrefProxy(IEclipsePreferences prefs, String proxyProtocol, String targetProtocol, boolean commonOnly) {
        ProxyForProtocol proxy;
        ProxyPreferenceInternalUtil pi = ProxyPreferenceInternalUtil.INSTANCE;
        ProxyPreferenceInternalUtil.ProxyTagsKey commonKey = null;
        ProxyPreferenceInternalUtil.ProxyTagsKey specificKey = null;
        for (ProxyPreferenceInternalUtil.ProxyTagsKey key : pi.getValidProxyKeys()) {
            if (!key.targetProtocol.equals(targetProtocol) || !key.proxyProtocol.equals(proxyProtocol)) continue;
            if (key.useCommon) {
                commonKey = key;
                continue;
            }
            specificKey = key;
        }
        if (!commonOnly && specificKey != null && (proxy = this.getPrefProxyOrNull(prefs, specificKey)) != null) {
            return proxy;
        }
        if (commonKey != null && (proxy = this.getPrefProxyOrNull(prefs, commonKey)) != null) {
            return proxy;
        }
        return new ProxyForProtocol(proxyProtocol, targetProtocol, null, new ProxyServer("", ""));
    }

    public ProxyForProtocol getPrefProxy(IEclipsePreferences prefs, String proxyProtocol, String targetProtocol) {
        boolean commonOnly = false;
        return this.getPrefProxy(prefs, proxyProtocol, targetProtocol, commonOnly);
    }

    public ProxyForProtocol getPrefProxy(String proxyProtocol, String targetProtocol) {
        return this.getPrefProxy(this.getEclipseProxyPrefs(), proxyProtocol, targetProtocol);
    }

    public ProxyForProtocol getActiveProxy(String targetProtocol) {
        return this.getActiveProxy(this.getEclipseProxyPrefs(), targetProtocol);
    }

    private IEclipsePreferences getEclipseProxyPrefs() {
        return ProxyPreferenceInternalUtil.getEclipseProxyPrefs();
    }

    private ProxyForProtocol getPrefProxyOrNull(IEclipsePreferences prefs, ProxyPreferenceInternalUtil.ProxyTagsKey key) {
        ProxyPreferenceInternalUtil pi = ProxyPreferenceInternalUtil.INSTANCE;
        ProxyPreferenceInternalUtil.ProxyTags proxyTags = pi.getProxyTags(key);
        String host = prefs.get(proxyTags.getHostTag().key(), null);
        if (host != null) {
            String port = pi.getProxyPort(proxyTags, prefs);
            return new ProxyForProtocol(key.proxyProtocol, key.targetProtocol, proxyTags, new ProxyServer(host, port));
        }
        return null;
    }

    public ProxyForProtocol createProxy(String proxyProtocol, String targetProtocol, ProxyServer proxyServer) {
        assert (proxyServer != null);
        return new ProxyForProtocol(proxyProtocol, targetProtocol, null, proxyServer);
    }

    public void setProxies(Collection proxies, IEclipsePreferences prefs, ISetPreferences putPrefs) {
        boolean useSocks;
        ProxyPreferenceInternalUtil pi = ProxyPreferenceInternalUtil.INSTANCE;
        int n = ProxyPreferenceInternalUtil.getValidTargetProtocols().size();
        HashSet<Object> uniqueHttpProxies = new HashSet<Object>(n);
        boolean hasHttpServer = false;
        for (ProxyForProtocol proxy : proxies) {
            if (proxy.getTargetProtocol().equals("http")) {
                hasHttpServer = true;
                if (proxy.isNone()) {
                    uniqueHttpProxies.add(PROXY_TYPE_NONE);
                } else {
                    uniqueHttpProxies.add(proxy.getProxyServer());
                }
            }
            if (!proxy.getTargetProtocol().equals("https")) continue;
            if (proxy.isNone()) {
                uniqueHttpProxies.add(PROXY_TYPE_NONE);
                continue;
            }
            uniqueHttpProxies.add(proxy.getProxyServer());
        }
        boolean usingUniqueHTTP11Proxy = uniqueHttpProxies.size() == 1 && hasHttpServer;
        ArrayList<ProxyForProtocol> enabledProxies = new ArrayList<ProxyForProtocol>(n);
        HashSet<ProxyServer> socksServer = new HashSet<ProxyServer>(n);
        HashSet<ProxyServer> httpServer = new HashSet<ProxyServer>(n);
        HashSet processed = new HashSet(30);
        for (ProxyForProtocol proxy : proxies) {
            boolean isCommonHttpsServer;
            ProxyPreferenceInternalUtil.ProxySelectTags stags = pi.getProxySelectTags(proxy.getTargetProtocol());
            boolean bl = isCommonHttpsServer = proxy.getTargetProtocol().equals("https") && usingUniqueHTTP11Proxy;
            if (isCommonHttpsServer) continue;
            if (proxy.isNone()) {
                ProxyPreferenceUtil.setOnlyOnce(processed, putPrefs, stags.getEnabledTag(), FALSE_STRING);
                continue;
            }
            enabledProxies.add(proxy);
            ProxyPreferenceUtil.setOnlyOnce(processed, putPrefs, stags.getEnabledTag(), TRUE_STRING);
            useSocks = proxy.getProxyProtocol().equals(SOCKS);
            if (useSocks) {
                socksServer.add(proxy.getProxyServer());
            } else {
                httpServer.add(proxy.getProxyServer());
            }
            if (proxy.getTargetProtocol().equals("ftp")) continue;
            ProxyPreferenceUtil.setOnlyOnce(processed, putPrefs, stags.getUseSocksTag(), useSocks ? TRUE_STRING : FALSE_STRING);
        }
        boolean commonSockServerSet = false;
        boolean commonHttpServerSet = false;
        for (ProxyForProtocol proxy : enabledProxies) {
            useSocks = proxy.getProxyProtocol().equals(SOCKS);
            if (useSocks) {
                commonSockServerSet = this.setProxyServer(processed, putPrefs, proxy, socksServer, commonSockServerSet);
                continue;
            }
            commonHttpServerSet = this.setProxyServer(processed, putPrefs, proxy, httpServer, commonHttpServerSet);
        }
    }

    private static void setOnlyOnce(Set processed, ISetPreferences putPrefs, ICicPreferenceConstants.PreferenceTag tag, String value) {
        if (!processed.contains(tag.key())) {
            processed.add(tag.key());
            putPrefs.setValueOrNull(tag, value);
        }
    }

    public void setProxies(Collection proxies, ISetPreferences putPrefs) {
        this.setProxies(proxies, this.getEclipseProxyPrefs(), putPrefs);
    }

    private boolean setProxyServer(Set processed, ISetPreferences putPrefs, ProxyForProtocol proxy, HashSet serverSameProxyProtocol, boolean commonPrefSet) {
        ProxyPreferenceInternalUtil pi = ProxyPreferenceInternalUtil.INSTANCE;
        if (serverSameProxyProtocol.size() == 1) {
            if (!commonPrefSet) {
                ProxyPreferenceInternalUtil.ProxyTags ctags = pi.getProxyTags(new ProxyPreferenceInternalUtil.ProxyTagsKey(proxy.getProxyProtocol(), proxy.getTargetProtocol(), true));
                this.setProxyServer(processed, ctags, proxy.getProxyServer(), putPrefs);
                commonPrefSet = true;
            }
            ProxyPreferenceInternalUtil.ProxyTags tags = pi.getProxyTags(new ProxyPreferenceInternalUtil.ProxyTagsKey(proxy.getProxyProtocol(), proxy.getTargetProtocol(), false));
            ProxyPreferenceUtil.setOnlyOnce(processed, putPrefs, tags.getHostTag(), null);
            ProxyPreferenceUtil.setOnlyOnce(processed, putPrefs, tags.getPortTag(), null);
        } else {
            if (!commonPrefSet) {
                ProxyPreferenceInternalUtil.ProxyTags ctags = pi.getProxyTags(new ProxyPreferenceInternalUtil.ProxyTagsKey(proxy.getProxyProtocol(), proxy.getTargetProtocol(), true));
                ProxyPreferenceUtil.setOnlyOnce(processed, putPrefs, ctags.getHostTag(), null);
                ProxyPreferenceUtil.setOnlyOnce(processed, putPrefs, ctags.getPortTag(), null);
                commonPrefSet = true;
            }
            ProxyPreferenceInternalUtil.ProxyTags tags = pi.getProxyTags(new ProxyPreferenceInternalUtil.ProxyTagsKey(proxy.getProxyProtocol(), proxy.getTargetProtocol(), false));
            this.setProxyServer(processed, tags, proxy.getProxyServer(), putPrefs);
        }
        return commonPrefSet;
    }

    private void setProxyServer(Set processed, ProxyPreferenceInternalUtil.ProxyTags proxyTags, ProxyServer proxyServer, ISetPreferences putPrefs) {
        ProxyPreferenceUtil.setOnlyOnce(processed, putPrefs, proxyTags.getHostTag(), proxyServer.getHost());
        ProxyPreferenceUtil.setOnlyOnce(processed, putPrefs, proxyTags.getPortTag(), proxyServer.getPort());
    }

    public static interface ISetPreferences {
        public void setValueOrNull(ICicPreferenceConstants.PreferenceTag var1, String var2);
    }

    public static class ProxyForProtocol {
        private final String proxyProtocol;
        private String targetProtocol;
        private final Object tags;
        private final ProxyServer proxyServer;

        ProxyForProtocol(String proxyProtocol, String targetProtocol, ProxyPreferenceInternalUtil.ProxyTags tags, ProxyServer proxyServer) {
            this.proxyProtocol = proxyProtocol;
            this.targetProtocol = targetProtocol;
            this.tags = tags;
            this.proxyServer = proxyServer;
        }

        public static ProxyForProtocol getNoneProxy(String targetProtocol) {
            return new ProxyForProtocol(ProxyPreferenceUtil.PROXY_TYPE_NONE, targetProtocol, null, null);
        }

        public boolean isNone() {
            return this.proxyProtocol.equals(ProxyPreferenceUtil.PROXY_TYPE_NONE);
        }

        public String getProxyProtocol() {
            return this.proxyProtocol;
        }

        public String getTargetProtocol() {
            return this.targetProtocol;
        }

        void setTargetProtocol(String targetProtocol) {
            this.targetProtocol = targetProtocol;
        }

        public Object getTags() {
            return this.tags;
        }

        public ProxyServer getProxyServer() {
            return this.proxyServer;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append(this.proxyProtocol).append(".for.").append(this.targetProtocol);
            sb.append(':').append(this.proxyServer);
            sb.append(" tags=").append(this.tags);
            return sb.toString();
        }
    }

    public static class ProxyServer {
        private final String host;
        private final String port;

        public ProxyServer(String host, String port) {
            this.host = host.toLowerCase(Locale.ENGLISH).trim();
            this.port = port.trim();
        }

        public int hashCode() {
            int prime = 31;
            int result = 1;
            result = 31 * result + this.host.hashCode();
            result = 31 * result + this.port.hashCode();
            return result;
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj == null) {
                return false;
            }
            if (this.getClass() != obj.getClass()) {
                return false;
            }
            ProxyServer other = (ProxyServer)obj;
            if (!this.host.equals(other.host)) {
                return false;
            }
            return this.port.equals(other.port);
        }

        public String getHost() {
            return this.host;
        }

        public String getPort() {
            return this.port;
        }

        public String toString() {
            return String.valueOf(this.host) + ':' + this.port;
        }
    }
}

