/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.preferences;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.preferences.CicAbstractPreferenceHandler;
import com.ibm.cic.common.core.preferences.CicDirPreferenceHandler;
import com.ibm.cic.common.core.preferences.CicPreferenceManager;
import com.ibm.cic.common.core.preferences.ICicPreferenceConstants;
import com.ibm.cic.common.core.preferences.ICicPreferenceHandler;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.logging.Logger;
import com.ibm.icu.text.MessageFormat;
import java.io.File;
import java.io.IOException;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IScopeContext;
import org.osgi.service.prefs.BackingStoreException;

public class CicSimplePreferenceHandler
extends CicAbstractPreferenceHandler {
    private static final String BACKUP_FILE_EXTENSION = ".cicbk";
    IScopeContext prefContext;
    String qualifier;

    public CicSimplePreferenceHandler(IScopeContext prefContext, String qualifier) {
        this.prefContext = prefContext;
        this.qualifier = qualifier;
        this.setPreferences(prefContext.getNode(qualifier));
    }

    public CicSimplePreferenceHandler(IEclipsePreferences preferences) {
        this.setPreferences(preferences);
    }

    @Override
    public boolean isValid() {
        return this.getPreferences() != null;
    }

    @Override
    public void save() {
        if (this.prefContext != null) {
            try {
                this.getPreferences().flush();
            }
            catch (BackingStoreException backingStoreException) {
                // empty catch block
            }
        }
    }

    private static String getIsNotSetKey(ICicPreferenceConstants.PreferenceTag tag) {
        return String.valueOf(tag.key()) + ".notSet";
    }

    @Override
    public void backup(ICicPreferenceHandler remoteHandler) {
        File pref2 = this.prefContext.getLocation().append(String.valueOf(this.qualifier) + ".prefs" + BACKUP_FILE_EXTENSION).toFile();
        if (pref2.exists()) {
            SaveOverwrittenPreferenceFile.deleteButSaveIfDebugFlagSet(pref2);
        }
        try {
            CicSimplePreferenceHandler phCurrent = this;
            CicDirPreferenceHandler phBackup = new CicDirPreferenceHandler(pref2.getCanonicalPath());
            boolean forceLog = false;
            for (ICicPreferenceConstants.PreferenceTag tag : ICicPreferenceConstants.ALL_PREFERENCES) {
                if (log.isDebugLoggable()) {
                    log.debug("Backing up property {0}={1} to {2}.", tag.key(), phCurrent.getString(tag.key()), pref2);
                }
                if (phCurrent.isSet(tag.key())) {
                    if (forceLog || log.isDebugLoggable()) {
                        String msg = MessageFormat.format((String)"Backing up property {0}={1} to {2}.", (Object[])new Object[]{tag.key(), phCurrent.getString(tag.key()), pref2});
                        System.out.println(msg);
                    }
                    CicPreferenceManager.copyPreferences(tag, phCurrent, phBackup);
                    continue;
                }
                String notSetKey = CicSimplePreferenceHandler.getIsNotSetKey(tag);
                if (forceLog || log.isDebugLoggable()) {
                    String msg = MessageFormat.format((String)"Backing up that property {0} is unset in {1}.", (Object[])new Object[]{tag.key(), pref2});
                    System.out.println(msg);
                }
                phBackup.setValue(notSetKey, "true");
            }
            phBackup.save();
        }
        catch (IOException e) {
            log.error(e);
        }
        super.backup(remoteHandler);
    }

    @Override
    public void restoreBackup() {
        File pref = this.prefContext.getLocation().append(String.valueOf(this.qualifier) + ".prefs").toFile();
        File pref2 = this.prefContext.getLocation().append(String.valueOf(this.qualifier) + ".prefs" + BACKUP_FILE_EXTENSION).toFile();
        if (pref2.exists()) {
            try {
                CicSimplePreferenceHandler phCurrent = this;
                CicDirPreferenceHandler phBackup = new CicDirPreferenceHandler(pref2.getCanonicalPath());
                for (ICicPreferenceConstants.PreferenceTag tag : ICicPreferenceConstants.ALL_PREFERENCES) {
                    if (phBackup.isSet(tag.key())) {
                        CicPreferenceManager.copyPreferences(tag, phBackup, phCurrent);
                        log.debug("Merging backed up property {0}={1} to current property settings at {2}", tag, phCurrent.getString(tag.key()), pref);
                        continue;
                    }
                    String notSetKey = CicSimplePreferenceHandler.getIsNotSetKey(tag);
                    if (!phBackup.isSet(notSetKey)) continue;
                    phCurrent.remove(tag);
                    log.debug("Cleared previously unset property {0} in current property settings at {1}", tag, pref);
                }
                phCurrent.save();
                pref2.delete();
            }
            catch (IOException e) {
                log.error(e);
            }
        }
    }

    @Override
    public void removeBackup() {
        File pref2 = this.prefContext.getLocation().append(String.valueOf(this.qualifier) + ".prefs" + BACKUP_FILE_EXTENSION).toFile();
        if (pref2.exists()) {
            pref2.delete();
        }
    }

    public IScopeContext getPrefContext() {
        return this.prefContext;
    }

    static class SaveOverwrittenPreferenceFile {
        private static final Logger logOverwrite = Logger.getLogger(SaveOverwrittenPreferenceFile.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());

        SaveOverwrittenPreferenceFile() {
        }

        static void deleteButSaveIfDebugFlagSet(File dest) {
            if (!dest.exists()) {
                return;
            }
            if (logOverwrite.isDebugLoggable()) {
                try {
                    File saveTo = TempUtil.backupBeforeOverwriting(dest);
                    logOverwrite.debug("Saved preferences before overwriting to {0}.", saveTo);
                }
                catch (IOException e) {
                    logOverwrite.debug("Failed to save preferences before overwriting: {0}", dest, e);
                }
            } else {
                dest.delete();
            }
        }
    }
}

