/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.preferences;

import com.ibm.cic.common.core.utils.FileUtil;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Properties;
import org.eclipse.core.runtime.Assert;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.core.runtime.preferences.IPreferenceNodeVisitor;
import org.osgi.service.prefs.BackingStoreException;
import org.osgi.service.prefs.Preferences;

public class CicFilePreferences
implements IEclipsePreferences {
    private final Properties m_properties;
    private final File m_file;
    private boolean m_dirty = false;

    public CicFilePreferences(File file) {
        Assert.isNotNull((Object)file);
        this.m_properties = new Properties();
        this.m_file = file;
    }

    public void addNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeNodeChangeListener(IEclipsePreferences.INodeChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void addPreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removePreferenceChangeListener(IEclipsePreferences.IPreferenceChangeListener listener) {
        throw new UnsupportedOperationException();
    }

    public void removeNode() {
        throw new UnsupportedOperationException();
    }

    public Preferences node(String path) {
        throw new UnsupportedOperationException();
    }

    public void accept(IPreferenceNodeVisitor visitor) {
        throw new UnsupportedOperationException();
    }

    public void put(String key, String value) {
        String oldValue = this.m_properties.getProperty(key);
        if (oldValue == null || !oldValue.equals(value)) {
            this.m_properties.put(key, value);
            this.m_dirty = true;
        }
    }

    public String get(String key, String def) {
        String value = this.m_properties.getProperty(key);
        if (value == null) {
            return def;
        }
        return value;
    }

    public void putBoolean(String key, boolean value) {
        this.m_properties.put(key, Boolean.toString(value));
        this.m_dirty = true;
    }

    public boolean getBoolean(String key, boolean def) {
        String value = this.m_properties.getProperty(key);
        if (value == null) {
            return def;
        }
        return value.equalsIgnoreCase("true");
    }

    public void remove(String key) {
        this.m_properties.remove(key);
        this.m_dirty = true;
    }

    public void clear() throws BackingStoreException {
        this.m_properties.clear();
        this.m_dirty = true;
    }

    public void putInt(String key, int value) {
        throw new UnsupportedOperationException();
    }

    public int getInt(String key, int def) {
        throw new UnsupportedOperationException();
    }

    public void putLong(String key, long value) {
        throw new UnsupportedOperationException();
    }

    public long getLong(String key, long def) {
        throw new UnsupportedOperationException();
    }

    public void putFloat(String key, float value) {
        throw new UnsupportedOperationException();
    }

    public float getFloat(String key, float def) {
        throw new UnsupportedOperationException();
    }

    public void putDouble(String key, double value) {
        throw new UnsupportedOperationException();
    }

    public double getDouble(String key, double def) {
        throw new UnsupportedOperationException();
    }

    public void putByteArray(String key, byte[] value) {
        throw new UnsupportedOperationException();
    }

    public byte[] getByteArray(String key, byte[] def) {
        throw new UnsupportedOperationException();
    }

    public String[] keys() {
        return this.m_properties.keySet().toArray(new String[this.m_properties.keySet().size()]);
    }

    public String[] childrenNames() {
        throw new UnsupportedOperationException();
    }

    public Preferences parent() {
        throw new UnsupportedOperationException();
    }

    public boolean nodeExists(String pathName) {
        throw new UnsupportedOperationException();
    }

    public String name() {
        throw new UnsupportedOperationException();
    }

    public String absolutePath() {
        throw new UnsupportedOperationException();
    }

    public void flush() throws BackingStoreException {
        if (this.m_dirty) {
            if (this.m_file == null) {
                throw new BackingStoreException("File name not specified");
            }
            FileUtil.ensureDestinationDirectory(this.m_file);
            FileOutputStream out = null;
            try {
                out = new FileOutputStream(this.m_file);
                this.save(out, null);
                out.close();
            }
            catch (FileNotFoundException e) {
                throw new BackingStoreException("File not found");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public void save(OutputStream out, String header) throws IOException {
        this.m_properties.store(out, header);
        this.m_dirty = false;
    }

    public void load() throws IOException {
        if (this.m_file == null) {
            throw new IOException("File name not specified");
        }
        try (FileInputStream in = new FileInputStream(this.m_file);){
            this.load(in);
        }
    }

    public void load(InputStream in) throws IOException {
        this.m_properties.load(in);
        this.m_dirty = false;
    }

    public void sync() {
        throw new UnsupportedOperationException();
    }
}

