/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.msdrepo;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.impl.DiskSet;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.internal.msdrepo.MasterSetupDiskArtifactRepository;
import com.ibm.cic.common.core.internal.msdrepo.MasterSetupDiskLayoutPolicy;
import com.ibm.cic.common.core.internal.msdrepo.MasterSetupDiskReader;
import com.ibm.cic.common.core.internal.repository.RepositoryList;
import com.ibm.cic.common.core.internal.repository.RepositoryPool;
import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IIdentity;
import com.ibm.cic.common.core.model.IOffering;
import com.ibm.cic.common.core.model.Walker;
import com.ibm.cic.common.core.repository.AbstractBaseRepository;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IContentRepository;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.IRepositoryPool;
import com.ibm.cic.common.core.repository.LayoutPolicy;
import com.ibm.cic.common.core.repository.PrivateRepositoryPools;
import com.ibm.cic.common.core.repository.RepositoryFileBasedSiteProperties;
import com.ibm.cic.common.core.repository.RepositoryGroup;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.core.runtime.Status;
import org.osgi.framework.Version;

public class MasterSetupDiskRepository
extends AbstractBaseRepository {
    public static final String REPOSITORY_TYPE = "MasterSetupDisk";
    public static final String REPOSITORY_VERSION = "0.0.0.1";
    public static final String PROP_FORCE_CAN_CREATE = "forceCanCreate";
    private static final String PROP_IN_CHECK_CAN_CREATE = "inCheckCanCreate";
    public static final IVolumeAccessByDisk.IDiskSet PSEUDO_MASTER_DISK_SET = new DiskSet("PseudoMasterSetupDiskSetId", null, 1);
    public static final Logger log = Logger.getLogger(MasterSetupDiskRepository.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());
    private final LayoutPolicy layoutPolicy = new MasterSetupDiskLayoutPolicy(this);
    private MasterSetupDiskReader msr;
    private TempUtil.UniqueTempDir cdsetCacheFolder;
    private IReadArtifactRepo artifactRepo;

    public MasterSetupDiskRepository() {
        super(REPOSITORY_TYPE, REPOSITORY_VERSION);
        this.setSiteProperties(new RepositoryFileBasedSiteProperties(this.layoutPolicy));
    }

    @Override
    public IStatus getStatus(boolean reEvaluate, IProgressMonitor progressMonitor) {
        Boolean forceCanCreate = (Boolean)this.getRepositoryInfo().getProperty(PROP_FORCE_CAN_CREATE);
        if (forceCanCreate != null && forceCanCreate.booleanValue()) {
            return super.getStatus(reEvaluate, progressMonitor);
        }
        if (reEvaluate) {
            RepositoryGroup.getDefault().getFileCacheManager().resetPathTree(this.getLocation());
        }
        this.setStatus(this.getSiteProperties().exists(reEvaluate, super.getStatus(false, progressMonitor), this.getDownloader(), progressMonitor));
        return super.getStatus(false, progressMonitor);
    }

    private static void log(IStatus status) {
        log.status(status);
    }

    private static void log(Exception e) {
        Status status = new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 4, e.getMessage(), (Throwable)e);
        MasterSetupDiskRepository.log((IStatus)status);
    }

    private IRepository getMetaRepoGroup(IProgressMonitor monitor) throws IOException, CoreException {
        return this.msr.getMetaRepoGroup(this, monitor);
    }

    private List r(List contents) {
        for (IContent content : contents) {
            this.r(content);
        }
        return contents;
    }

    private IContent r(IContent content) {
        if (content != null && content.getRepository().getRepositoryReference() == this.msr.getMasterRepo()) {
            Walker walker = new Walker(){

                @Override
                public void doUnit(IContent element) throws Exception {
                    element.setRepository(MasterSetupDiskRepository.this.getRepositoryReference());
                }

                @Override
                protected boolean canHaveUnresolvedIncludes() {
                    return true;
                }
            };
            try {
                walker.walkIncludes(content);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        return content;
    }

    @Override
    public List getAllFixes(boolean includeUnavailable, IProgressMonitor monitor) {
        try {
            return this.r(this.getMetaRepoGroup(monitor).getAllFixes(includeUnavailable, monitor));
        }
        catch (IOException e) {
            MasterSetupDiskRepository.log(e);
        }
        catch (CoreException e) {
            MasterSetupDiskRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllAssemblies(IProgressMonitor monitor) {
        try {
            return this.r(this.getMetaRepoGroup(monitor).getAllAssemblies(monitor));
        }
        catch (IOException e) {
            MasterSetupDiskRepository.log(e);
        }
        catch (CoreException e) {
            MasterSetupDiskRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllSus(IProgressMonitor monitor) {
        try {
            return this.r(this.getMetaRepoGroup(monitor).getAllSus(monitor));
        }
        catch (IOException e) {
            MasterSetupDiskRepository.log(e);
        }
        catch (CoreException e) {
            MasterSetupDiskRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllSuFragments(IProgressMonitor monitor) {
        try {
            return this.r(this.getMetaRepoGroup(monitor).getAllSuFragments(monitor));
        }
        catch (IOException e) {
            MasterSetupDiskRepository.log(e);
        }
        catch (CoreException e) {
            MasterSetupDiskRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllIus(IProgressMonitor monitor) {
        try {
            return this.r(this.getMetaRepoGroup(monitor).getAllIus(monitor));
        }
        catch (IOException e) {
            MasterSetupDiskRepository.log(e);
        }
        catch (CoreException e) {
            MasterSetupDiskRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllOfferings(boolean includeUnavailable, IProgressMonitor monitor) {
        try {
            return this.r(this.getMetaRepoGroup(monitor).getAllOfferings(includeUnavailable, monitor));
        }
        catch (IOException e) {
            MasterSetupDiskRepository.log(e);
        }
        catch (CoreException e) {
            MasterSetupDiskRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllUpdates(boolean includeUnavailable, IIdentity offeringId, Version offeringVersion, IProgressMonitor progressMonitor) {
        try {
            return this.r(this.getMetaRepoGroup(progressMonitor).getAllUpdates(includeUnavailable, offeringId, offeringVersion, progressMonitor));
        }
        catch (IOException e) {
            MasterSetupDiskRepository.log(e);
        }
        catch (CoreException e) {
            MasterSetupDiskRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    public IStatus setUpdateOffering(IOffering updateOffering, IOffering baseOffering) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus unsetUpdateOffering(IOffering updateOffering) {
        throw new UnsupportedOperationException();
    }

    @Override
    public List getAllShareableEntities(IProgressMonitor monitor) {
        try {
            return this.r(this.getMetaRepoGroup(monitor).getAllShareableEntities(monitor));
        }
        catch (IOException e) {
            MasterSetupDiskRepository.log(e);
        }
        catch (CoreException e) {
            MasterSetupDiskRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public List getAllContentElements(IProgressMonitor monitor) {
        try {
            return this.r(this.getMetaRepoGroup(monitor).getAllContentElements(monitor));
        }
        catch (IOException e) {
            MasterSetupDiskRepository.log(e);
        }
        catch (CoreException e) {
            MasterSetupDiskRepository.log(e.getStatus());
        }
        return Collections.EMPTY_LIST;
    }

    @Override
    public IContentRepository getContentRepository(IContent element) {
        try {
            IContentRepository cr = this.getMetaRepoGroup((IProgressMonitor)new NullProgressMonitor()).getContentRepository(element);
            if (cr == null && (cr = this.msr.getMasterRepo().getContentRepository(element)) != null) {
                cr.setRepositoryReference(element.getRepository());
            }
            return cr;
        }
        catch (IOException e) {
            MasterSetupDiskRepository.log(e);
        }
        catch (CoreException e) {
            MasterSetupDiskRepository.log(e.getStatus());
        }
        return null;
    }

    @Override
    public boolean containsMetadata() {
        return true;
    }

    @Override
    public boolean containsArtifacts() {
        return true;
    }

    @Override
    public boolean canStoreMetadata() {
        return false;
    }

    @Override
    public boolean canStoreArtifacts() {
        return false;
    }

    @Override
    public IStatus canAddExistingRepository(IProgressMonitor progressMonitor) {
        IStatus status = super.canAddExistingRepository(progressMonitor);
        if (status.isOK() && !this.isTrueRepositoryInfoProperty(PROP_IN_CHECK_CAN_CREATE)) {
            String name = "MasterSetupDiskRepository.canAddExistingRepository() at " + this.getRepositoryInfo().getLocationStr();
            IRepositoryPool privatePool = PrivateRepositoryPools.INSTANCE.createPrivateRepositoryPool(name);
            RepositoryGroup innerGroup = new RepositoryGroup(name, new RepositoryList(), privatePool);
            IRepositoryInfo repoInfo = this.getRepositoryInfo();
            repoInfo.setProperty(PROP_IN_CHECK_CAN_CREATE, Boolean.TRUE);
            try {
                try {
                    innerGroup.addExistingRepository(repoInfo, false);
                    innerGroup.removeAllRepositories();
                    PrivateRepositoryPools.INSTANCE.releasePrivatePool(privatePool);
                }
                catch (CoreException e) {
                    IStatus iStatus = e.getStatus();
                    repoInfo.setProperty(PROP_IN_CHECK_CAN_CREATE, null);
                    return iStatus;
                }
                catch (IOException e) {
                    IStatus iStatus = RepositoryStatus.createErrorStatus(Messages.MasterSetupDiskRepository_exceptionOpening, this, 6001, log, e);
                    repoInfo.setProperty(PROP_IN_CHECK_CAN_CREATE, null);
                    return iStatus;
                }
            }
            finally {
                repoInfo.setProperty(PROP_IN_CHECK_CAN_CREATE, null);
            }
        }
        return status;
    }

    @Override
    public IStatus isRepInfoMatchingRepositoryObject(IRepositoryInfo repInfo) {
        IStatus status = super.isRepInfoMatchingRepositoryObject(repInfo);
        return status;
    }

    @Override
    protected void updateRepositoryInfo(IRepositoryInfo repInfo) throws CoreException, IOException {
        super.updateRepositoryInfo(repInfo);
        Boolean forceCreate = (Boolean)repInfo.getProperty(PROP_FORCE_CAN_CREATE);
        if (forceCreate != null && forceCreate.booleanValue()) {
            return;
        }
        this.setWritable(false);
        ICicLocation location = repInfo.getLocation();
        this.cdsetCacheFolder = TempUtil.getUniqueTempDir(null, "cicmsdcache");
        this.cdsetCacheFolder.create();
        this.msr = new MasterSetupDiskReader(location, this.cdsetCacheFolder);
        this.artifactRepo = new MasterSetupDiskArtifactRepository(){

            @Override
            public MasterSetupDiskReader getMasterReader() {
                return MasterSetupDiskRepository.this.msr;
            }

            @Override
            public IRepository getRepository() {
                return MasterSetupDiskRepository.this;
            }
        };
        this.msr.initMasterRepo(this, (IProgressMonitor)new NullProgressMonitor());
        List diskSets = this.msr.getDiskSets(null);
        for (MasterSetupDiskReader.DiskSetInfo diskSetInfo : diskSets) {
            try {
                diskSetInfo.getDiskSetMetaRepository(null);
                diskSetInfo.getDiskSetArtifactRepository(null);
            }
            catch (CoreException e) {
                this.dispose();
                throw e;
            }
        }
    }

    private void disposeContained() {
        if (this.msr != null) {
            this.msr.dispose();
        }
        if (this.cdsetCacheFolder != null) {
            this.cdsetCacheFolder.cleanEmptyDirsLogIOE();
        }
    }

    @Override
    public void doDelete() {
        this.disposeContained();
    }

    @Override
    public void dispose() {
        this.disposeContained();
        RepositoryPool.getDefault().getFileCacheManager().resetPathTreeWithNoTimout(this.getLocation());
        super.dispose();
    }

    @Override
    public void refresh() {
        this.msr.refresh();
        super.refresh();
    }

    @Override
    public Object getAdapter(Class adapter) {
        if (adapter == MasterSetupDiskRepository.class) {
            return this;
        }
        Object o = this.artifactRepo.getAdapter(adapter);
        if (o != null) {
            return o;
        }
        return super.getAdapter(adapter);
    }

    @Override
    public IReadArtifactRepo.IArtifactTocCapabilities getArtifactTocCapabilities() {
        return this.artifactRepo.getArtifactTocCapabilities();
    }

    @Override
    public boolean hasArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.artifactRepo.hasArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readArtifactToc(IArtifactSession session, IProgressMonitor monitor) throws CoreException {
        return this.artifactRepo.readArtifactToc(session, monitor);
    }

    @Override
    public IReadArtifactRepo.IArtifactToc readCachedArtifactToc(IArtifactSession session, IPath tocCache, IProgressMonitor monitor) throws CoreException {
        return this.artifactRepo.readCachedArtifactToc(session, tocCache, monitor);
    }

    private boolean isTrueRepositoryInfoProperty(String property) {
        Boolean bool = (Boolean)this.getRepositoryInfo().getProperty(property);
        return bool != null && bool != false;
    }

    @Override
    public IStatus canCreateRepository() {
        if (this.isTrueRepositoryInfoProperty(PROP_FORCE_CAN_CREATE)) {
            return Status.OK_STATUS;
        }
        return RepositoryStatus.createErrorStatus(6014, Messages.ERROR_CANT_CREATE_REPOSITORY_OF_TYPE, this.getType(), this.getLocationStr());
    }

    @Override
    protected IStatus doCreateRepository() {
        return this.layoutPolicy.setDefaultSiteInformation();
    }

    @Override
    protected IStatus doImportP2Repository(File p2RepositoryFile, IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus deleteP2Repository(IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus exportP2Repository(File destinationFile, IProgressMonitor progressMonitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean containsP2Repository(IProgressMonitor monitor) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus addNLSFile(String fileName, InputStream source) {
        throw new UnsupportedOperationException();
    }

    @Override
    public IStatus deleteNLSFile(String fileName) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String[] getNLSFileList() {
        return CicConstants.EMPTY_STR_ARRAY;
    }

    @Override
    public InputStream openNLSFileStream(String fileName) {
        throw new UnsupportedOperationException();
    }
}

