/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.internal;

import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.ISelectionExpression;
import com.ibm.cic.common.core.model.ISelectionExpressionContainer;
import com.ibm.cic.common.core.model.utils.SelectionExpressionVisitor;

public class SelExprHelper {
    private SelExprHelper() {
        assert (false);
    }

    public static boolean isExpressionReferencing(ISelectionExpressionContainer owner, IContentSelector selector) {
        ISelectionExpression expr = owner.getExpression();
        if (expr == null) {
            return false;
        }
        IsReferencingVisitor visitor = new IsReferencingVisitor(selector.getIdentity().getId());
        SelectionExpressionVisitor.visit(expr, visitor);
        return visitor.getResult();
    }

    private static class IsReferencingVisitor
    implements SelectionExpressionVisitor.ISelectionExpressionVisitor {
        private final String id;
        private boolean result = false;

        public IsReferencingVisitor(String id) {
            this.id = id;
        }

        public boolean getResult() {
            return this.result;
        }

        @Override
        public void visit(ISelectionExpression.ISelectedById expr) {
            this.result |= expr.getId().equals(this.id);
        }

        @Override
        public void visit(ISelectionExpression.ISelectedByBundle expr) {
        }

        @Override
        public void visit(ISelectionExpression.ISelectedByPredefinedId expr) {
        }
    }
}

