/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.model.expander;

import com.ibm.cic.common.core.model.IContent;
import com.ibm.cic.common.core.model.IContentSelector;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.IShareableEntity;
import com.ibm.cic.common.core.model.IShareableItem;
import com.ibm.cic.common.core.model.ISuFragment;
import com.ibm.cic.common.core.model.expander.ContextState;
import com.ibm.cic.common.core.model.expander.ContextStateCache;
import com.ibm.cic.common.core.model.expander.IContextState;
import com.ibm.cic.common.core.model.expander.SelectorExpander;
import com.ibm.cic.common.core.model.utils.SelectorContext;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.cic.common.core.utils.MapList;
import com.ibm.cic.common.core.utils.Util;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ExpanderUtils {
    private ExpanderUtils() {
        assert (false);
    }

    public static Set<IContentSelector> computeDependentSelectors(LinkedProperties overriddenPredefineds, IShareableEntity se, IContentSelector selector) {
        SelectorContext context = new SelectorContext(overriddenPredefineds, false);
        context.setIgnoringBundles(false);
        ContextState contextState = new ContextState();
        contextState.setSelectorContext(context);
        contextState.select(se, selector);
        contextState.selectDependentSelectors(se);
        return contextState.getSelected(se);
    }

    public static List<IShareableEntity> getAllShareableEntities(SelectorExpander expander) {
        final ArrayList<IShareableEntity> result = new ArrayList<IShareableEntity>(256);
        ExpanderUtils.visitContexts(expander.getRootContext(), new IContextVisitor(){

            @Override
            public void visit(IContextState state) {
                result.addAll(state.getShareableEntities());
            }
        });
        return result;
    }

    public static List<IShareableEntity> getAllShareableEntities(IContextState rootContext) {
        final ArrayList<IShareableEntity> result = new ArrayList<IShareableEntity>(256);
        ExpanderUtils.visitContexts(rootContext, new IContextVisitor(){

            @Override
            public void visit(IContextState state) {
                result.addAll(state.getShareableEntities());
            }
        });
        return result;
    }

    public static List<IInstallableUnit> getAllIUs(SelectorExpander expander) {
        final ArrayList<IInstallableUnit> result = new ArrayList<IInstallableUnit>(256);
        ExpanderUtils.visitContexts(expander.getRootContext(), new IContextVisitor(){

            @Override
            public void visit(IContextState state) {
                result.addAll(state.getIUs());
            }
        });
        return result;
    }

    public static String toDebugString(IContextState rootContext) {
        if (rootContext == null) {
            return "null";
        }
        final StringBuffer sb = new StringBuffer(1024);
        ExpanderUtils.visitContexts(rootContext, new IContextVisitor(){

            @Override
            public void visit(IContextState state) {
                MapList<IContent, IInstallableUnit> iuMap = new MapList<IContent, IInstallableUnit>();
                for (IInstallableUnit iu : state.getIUs()) {
                    iuMap.add(iu.getParent(), iu);
                }
                sb.append(state.getFullId()).append(':');
                for (IShareableEntity se : state.getShareableEntities()) {
                    Set<IContentSelector> selected = state.getSelected(se);
                    if (selected.isEmpty()) continue;
                    this.appendSE(se, Util.toSelectorIdString(selected), iuMap.remove(se));
                }
                for (IContent iContent : iuMap.keySet()) {
                    IShareableItem si = (IShareableItem)iContent;
                    if (si instanceof ISuFragment) {
                        this.appendSE(si, "(fragment)", iuMap.get(si));
                        continue;
                    }
                    this.appendSE(si, "(from parent)", iuMap.get(si));
                }
                sb.append('\n');
            }

            private void appendSE(IShareableItem si, String selectedStr, List<IInstallableUnit> ius) {
                sb.append("\n  ").append(si.getIdentity()).append(' ').append(si.getVersion()).append(' ').append(selectedStr);
                for (IInstallableUnit iu : ius) {
                    sb.append("\n    ").append(iu.getIdentity());
                }
            }
        });
        return Util.trimEnd(sb).toString();
    }

    public static void visitContexts(IContextState contextState, IContextVisitor visitor) {
        visitor.visit(contextState);
        for (IContextState iContextState : contextState.getSubContexts()) {
            ExpanderUtils.visitContexts(iContextState, visitor);
        }
    }

    public static void clearContextStateCache() {
        ContextStateCache.INSTANCE.clear();
    }

    public static interface IContextVisitor {
        public void visit(IContextState var1);
    }
}

