/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.volrepo;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTableOfContents;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactTocModel;
import com.ibm.cic.common.core.artifactrepo.impl.DiskSet;
import com.ibm.cic.common.core.artifactrepo.impl.DiskUtil;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.internal.volrepo.Messages;
import com.ibm.cic.common.core.model.IOfferingOrFix;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.volrepo.VolumesArtifactTableOfContents;
import com.ibm.cic.common.downloads.ContentInfo;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.RandomAccess;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class VolumeAtocUtil {
    private final IVolumeAccessByDisk.IDiskSet diskSet;
    private final ArtifactTableOfContents.TocHolder tocHolder;
    private final Map diskNumToDisk;

    public static ArtifactTableOfContents.TocHolder readVolumeArtifactToc(IArtifactSession session, File file, IProgressMonitor monitor) throws CoreException, IOException {
        VolumesArtifactTableOfContents.SetParameters vtocParams = VolumesArtifactTableOfContents.getVtocParameters(true);
        SplitProgressMonitor spm = new SplitProgressMonitor(monitor, vtocParams.supportDigests() ? 4 : 3);
        try {
            ArtifactTableOfContents.TocHolder atocHolder;
            ArtifactTableOfContents.TocHolder tocHolder = atocHolder = VolumesArtifactTableOfContents.getToc(vtocParams, (IDownloadSession)session, new Path(file.getAbsolutePath()).removeLastSegments(1), (IContentInfo)ContentInfo.EMPTY_CONTENT_INFO, spm.next());
            return tocHolder;
        }
        finally {
            spm.done();
        }
    }

    private VolumeAtocUtil(IVolumeAccessByDisk.IDiskSet diskSetWithoutCount, ArtifactTableOfContents.TocHolder tocHolder) {
        this.tocHolder = tocHolder;
        this.diskNumToDisk = new HashMap(10);
        this.diskSet = diskSetWithoutCount;
    }

    public static VolumeAtocUtil create(IArtifactSession session, String diskSetId, String diskSetLabel, ArtifactTableOfContents.TocHolder tocHolder, IProgressMonitor monitor) throws CoreException, IOException {
        DiskSet diskSet = new DiskSet(diskSetId, diskSetLabel, -1);
        VolumeAtocUtil datoc = new VolumeAtocUtil(diskSet, tocHolder);
        datoc.initDiskSetCount(diskSet, session, monitor);
        return datoc;
    }

    private void initDiskSetCount(DiskSet argDiskSet, IArtifactSession argSession, IProgressMonitor argMonitor) throws CoreException, IOException {
        IVolumeAccessByDisk.IDiskSet[] diskSets = DiskUtil.getDiskSetsWithCount(new IVolumeAccessByDisk(){

            @Override
            public boolean canGetLocatorsFromDisk1(IProgressMonitor monitor) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean disksAvailable(IArtifactSession session, IVolumeAccessByDisk.IDiskSetDisks disks, IProgressMonitor monitor) {
                throw new UnsupportedOperationException();
            }

            @Override
            public boolean canFindAvailableDisks() {
                throw new UnsupportedOperationException();
            }

            @Override
            public IVolumeAccessByDisk.IDiskSet[] getPackageDiskSets(IArtifactSession session, IOfferingOrFix pkg, IProgressMonitor monitor) {
                throw new UnsupportedOperationException();
            }

            public void visitArtifactsOnDisk(IArtifactSession session, IVolumeAccessByDisk.IDiskSet[] aDiskSets, Collection artifacts, IVolumeAccessByDisk.IArtifactOnDiskCallback aodCallback, IProgressMonitor monitor) throws CoreException, IOException {
                VolumeAtocUtil.this.artifactsOnDisks(session, artifacts, aodCallback, null, monitor);
            }

            @Override
            public IVolumeAccessByDisk.IDiskSet[] getDiskSets(IArtifactSession session, IProgressMonitor monitor) {
                throw new UnsupportedOperationException();
            }

            @Override
            public void useArtifactLocatorsInOrder(IArtifactSession session, IVolumeAccessByDisk.IDiskOperation diskOperation, IMultiArtifactOperationArguments artifactArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
                throw new UnsupportedOperationException();
            }

            @Override
            public IRepository getRepository() {
                throw new UnsupportedOperationException();
            }
        }, argSession, argMonitor);
        IVolumeAccessByDisk.IDiskSet diskSetWithCount = diskSets[0];
        argDiskSet.setDiskCount(diskSetWithCount.getDiskCount());
    }

    public IVolumeAccessByDisk.IDiskSet getDiskSet() {
        return this.diskSet;
    }

    public OrderedDisks getUsedDisks(IArtifactSession session, Collection artifacts, Collection outArtifactsNotOnDisks, IProgressMonitor monitor) throws CoreException, IOException {
        monitor.beginTask("", artifacts.size());
        monitor.subTask(Messages.task_determine_needed_disks);
        try {
            OrderedDisks usedDisks = new OrderedDisks();
            for (IArtifact artifact : artifacts) {
                VolumesArtifactTableOfContents.DiskInfo diskInfo = VolumesArtifactTableOfContents.getDiskInfo(session, this.tocHolder, artifact, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                if (diskInfo == null) {
                    if (outArtifactsNotOnDisks == null) continue;
                    outArtifactsNotOnDisks.add(artifact);
                    continue;
                }
                int diskNum = diskInfo.getDiskNum();
                usedDisks.addDisk(this.getDisk(diskNum));
            }
            OrderedDisks orderedDisks = usedDisks;
            return orderedDisks;
        }
        finally {
            monitor.done();
        }
    }

    public void artifactsOnDisks(IArtifactSession session, Collection artifacts, IVolumeAccessByDisk.IArtifactOnDiskCallback aodCallback, Collection outArtifactsNotOnDisks, IProgressMonitor monitor) throws CoreException, IOException {
        if (artifacts == null) {
            this.allArtifactsOnDisks(session, aodCallback, monitor);
            return;
        }
        monitor.beginTask("", artifacts.size());
        monitor.subTask(Messages.task_determine_needed_disks);
        try {
            ArrayList<IArtifact> notOnDisk = new ArrayList<IArtifact>(artifacts.size());
            for (IArtifact artifact : artifacts) {
                VolumesArtifactTableOfContents.DiskInfo diskInfo = VolumesArtifactTableOfContents.getDiskInfo(session, this.tocHolder, artifact, (IProgressMonitor)new SubProgressMonitor(monitor, 0));
                monitor.worked(1);
                if (monitor.isCanceled()) {
                    throw new CoreException(Status.CANCEL_STATUS);
                }
                if (diskInfo == null) {
                    notOnDisk.add(artifact);
                    continue;
                }
                IVolumeAccessByDisk.IDisk disk = this.getDisk(diskInfo.getDiskNum());
                aodCallback.onDisk(artifact, disk);
            }
            if (outArtifactsNotOnDisks != null && notOnDisk.size() > 0) {
                outArtifactsNotOnDisks.addAll(notOnDisk);
            }
        }
        finally {
            monitor.done();
        }
    }

    private IVolumeAccessByDisk.IDisk getDisk(Integer diskNum) {
        IVolumeAccessByDisk.IDisk disk = (IVolumeAccessByDisk.IDisk)this.diskNumToDisk.get(diskNum);
        if (disk == null) {
            disk = new DiskUtil.Disk(this.diskSet, diskNum);
            this.diskNumToDisk.put(diskNum, disk);
        }
        return disk;
    }

    private void allArtifactsOnDisks(IArtifactSession session, IVolumeAccessByDisk.IArtifactOnDiskCallback aodCallback, IProgressMonitor monitor) throws CoreException {
        List<ArtifactTocModel.AbstractContainedSet> categories = this.tocHolder.getContainedCategories();
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, categories.size());
        for (IReadArtifactRepo.ICategory iCategory : categories) {
            this.allArtifactsOnDisks(session, aodCallback, iCategory, pm.next());
        }
        pm.done();
    }

    private void allArtifactsOnDisks(IArtifactSession session, IVolumeAccessByDisk.IArtifactOnDiskCallback aodCallback, IReadArtifactRepo.ICategory category, IProgressMonitor monitor) throws CoreException {
        SplitProgressMonitor pm = new SplitProgressMonitor(monitor, new int[]{1, 10});
        List contents = this.tocHolder.getContents((IDownloadSession)session, category, pm.next());
        if (monitor.isCanceled()) {
            throw new CoreException(Status.CANCEL_STATUS);
        }
        SplitProgressMonitor pm2 = new SplitProgressMonitor(pm.next(), contents.size());
        for (Object content : contents) {
            if (content instanceof IReadArtifactRepo.ICategory) {
                this.allArtifactsOnDisks(session, aodCallback, (IReadArtifactRepo.ICategory)content, pm2.next());
                continue;
            }
            if (content instanceof ArtifactTocModel.Artifact) {
                ArtifactTocModel.Artifact artifact = (ArtifactTocModel.Artifact)content;
                VolumesArtifactTableOfContents.DiskInfo diskInfo = VolumesArtifactTableOfContents.getDiskInfo(artifact);
                pm2.next().done();
                if (diskInfo == null) continue;
                IVolumeAccessByDisk.IDisk disk = this.getDisk(diskInfo.getDiskNum());
                aodCallback.onDisk(artifact, disk);
                continue;
            }
            assert (false) : "Unexpected type: " + content;
        }
        pm.done();
    }

    public VolumesArtifactTableOfContents.DiskInfo getDiskInfo(IArtifactSession session, IArtifact iartifact, IProgressMonitor monitor) throws CoreException, IOException {
        VolumesArtifactTableOfContents.DiskInfo diskInfo = VolumesArtifactTableOfContents.getDiskInfo(session, this.tocHolder, iartifact, monitor);
        return diskInfo;
    }

    public static class OrderedDisks
    implements List,
    RandomAccess {
        private final ArrayList orderedDisks = new ArrayList();

        public String toString() {
            return this.orderedDisks.toString();
        }

        public int[] getDiskNumbers() {
            int[] diskNumbers = new int[this.orderedDisks.size()];
            int i = 0;
            while (i < diskNumbers.length) {
                diskNumbers[i] = this.getDisk(i).getDiskNumber();
                ++i;
            }
            return diskNumbers;
        }

        public static String arraysToString(int[] a) {
            if (a == null) {
                return "null";
            }
            StringBuffer sb = new StringBuffer();
            sb.append('[');
            int i = 0;
            while (i < a.length) {
                int val = a[i];
                sb.append(val);
                if (i < a.length - 1) {
                    sb.append(", ");
                }
                ++i;
            }
            sb.append(']');
            return sb.toString();
        }

        public OrderedDisks getOthers(IVolumeAccessByDisk.IDiskSet diskSet) {
            this.checkNewDiskSet(diskSet);
            OrderedDisks others = new OrderedDisks();
            int i = 0;
            while (i < diskSet.getDiskCount()) {
                DiskUtil.Disk disk = new DiskUtil.Disk(diskSet, i + 1);
                if (!this.orderedDisks.contains(disk)) {
                    others.addDisk(disk);
                }
                ++i;
            }
            return others;
        }

        private IVolumeAccessByDisk.IDiskSet getDiskSet() {
            IVolumeAccessByDisk.IDiskSet diskSet = this.orderedDisks.isEmpty() ? null : ((IVolumeAccessByDisk.IDisk)this.orderedDisks.get(0)).getDiskSet();
            return diskSet;
        }

        private void checkNewDiskSet(IVolumeAccessByDisk.IDiskSet diskSet) {
            IVolumeAccessByDisk.IDiskSet currentDiskSet = this.getDiskSet();
            if (currentDiskSet != null) assert (diskSet.equals(currentDiskSet));
        }

        public void addDisk(IVolumeAccessByDisk.IDiskSet diskSet, int diskIndex) {
            this.checkNewDiskSet(diskSet);
            this.addDisk(new DiskUtil.Disk(diskSet, diskIndex + 1));
        }

        public void addDisk(IVolumeAccessByDisk.IDisk disk) {
            this.checkNewDiskSet(disk.getDiskSet());
            int diskIndex = disk.getDiskNumber() - 1;
            ListIterator<IVolumeAccessByDisk.IDisk> iter = this.orderedDisks.listIterator();
            while (iter.hasNext()) {
                IVolumeAccessByDisk.IDisk usedDisk = (IVolumeAccessByDisk.IDisk)iter.next();
                int usedDiskIndex = usedDisk.getDiskIndex();
                int cmp = diskIndex - usedDiskIndex;
                if (cmp == 0) {
                    return;
                }
                if (cmp >= 0) continue;
                iter.previous();
                iter.add(disk);
                return;
            }
            this.orderedDisks.add(disk);
        }

        public IVolumeAccessByDisk.IDisk getDisk(int orderedIndex) {
            return (IVolumeAccessByDisk.IDisk)this.get(orderedIndex);
        }

        public void removeDisk(int diskIndex) {
            ListIterator iter = this.orderedDisks.listIterator();
            while (iter.hasNext()) {
                IVolumeAccessByDisk.IDisk usedDisk = (IVolumeAccessByDisk.IDisk)iter.next();
                int usedDiskIndex = usedDisk.getDiskNumber() - 1;
                int cmp = diskIndex - usedDiskIndex;
                if (cmp != 0) continue;
                iter.remove();
                return;
            }
        }

        @Override
        public int size() {
            return this.orderedDisks.size();
        }

        @Override
        public boolean isEmpty() {
            return this.orderedDisks.isEmpty();
        }

        @Override
        public boolean contains(Object o) {
            return this.orderedDisks.contains(o);
        }

        @Override
        public Iterator iterator() {
            return this.orderedDisks.iterator();
        }

        @Override
        public Object[] toArray() {
            return this.orderedDisks.toArray();
        }

        @Override
        public Object[] toArray(Object[] a) {
            return this.orderedDisks.toArray(a);
        }

        @Override
        public boolean containsAll(Collection c) {
            return this.orderedDisks.containsAll(c);
        }

        @Override
        public boolean add(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean remove(Object o) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean addAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean removeAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean retainAll(Collection coll) {
            throw new UnsupportedOperationException();
        }

        @Override
        public void clear() {
            throw new UnsupportedOperationException();
        }

        public boolean addAll(int index, Collection c) {
            throw new UnsupportedOperationException();
        }

        public Object get(int index) {
            return this.orderedDisks.get(index);
        }

        public Object set(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public void add(int index, Object element) {
            throw new UnsupportedOperationException();
        }

        public Object remove(int index) {
            throw new UnsupportedOperationException();
        }

        @Override
        public int indexOf(Object o) {
            return this.orderedDisks.indexOf(o);
        }

        @Override
        public int lastIndexOf(Object o) {
            return this.orderedDisks.lastIndexOf(o);
        }

        public ListIterator listIterator() {
            return this.orderedDisks.listIterator();
        }

        public ListIterator listIterator(int index) {
            return this.orderedDisks.listIterator(index);
        }

        public List subList(int fromIndex, int toIndex) {
            return this.orderedDisks.subList(fromIndex, toIndex);
        }
    }
}

