/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.repository;

import com.ibm.cic.common.core.internal.utils.CicConstants;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepositoryInfo;
import com.ibm.cic.common.core.repository.RepositoryDescriptor;
import com.ibm.cic.common.core.repository.RepositoryFileBasedSiteProperties;
import com.ibm.cic.common.core.repository.RepositoryStatus;
import com.ibm.cic.common.core.repository.digest.RepositoryDigestRepositoryData;
import com.ibm.cic.common.core.utils.LinkedProperties;
import com.ibm.icu.util.StringTokenizer;
import java.util.HashSet;
import java.util.Map;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class RepositoryInfo
implements IRepositoryInfo {
    private String m_repositoryName;
    private String m_repositoryVersion;
    private String m_repositoryType;
    private IStatus m_repositoryReportedStatus;
    private ICicLocation m_repositoryLocation = null;
    private RepositoryDescriptor m_repositoryDescriptor;
    private Map m_properties = new LinkedProperties();
    private boolean m_opened = true;
    private boolean m_includeBuildData = false;
    private IStatus m_lastOperationStatus = null;
    private RepositoryDigestRepositoryData m_repositoryDigestData;
    private boolean m_readOnlyRepositoryRequested = false;

    public static RepositoryInfo deserialize(String serialized) {
        return new RepositoryInfo(serialized);
    }

    public RepositoryInfo(String a_repositoryName, String a_repositoryType, String a_repositoryVersion, ICicLocation a_location, String a_extraSettings) {
        this(a_extraSettings);
        if (a_repositoryName != null) {
            this.m_repositoryName = a_repositoryName;
        }
        if (a_repositoryType != null) {
            this.m_repositoryType = a_repositoryType;
        }
        if (a_repositoryVersion != null) {
            this.m_repositoryVersion = a_repositoryVersion;
        }
        if (this.m_repositoryLocation.length() == 0 && a_location != null) {
            this.setLocation(a_location.toString());
        }
        if (this.m_repositoryName == null || this.m_repositoryName.length() == 0) {
            this.setName(this.getLocationStr());
        }
    }

    public RepositoryInfo(String a_repInfo) {
        if (a_repInfo != null) {
            StringTokenizer st = new StringTokenizer(a_repInfo, ",");
            while (st.hasMoreTokens()) {
                String property = st.nextToken();
                int index = property.indexOf("=");
                if (index > -1) {
                    String tag = property.substring(0, index);
                    String val = property.substring(index + 1);
                    if (tag.equals("Name")) {
                        this.m_repositoryName = val;
                        continue;
                    }
                    if (tag.equals("Type")) {
                        this.m_repositoryType = val;
                        continue;
                    }
                    if (tag.equals("Version")) {
                        this.m_repositoryVersion = val;
                        continue;
                    }
                    if (tag.equals("Path")) {
                        this.setLocation(val);
                        continue;
                    }
                    if (tag.equals("Opened")) {
                        this.setOpen(Boolean.valueOf(val));
                        continue;
                    }
                    if (tag.equals("IncludeBuildData")) {
                        this.setIncludeBuildData(Boolean.valueOf(val));
                        continue;
                    }
                    this.setProperty(tag, val);
                    continue;
                }
                this.setLocation(property);
            }
        }
        if (this.m_repositoryLocation == null) {
            this.m_repositoryLocation = CicConstants.EMPTY_LOCATION;
        }
        if (this.m_repositoryName == null) {
            this.setName(this.getLocationStr());
        }
    }

    private void setLocation(String location) {
        if (!(location = location.trim()).startsWith("http")) {
            this.m_repositoryLocation = new CicFileLocation(this.stripRepositoryFile(location));
        } else {
            int index = location.indexOf("?");
            if (index == -1) {
                this.m_repositoryLocation = new CicFileLocation(this.stripRepositoryFile(location));
            } else {
                this.m_repositoryLocation = new CicFileLocation(this.stripRepositoryFile(location.substring(0, index)));
                if (index < location.length()) {
                    String qstring = location.substring(index + 1);
                    StringTokenizer tokenizer = new StringTokenizer(qstring, "&");
                    while (tokenizer.hasMoreTokens()) {
                        String token = tokenizer.nextToken();
                        String[] tokens = token.split("=");
                        if (tokens.length <= 0) continue;
                        String value = tokens.length > 1 ? tokens[1] : "";
                        this.m_properties.put(tokens[0], value);
                    }
                }
            }
        }
    }

    private String stripRepositoryFile(String location) {
        HashSet<String> namesToStrip = new HashSet<String>(RepositoryFileBasedSiteProperties.REP_MAIN_SITE_PROPERTY_FILES);
        namesToStrip.add("diskTag.inf");
        if (!location.startsWith("http")) {
            CicFileLocation cicLoc = new CicFileLocation(location);
            if (namesToStrip.contains(cicLoc.getName())) {
                return cicLoc.getPathSegments();
            }
        } else {
            for (String name : namesToStrip) {
                int index = location.indexOf("/" + name);
                if (index <= -1) continue;
                return location.substring(0, index);
            }
        }
        return location;
    }

    @Override
    public String serialize() {
        return this.serializeCustom(null);
    }

    private static Object getCustomValue(Object key, Object value, Map customMap) {
        if (customMap == null) {
            return value;
        }
        if (!customMap.containsKey(key)) {
            return value;
        }
        return customMap.get(key);
    }

    public static boolean serializeCustomValue(StringBuffer sb, Object key, Object value, Map customMap) {
        Object val = RepositoryInfo.getCustomValue(key, value, customMap);
        if (val != null) {
            sb.append(key);
            sb.append("=");
            sb.append(val);
            return true;
        }
        return false;
    }

    public String serializeCustom(Map customMap) {
        StringBuffer sbuf = new StringBuffer();
        sbuf.append("Name");
        sbuf.append("=");
        sbuf.append(this.m_repositoryName);
        sbuf.append(",");
        if (this.m_repositoryType != null) {
            sbuf.append("Type");
            sbuf.append("=");
            sbuf.append(this.m_repositoryType);
            sbuf.append(",");
        }
        if (this.m_repositoryVersion != null) {
            sbuf.append("Version");
            sbuf.append("=");
            sbuf.append(this.m_repositoryVersion);
            sbuf.append(",");
        }
        if (RepositoryInfo.serializeCustomValue(sbuf, "Path", this.getLocationStr(), customMap)) {
            sbuf.append(",");
        }
        sbuf.append("Opened");
        sbuf.append("=");
        sbuf.append(Boolean.toString(this.m_opened));
        if (this.m_includeBuildData) {
            sbuf.append("IncludeBuildData");
            sbuf.append("=");
            sbuf.append(this.m_includeBuildData);
        }
        for (Map.Entry entry : this.m_properties.entrySet()) {
            Object val;
            if (entry.getKey() == null || entry.getValue() == null || (val = RepositoryInfo.getCustomValue(entry.getKey(), entry.getValue(), customMap)) == null) continue;
            sbuf.append(",");
            RepositoryInfo.serializeCustomValue(sbuf, entry.getKey(), val, null);
        }
        return sbuf.toString();
    }

    public String toString() {
        return this.serialize();
    }

    @Override
    public ICicLocation getLocation() {
        return this.m_repositoryLocation;
    }

    @Override
    public String getLocationStr() {
        return this.m_repositoryLocation.toString();
    }

    @Override
    public void setProperty(String a_id, Object a_value) {
        this.m_properties.put(a_id, a_value);
    }

    @Override
    public Object getProperty(String a_id) {
        return this.m_properties.get(a_id);
    }

    @Override
    public Map getProperties() {
        return this.m_properties;
    }

    @Override
    public String getStringProperty(String a_id) {
        return (String)this.m_properties.get(a_id);
    }

    @Override
    public String getName() {
        return this.m_repositoryName;
    }

    @Override
    public void setName(String name) {
        if (name != null) {
            this.m_repositoryName = name;
        }
    }

    @Override
    public String getType() {
        return this.m_repositoryType;
    }

    @Override
    public void setType(String type) {
        this.m_repositoryType = type;
    }

    @Override
    public String getVersion() {
        return this.m_repositoryVersion;
    }

    @Override
    public void setVersion(String version) {
        this.m_repositoryVersion = version;
    }

    public int hashCode() {
        String hashImage = this.getLocationStr();
        hashImage = String.valueOf(hashImage) + (this.m_repositoryVersion == null ? "" : this.m_repositoryVersion);
        hashImage = String.valueOf(hashImage) + (this.m_repositoryType == null ? "" : this.m_repositoryType);
        return hashImage.hashCode();
    }

    public boolean equals(Object a_ri) {
        if (a_ri == this) {
            return true;
        }
        if (!(a_ri instanceof RepositoryInfo)) {
            return false;
        }
        RepositoryInfo ri = (RepositoryInfo)a_ri;
        if (!this.m_repositoryLocation.equals(ri.m_repositoryLocation)) {
            return false;
        }
        if (this.m_repositoryType != null ? !this.m_repositoryType.equals(ri.m_repositoryType) : ri.m_repositoryType != null) {
            return false;
        }
        return !(this.m_repositoryVersion != null ? !this.m_repositoryVersion.equals(ri.m_repositoryVersion) : ri.m_repositoryVersion != null);
    }

    @Override
    public void setRepositoryDescriptor(RepositoryDescriptor descriptor) {
        this.m_repositoryDescriptor = descriptor;
    }

    @Override
    public RepositoryDescriptor getRepositoryDescriptor() {
        return this.m_repositoryDescriptor;
    }

    @Override
    public void setOpen(boolean isOpened) {
        this.m_opened = isOpened;
    }

    @Override
    public boolean isOpen() {
        return this.m_opened;
    }

    @Override
    public void setIncludeBuildData(boolean includeBuildData) {
        this.m_includeBuildData = includeBuildData;
    }

    @Override
    public boolean getIncludeBuildData() {
        return this.m_includeBuildData;
    }

    @Override
    public String toShortString() {
        StringBuffer sb = new StringBuffer();
        sb.append("RepoInfo");
        String location = this.getLocationStr();
        sb.append(" at '");
        sb.append(location);
        sb.append("'");
        if (!this.m_repositoryName.equals(location)) {
            sb.append(" name='");
            sb.append(this.m_repositoryName);
            sb.append("'");
        }
        return sb.toString();
    }

    @Override
    public String getNonNullStringProperty(String a_id) {
        String return_value = this.getStringProperty(a_id);
        return return_value != null ? return_value : "";
    }

    @Override
    public IStatus getLastOperationStatus() {
        return this.m_lastOperationStatus == null ? Status.OK_STATUS : this.m_lastOperationStatus;
    }

    @Override
    public void setLastOperationStatus(IStatus status) {
        this.m_lastOperationStatus = status;
    }

    @Override
    public RepositoryDigestRepositoryData getRepositoryDigestData() {
        return this.m_repositoryDigestData;
    }

    @Override
    public void setRepositoryDigestData(RepositoryDigestRepositoryData a_rdd) {
        this.m_repositoryDigestData = a_rdd;
    }

    @Override
    public void requestReadOnlyRepository() {
        this.m_readOnlyRepositoryRequested = true;
    }

    @Override
    public boolean isReadOnlyRepositoryRequested() {
        return this.m_readOnlyRepositoryRequested;
    }

    @Override
    public IStatus getRepositoryReportedStatus() {
        return this.m_repositoryReportedStatus;
    }

    @Override
    public void setRepositoryReportedStatus(IStatus status) {
        this.m_repositoryReportedStatus = status;
    }

    @Override
    public void setRepositoryReportedStatus(String status, String message) {
        if (status != null && message != null && message.length() > 0) {
            if (status.equalsIgnoreCase("ERROR")) {
                this.setRepositoryReportedStatus((IStatus)new RepositoryStatus(RepositoryStatus.ST_ERROR_CANT_ADD_EXISTING_REPOSITORY_SITE_CLOSED, message));
                ((RepositoryStatus)this.m_repositoryReportedStatus).setLocation(this.m_repositoryLocation.toString());
            } else if (status.equalsIgnoreCase("WARNING")) {
                this.setRepositoryReportedStatus((IStatus)new RepositoryStatus(RepositoryStatus.ST_WARNING_REPOSITORY_STATUS_WARNING, message));
            } else if (status.equalsIgnoreCase("INFO")) {
                this.setRepositoryReportedStatus((IStatus)new RepositoryStatus(RepositoryStatus.ST_OK_REPOSITORY_STATUS_OK, message));
            }
        }
    }

    @Override
    public void initializeFrom(IRepositoryInfo a_info) {
        this.m_properties = a_info.getProperties();
        this.m_repositoryReportedStatus = a_info.getRepositoryReportedStatus();
    }
}

