/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.core.artifactrepo.impl.AbstractContentLocator;
import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.internal.downloads.DownloadedIncompleteUsingDip;
import com.ibm.cic.common.core.internal.downloads.NullHasIsCanceledMonitor;
import com.ibm.cic.common.core.internal.downloads.ProgressMessage;
import com.ibm.cic.common.core.internal.downloads.ResumableDownloadLiveStatus;
import com.ibm.cic.common.core.internal.downloads.ResumableDownloadSummaryStatus;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreDebugOptions;
import com.ibm.cic.common.core.internal.utils.CicCommonCoreTrace;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.StatusUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.DownloadHandler;
import com.ibm.cic.common.downloads.DownloadInProgressManager;
import com.ibm.cic.common.downloads.DownloadLiveSupplementaryReporter;
import com.ibm.cic.common.downloads.DownloadRetry;
import com.ibm.cic.common.downloads.DownloadRetryLevel;
import com.ibm.cic.common.downloads.DownloadUI;
import com.ibm.cic.common.downloads.DownloadedFile;
import com.ibm.cic.common.downloads.IDownloadIncomplete;
import com.ibm.cic.common.downloads.IDownloadUI;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.IResumableDownloadEventListener;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.downloads.ResumableDownloadEvents;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import com.ibm.cic.common.downloads.ResumableProgressEvents;
import com.ibm.cic.common.downloads.TransferMonitor;
import com.ibm.cic.common.logging.ExceptionUtil;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Plugin;
import org.eclipse.osgi.util.NLS;

public class ResumeableDownload {
    public static final CicCommonCoreTrace debugProgressVerification = new CicCommonCoreTrace(ComIbmCicCommonCorePlugin.getDefault(), CicCommonCoreDebugOptions.DEBUG_PROGRESS_VERIFICATION);
    public static final Logger log = Logger.getLogger(ResumeableDownload.class, (Plugin)ComIbmCicCommonCorePlugin.getDefault());

    public static IDownloadedFile doRetrieveFile(IBytesRetriever retriever, Progress progress) {
        AbstractContentLocator.DownloadedFileWrapper downloadedFileWrapper;
        RetrieveHistory history = new RetrieveHistory(retriever);
        ResumableDownloadSummaryStatus statsListener = new ResumableDownloadSummaryStatus(retriever);
        DownloadLiveSupplementaryReporter dlLiveReporter = new DownloadLiveSupplementaryReporter();
        ResumableDownloadLiveStatus liveListener = new ResumableDownloadLiveStatus(retriever);
        ResumableDownloadEvents.INSTANCE.addListener(statsListener);
        ResumableDownloadEvents.INSTANCE.addListener(liveListener);
        ResumableDownloadEvents.FIRE.onEvent(new IResumableDownloadEventListener.ResumableDownloadBeginEvent(retriever));
        ICicStatus status = null;
        try {
            AbstractContentLocator.DownloadedFileWrapper dlFileWithIntermediateAndRetriesReported;
            IDownloadedFile dlFile = ResumeableDownload.doRetrieveFileInternal(retriever, history, progress);
            status = statsListener.getStatus();
            downloadedFileWrapper = dlFileWithIntermediateAndRetriesReported = new AbstractContentLocator.DownloadedFileWrapper(dlFile, status);
            ResumableDownloadEvents.INSTANCE.removeListener(statsListener);
        }
        catch (Throwable throwable) {
            ResumableDownloadEvents.INSTANCE.removeListener(statsListener);
            boolean keepIfUsed = status == null || status.matches(4) && !StatusCodes.isContentNotFound(status) && !StatusCodes.isAuthenticationCanceled(status);
            String explanationMsg = null;
            dlLiveReporter.checkLastSupplementaryLogger(log, keepIfUsed, explanationMsg);
            ResumableDownloadEvents.INSTANCE.removeListener(liveListener);
            throw throwable;
        }
        boolean keepIfUsed = status == null || status.matches(4) && !StatusCodes.isContentNotFound(status) && !StatusCodes.isAuthenticationCanceled(status);
        String explanationMsg = null;
        dlLiveReporter.checkLastSupplementaryLogger(log, keepIfUsed, explanationMsg);
        ResumableDownloadEvents.INSTANCE.removeListener(liveListener);
        return downloadedFileWrapper;
    }

    private static IDownloadedFile doRetrieveFileInternal(IBytesRetriever retriever, RetrieveHistory history, Progress progress) {
        RetriableDownload retriable = new RetriableDownload(retriever, progress);
        DownloadRetry.retry(history, retriable);
        if (retriable.isDone()) {
            return retriable.getDownloadedFileResult();
        }
        retriever.end();
        return retriable.getDownloadedFileResult();
    }

    private static boolean shouldRetry(IRetrievalHelper helper, IStatus status) {
        if (StatusCodes.isAuthenticationCanceled(status)) {
            return false;
        }
        Throwable t = MultiStatusUtil.getStatusOnSubException(status);
        if (t == null) {
            return true;
        }
        if (t instanceof Exception) {
            Exception exception = (Exception)t;
            DownloadRetryLevel retryLevel = helper.retryLevel(exception);
            IDownloadUI ui = DownloadUI.INSTANCE.getUI();
            return DownloadHandler.shouldRetry(ui, retryLevel);
        }
        return false;
    }

    public static interface IBytesRetriever {
        public Retrieved retrieve(RetrieveHistory var1, ResumableDownloadProgress.IResumableDownloadProgress var2);

        public void end();

        public boolean willVerify();

        public IRetrievalHelper getHelper();

        public IDownloadedFile getDownloadedFileResult(Retrieved var1);

        public Object getSource();
    }

    public static interface IRetrievalHelper {
        public ITransferMonitor getTransferPerformance();

        public Object getSource();

        public boolean isValidationFailed(IStatus var1);

        public DownloadRetryLevel retryLevel(Exception var1);

        public boolean isNotFound(IStatus var1);

        public IDownloadedFile retrieve(DownloadInProgressManager.IDownloadInProgress var1, ResumableDownloadProgress.IResumableDownloadProgress var2, long[] var3);

        public CicMultiStatus createValidationFailedMultiStatus();
    }

    public static class NonResumeableBytesRetriever
    implements IBytesRetriever {
        private final DownloadInProgressManager dipm = DownloadInProgressManager.INSTANCE;
        private final DownloadInProgressManager.NonValidatedDownload nrd;
        private final IRetrievalHelper helper;
        private File finalFile;
        private IDownloadIncomplete incompleteDownload;

        public NonResumeableBytesRetriever(IRetrievalHelper helper, DownloadInProgressManager.NonValidatedDownload nrd) {
            this.helper = helper;
            this.nrd = nrd;
        }

        @Override
        public Object getSource() {
            return this.helper.getSource();
        }

        @Override
        public void end() {
            this.dipm.forget(this.nrd);
            this.finalFile = null;
        }

        @Override
        public Retrieved retrieve(RetrieveHistory history, ResumableDownloadProgress.IResumableDownloadProgress progress) {
            long[] bytesRetrieved = new long[1];
            IDownloadedFile dlFile = this.helper.retrieve(this.nrd, progress, bytesRetrieved);
            ICicStatus statusGetFile = dlFile.getStatus();
            if (statusGetFile.isOK() || statusGetFile.matches(3)) {
                try {
                    this.dipm.completed(this.nrd, (IProgressMonitor)new NullProgressMonitor());
                    this.finalFile = this.nrd.getTargetLocation().toFile();
                    return new Retrieved(dlFile, statusGetFile, true, bytesRetrieved[0]);
                }
                catch (CoreException e) {
                    this.incompleteDownload = new DownloadedIncompleteUsingDip(this.nrd, Collections.EMPTY_LIST);
                    return new Retrieved(dlFile, StatusUtil.convertToCicStatus(e.getStatus()), true, bytesRetrieved[0]);
                }
            }
            if (this.helper.isNotFound(statusGetFile)) {
                this.dipm.forget(this.nrd);
                return new Retrieved(dlFile, statusGetFile, true);
            }
            if (statusGetFile.matches(4)) {
                boolean done;
                this.incompleteDownload = new DownloadedIncompleteUsingDip(this.nrd, Collections.EMPTY_LIST);
                boolean shouldRetry = ResumeableDownload.shouldRetry(this.helper, statusGetFile);
                boolean bl = done = !shouldRetry;
                if (done) {
                    this.dipm.forget(this.nrd);
                    return new Retrieved(dlFile, statusGetFile, done);
                }
                return new Retrieved(dlFile, statusGetFile, done, bytesRetrieved[0]);
            }
            this.dipm.forget(this.nrd);
            return new Retrieved(dlFile, statusGetFile, true);
        }

        @Override
        public IRetrievalHelper getHelper() {
            return this.helper;
        }

        @Override
        public boolean willVerify() {
            return false;
        }

        @Override
        public IDownloadedFile getDownloadedFileResult(Retrieved retrieved) {
            IDownloadedFile dlFile = retrieved.getResult();
            return new DownloadedFile(retrieved.getTotalStatus(), this.finalFile, dlFile.getDownloadContentInfo(), this.incompleteDownload);
        }
    }

    public static class Progress
    implements ResumableDownloadProgress.IResumableDownloadProgress {
        private final ITransferMonitor transferMonitor;
        private final TransferCallback transferPerformance;
        private int count = 0;
        private final boolean willVerify;

        public Progress(ITransferMonitor transferMonitor, boolean willVerify) {
            this.transferMonitor = transferMonitor;
            this.willVerify = willVerify;
            this.transferPerformance = new TransferCallback();
            this.transferMonitor.addListener(this.transferPerformance);
        }

        @Override
        public void startResumeableDownload(long bytesTotal, long bytesToTransfer, boolean pwillVerify) {
            ResumableProgressEvents.FIRE.startResumeableDownload(bytesTotal, bytesToTransfer, pwillVerify);
        }

        @Override
        public void endResumeableDownload() {
            ResumableProgressEvents.FIRE.endResumeableDownload();
            this.transferMonitor.removeListener(this.transferPerformance);
        }

        @Override
        public void beginTransfer(long bytesToTransfer) {
            ResumableProgressEvents.FIRE.beginTransfer(bytesToTransfer);
        }

        @Override
        public void endTransfer() {
            ResumableProgressEvents.FIRE.endTransfer();
        }

        @Override
        public void updateTransfer(int percentDone, long bytesTransferred, long bytesToTransferTotal, long bytesPerSecondTotal, long bytesPerLastSecond) {
            ResumableProgressEvents.FIRE.updateTransfer(percentDone, bytesTransferred, bytesToTransferTotal, bytesPerSecondTotal, bytesPerLastSecond);
        }

        @Override
        public void notifyRestart() {
            ResumableProgressEvents.FIRE.notifyRestart();
        }

        @Override
        public void beginVerification() {
            ResumableProgressEvents.FIRE.beginVerification();
        }

        @Override
        public void endVerification() {
            ResumableProgressEvents.FIRE.endVerification();
        }

        @Override
        public void updateVerificationProgress(int percent) {
            ResumableProgressEvents.FIRE.updateVerificationProgress(percent);
        }

        @Override
        public boolean isCanceled() {
            return this.transferMonitor.isCanceled();
        }

        class TransferCallback
        extends TransferMonitor {
            public TransferCallback() {
                super(NullHasIsCanceledMonitor.INSTANCE);
            }

            @Override
            public void startTransfer(long bytesTotal, long bytesToTransfer) {
                if (Progress.this.count == 0) {
                    Progress.this.startResumeableDownload(bytesTotal, bytesToTransfer, Progress.this.willVerify);
                }
                Progress.this.beginTransfer(bytesToTransfer);
                Progress progress = Progress.this;
                progress.count = progress.count + 1;
            }

            @Override
            public void update(int percentDone, long bytesTransferred, long bytesToTransferTotal, long bytesPerSecondTotal, long bytesPerLastSecond) {
                Progress.this.updateTransfer(percentDone, bytesTransferred, bytesToTransferTotal, bytesPerSecondTotal, bytesPerLastSecond);
            }

            @Override
            public void done() {
                Progress.this.endTransfer();
                Progress progress = Progress.this;
                progress.count = progress.count - 1;
            }

            @Override
            public boolean needsUpdates() {
                return true;
            }
        }
    }

    public static class ProgressFormatListener
    implements ResumableDownloadProgress.IResumableDownloadProgress {
        private static final String EMPTY_STRING = "";
        private boolean calledBeginTask = false;
        private final IProgressMonitor monitor;
        private int ticksUsedDownload = 0;
        private int ticksUsedVerification = 0;
        private int retryCount = 0;
        private int ticksForDownload;
        private int ticksForVerification;
        private long lastVerificationUpdate = 0L;
        private int pctVerification = -1;
        private String mainTask = "";
        private ProgressMessage progressMessage;
        private final String hasUserString;
        private final Throwable creatorThrowable;

        public ProgressFormatListener(IProgressMonitor monitor, String hasUserString) {
            this.monitor = monitor;
            this.hasUserString = hasUserString;
            this.creatorThrowable = new Throwable();
        }

        @Override
        public void startResumeableDownload(long bytesTotal, long bytesToTransfer, boolean pwillVerify) {
            this.monitor.beginTask(EMPTY_STRING, 100);
            this.calledBeginTask = true;
            if (bytesTotal != -1L && bytesToTransfer != -1L) {
                if (pwillVerify) {
                    this.ticksForDownload = (int)(bytesToTransfer * 100L / bytesTotal * 80L / 100L + 10L);
                    this.ticksForVerification = 100 - this.ticksForDownload;
                } else {
                    this.ticksForDownload = 100;
                    this.ticksForVerification = 0;
                }
            } else {
                this.ticksForDownload = 0;
                this.ticksForVerification = 0;
            }
        }

        @Override
        public void endResumeableDownload() {
            if (this.calledBeginTask) {
                this.monitor.done();
                this.calledBeginTask = false;
            }
        }

        @Override
        public void beginTransfer(long bytesToTransfer) {
            this.ticksUsedDownload = 0;
            this.newMainTask(this.retryCount > 0 ? Messages.ResumeableDownload_task_retry_downloading : Messages.ResumeableDownload_task_downloading);
            this.progressMessage = new ProgressMessage();
            this.progressMessage.startTransfer(bytesToTransfer);
        }

        private void newMainTask(String taskKey) {
            this.mainTask = NLS.bind((String)taskKey, (Object)this.hasUserString);
            this.monitor.subTask(this.mainTask);
        }

        @Override
        public void endTransfer() {
        }

        @Override
        public void updateTransfer(int percentDone, long bytesTransferred, long bytesToTransferTotal, long bytesPerSecondTotal, long bytesPerLastSecond) {
            int ticks;
            int work;
            if (this.calledBeginTask && (work = (ticks = percentDone * this.ticksForDownload / 100) - this.ticksUsedDownload) > 0) {
                this.monitor.worked(work);
                this.ticksUsedDownload += work;
            }
            if (this.progressMessage == null) {
                if (UserOptions.CIC_DOWNLOAD_WARN_ABOUT_UNEXPECTED_CONCURRENCY.isSet()) {
                    log.status(Statuses.WARNING.get(this.creatorThrowable, "Unexpected concurrent download initiated by associated stacktrace {0}", this.hasUserString));
                }
                return;
            }
            String curMsg = this.progressMessage.getRateMessage(percentDone, bytesTransferred, bytesToTransferTotal, bytesPerSecondTotal, bytesPerLastSecond);
            String task = NLS.bind((String)Messages.ResumeableDownload_task_progress, (Object)this.mainTask, (Object)curMsg);
            this.monitor.subTask(task);
        }

        @Override
        public void notifyRestart() {
            this.monitor.worked(-1 * (this.ticksUsedDownload + this.ticksUsedVerification));
            ++this.retryCount;
        }

        @Override
        public void beginVerification() {
            this.ticksUsedVerification = 0;
            this.pctVerification = -1;
            this.lastVerificationUpdate = System.currentTimeMillis();
            String task = NLS.bind((String)Messages.ResumeableDownload_task_progress, (Object)this.mainTask, (Object)Messages.ResumeableDownload_progress_verification);
            this.monitor.subTask(task);
        }

        @Override
        public void endVerification() {
            this.monitor.subTask(EMPTY_STRING);
        }

        @Override
        public void updateVerificationProgress(int percent) {
            int ticks;
            int work;
            long curTime = System.currentTimeMillis();
            long elapsed = curTime - this.lastVerificationUpdate;
            if (elapsed < 1000L) {
                return;
            }
            if (this.calledBeginTask && (work = (ticks = percent * this.ticksForVerification / 100) - this.ticksUsedVerification) > 0) {
                this.monitor.worked(work);
                this.ticksUsedVerification += work;
            }
            if (this.pctVerification != percent) {
                String percentMsg = NLS.bind((String)Messages.ResumeableDownload_progress_verification_pct, (Object)Integer.toString(percent));
                String task = NLS.bind((String)Messages.ResumeableDownload_task_progress, (Object)this.mainTask, (Object)percentMsg);
                this.monitor.subTask(task);
                this.pctVerification = percent;
                if (ResumeableDownload.debugProgressVerification.enabled) {
                    try {
                        Thread.sleep(100L);
                    }
                    catch (InterruptedException e) {
                        ExceptionUtil.debugLogInterruptedException(e);
                    }
                }
            }
        }

        @Override
        public boolean isCanceled() {
            return false;
        }
    }

    public static class ResumeableBytesRetriever
    implements IBytesRetriever {
        private final DownloadInProgressManager dipm = DownloadInProgressManager.INSTANCE;
        private DownloadInProgressManager.ValidatedDownload dr;
        private final IRetrievalHelper helper;
        private File finalFile;
        private IDownloadIncomplete incompleteDownload;
        private final List dlFilesDigestMismatches;
        private int digestMismatchCount;
        private int digestMismatchReportedCount;
        private final int digestMismatchRetries;

        public ResumeableBytesRetriever(IRetrievalHelper helper, DownloadInProgressManager.ValidatedDownload dr) {
            this.helper = helper;
            this.dr = dr;
            this.dlFilesDigestMismatches = new ArrayList();
            this.digestMismatchCount = 0;
            this.digestMismatchReportedCount = 0;
            this.digestMismatchRetries = 2;
        }

        @Override
        public Object getSource() {
            return this.helper.getSource();
        }

        @Override
        public void end() {
            this.dipm.failedNotDone(this.dr);
        }

        @Override
        public Retrieved retrieve(RetrieveHistory history, ResumableDownloadProgress.IResumableDownloadProgress progress) {
            IDownloadedFile dlFile = null;
            long totalBytesRetrieved = 0L;
            assert (this.digestMismatchCount < this.digestMismatchRetries);
            if (this.dr.getState() != DownloadInProgressManager.State.INITIAL && this.dr.getState() != DownloadInProgressManager.State.PARTIAL) {
                throw new IllegalStateException();
            }
            if (this.digestMismatchCount > this.digestMismatchReportedCount) {
                String msg = Messages.ResumeableDownload_retryCorruptRetrieval;
                history.addStatus(Statuses.INFO.get(1000, msg, new Object[0]));
                ++this.digestMismatchReportedCount;
                progress.notifyRestart();
            }
            long[] bytesRetrieved = new long[1];
            dlFile = this.helper.retrieve(this.dr, progress, bytesRetrieved);
            this.incompleteDownload = dlFile.getIncompleteDownload();
            totalBytesRetrieved += bytesRetrieved[0];
            ICicStatus statusGetFile = dlFile.getStatus();
            boolean notFound = this.helper.isNotFound(statusGetFile);
            if (!notFound && (statusGetFile.isOK() || statusGetFile.matches(3))) {
                ICicStatus status = statusGetFile;
                try {
                    this.dipm.completed(this.dr, (IProgressMonitor)new NullProgressMonitor());
                    this.finalFile = this.dr.getTargetLocation().toFile();
                    this.incompleteDownload = null;
                }
                catch (CoreException e) {
                    status = StatusUtil.convertToCicStatus(e.getStatus());
                }
                if (this.digestMismatchCount > 0) {
                    String msg = Messages.ResumeableDownload_retry_bad_digest_successful;
                    CicMultiStatus ms = Statuses.ST.createMultiStatus(1001, msg, new Object[0]);
                    ms.add(statusGetFile);
                    history.addStatus(ms);
                }
                return new Retrieved(dlFile, status, true, totalBytesRetrieved);
            }
            if (this.helper.isValidationFailed(statusGetFile)) {
                this.incompleteDownload = null;
                File[] outBadFile = new File[1];
                IStatus statusWrongDigest = this.dipm.failedWrongDigest(this.dr, outBadFile);
                this.dr = this.dipm.getValidatedDownload(this.dr);
                CicMultiStatus msValidationFailed = this.helper.createValidationFailedMultiStatus();
                MultiStatusUtil.addReduceStatus(MultiStatusUtil.StatusEqualByCodePluginMessage, msValidationFailed, statusGetFile);
                msValidationFailed.merge(statusWrongDigest);
                ++this.digestMismatchCount;
                if (outBadFile[0] != null) {
                    this.dlFilesDigestMismatches.add(new DownloadedFile(dlFile.getStatus(), outBadFile[0], dlFile.getDownloadContentInfo()));
                }
                return new Retrieved(dlFile, msValidationFailed, this.digestMismatchCount == this.digestMismatchRetries, totalBytesRetrieved);
            }
            if (statusGetFile.matches(8)) {
                this.dipm.failedNotDone(this.dr);
                return new Retrieved(dlFile, statusGetFile, true, totalBytesRetrieved);
            }
            if (notFound) {
                this.dipm.failedNotFound(this.dr);
                this.incompleteDownload = null;
                return new Retrieved(dlFile, statusGetFile, true, totalBytesRetrieved);
            }
            assert (statusGetFile.matches(4));
            boolean shouldRetry = ResumeableDownload.shouldRetry(this.helper, statusGetFile);
            if (!shouldRetry) {
                File[] outBadFile = new File[1];
                this.dipm.failedRetryWillFail(this.dr, outBadFile, statusGetFile);
                if (outBadFile[0] != null) {
                    this.dlFilesDigestMismatches.add(new DownloadedFile(dlFile.getStatus(), outBadFile[0], dlFile.getDownloadContentInfo()));
                }
            }
            return new Retrieved(dlFile, statusGetFile, !shouldRetry, totalBytesRetrieved);
        }

        @Override
        public IRetrievalHelper getHelper() {
            return this.helper;
        }

        @Override
        public boolean willVerify() {
            return true;
        }

        @Override
        public IDownloadedFile getDownloadedFileResult(Retrieved retrieved) {
            DownloadedIncompleteUsingDip effectiveIncompleteDownload = null;
            if (!this.dlFilesDigestMismatches.isEmpty() || this.incompleteDownload != null) {
                effectiveIncompleteDownload = new DownloadedIncompleteUsingDip(this.dr, this.dlFilesDigestMismatches);
            }
            IDownloadedFile dlFile = retrieved.getResult();
            return new DownloadedFile(retrieved.getTotalStatus(), this.finalFile, dlFile.getDownloadContentInfo(), effectiveIncompleteDownload);
        }
    }

    static class RetriableDownload
    implements DownloadRetry.IRetriableCall {
        private final IBytesRetriever retriever;
        private final Progress progress;
        private Retrieved retrieved;

        RetriableDownload(IBytesRetriever retriever, Progress progress) {
            this.retriever = retriever;
            this.progress = progress;
        }

        @Override
        public void call(DownloadRetry.IRetryHistory baseHistory) {
            RetrieveHistory history = (RetrieveHistory)baseHistory;
            this.retrieved = this.retriever.retrieve(history, this.progress);
            history.addRetrieved(this.retrieved);
        }

        public IStatus getLastRetrievalStatus() {
            assert (this.retrieved != null);
            return this.retrieved.getStatus();
        }

        @Override
        public boolean hasValidationFailedInTotalStatus() {
            assert (this.retrieved != null);
            boolean validationFailedInTotalStatus = this.retriever.getHelper().isValidationFailed(this.retrieved.getTotalStatus());
            return validationFailedInTotalStatus;
        }

        @Override
        public Object getSource() {
            return this.retriever.getSource();
        }

        @Override
        public boolean isCanceled() {
            return this.progress.isCanceled();
        }

        @Override
        public boolean isDone() {
            assert (this.retrieved != null);
            return this.retrieved.isDone();
        }

        @Override
        public Boolean lastCallMadeProgress() {
            assert (this.retrieved != null);
            if (this.retrieved.getReadTotalBytes() > 0L) {
                return true;
            }
            return false;
        }

        @Override
        public boolean hasValidationFailed() {
            assert (this.retrieved != null);
            boolean validationFailedLastDownload = this.retriever.getHelper().isValidationFailed(this.retrieved.getStatus());
            return validationFailedLastDownload;
        }

        public IDownloadedFile getDownloadedFileResult() {
            assert (this.retrieved != null);
            return this.retriever.getDownloadedFileResult(this.retrieved);
        }

        @Override
        public void onBeforeTryInterrupt() {
            log.debug("Requesting interrupted state. Status of last retrieval {0}.", this.retrieved.getStatus());
        }
    }

    public static class RetrieveHistory
    implements DownloadRetry.IRetryHistory {
        private final IBytesRetriever retriever;

        public RetrieveHistory(IBytesRetriever retriever) {
            this.retriever = retriever;
        }

        public void addRetrieved(Retrieved retrieved) {
            ResumableDownloadEvents.FIRE.onEvent(new IResumableDownloadEventListener.ResumableDownloadRetrieveEvent(this.retriever, retrieved));
        }

        @Override
        public void addStatus(IStatus status) {
            ResumableDownloadEvents.FIRE.onEvent(new IResumableDownloadEventListener.ResumableDownloadStatusEvent(this.retriever, status));
        }
    }

    public static class Retrieved {
        private boolean done;
        private ICicStatus totalStatus;
        private final IDownloadedFile dlFile;
        private long readTotalBytes;

        public Retrieved(IDownloadedFile result, ICicStatus totalStatus, boolean done) {
            this(result, totalStatus, done, 0L);
        }

        public Retrieved(IDownloadedFile result, ICicStatus totalStatus, boolean done, long readTotalBytes) {
            this.done = done;
            this.dlFile = result;
            this.totalStatus = totalStatus;
            this.readTotalBytes = readTotalBytes;
        }

        public boolean isDone() {
            return this.done;
        }

        public void setDone(boolean done) {
            this.done = done;
        }

        public long getReadTotalBytes() {
            return this.readTotalBytes;
        }

        public void setReadTotalBytes(long retrieved) {
            this.readTotalBytes = retrieved;
        }

        public IDownloadedFile getResult() {
            return this.dlFile;
        }

        public ICicStatus getTotalStatus() {
            return this.totalStatus != null ? this.totalStatus : this.getStatus();
        }

        public ICicStatus getStatus() {
            return this.dlFile.getStatus();
        }

        public void setTotalStatus(ICicStatus status) {
            this.totalStatus = status;
        }

        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("done=");
            sb.append(this.done);
            sb.append(" readTotalBytes=");
            sb.append(this.readTotalBytes);
            sb.append(" totalStatus=");
            sb.append(this.totalStatus);
            sb.append(" dlFile=");
            sb.append(this.dlFile);
            return sb.toString();
        }
    }
}

