/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.core.internal.downloads.AbstractWrappedStatus;
import com.ibm.cic.common.core.internal.downloads.ResumableDownloadStatusListener;
import com.ibm.cic.common.core.internal.downloads.ResumeableDownload;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.ICicStatus;
import com.ibm.cic.common.core.utils.IWrappedStatus;
import com.ibm.cic.common.core.utils.MultiStatusUtil;
import com.ibm.cic.common.core.utils.NLS;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.downloads.DownloadPrematureEOFException;
import com.ibm.cic.common.downloads.IDownloaded;
import com.ibm.cic.common.downloads.IResumableDownloadEventListener;
import com.ibm.cic.common.downloads.Messages;
import com.ibm.cic.common.logging.LogUtil;
import com.ibm.cic.common.logging.Logger;
import java.util.ArrayList;
import org.eclipse.core.runtime.IStatus;

public class ResumableDownloadSummaryStatus
extends ResumableDownloadStatusListener {
    private static final Logger log = ResumeableDownload.log;
    private long startTime = -1L;
    private long doneTime = -1L;
    private final ArrayList seen = new ArrayList();
    private final ArrayList counts = new ArrayList();
    private static final MultiStatusUtil.IStatusEqual STATUS_EQUAL_OP = new MultiStatusUtil.IStatusEqual(){

        @Override
        public boolean isEqualStatus(IStatus a, IStatus b) {
            if (a == b) {
                return true;
            }
            if (!$assertionsDisabled && a == null) {
                throw new AssertionError();
            }
            if (!$assertionsDisabled && b == null) {
                throw new AssertionError();
            }
            if (!MultiStatusUtil.StatusEqualByCodeSeverityPluginMessage.isEqualStatus(a, b)) {
                return false;
            }
            return ResumableDownloadSummaryStatus.isEqualException(a.getException(), b.getException());
        }
    };

    public ResumableDownloadSummaryStatus(ResumeableDownload.IBytesRetriever retriever) {
        super(retriever);
    }

    @Override
    protected void onResumeableDownloadBeginEvent(IResumableDownloadEventListener.ResumableDownloadEvent event) {
        this.startTime = System.currentTimeMillis();
    }

    @Override
    protected void onResumeableDownloadRetrieveEvent(IResumableDownloadEventListener.ResumableDownloadRetrieveEvent rr) {
        super.onResumeableDownloadRetrieveEvent(rr);
        this.count(rr.getRetrieved());
        if (rr.getRetrieved().isDone()) {
            this.doneTime = System.currentTimeMillis();
        }
    }

    @Override
    protected void onResumeableDownloadStatusEvent(IResumableDownloadEventListener.ResumableDownloadStatusEvent statusEvent) {
        IStatus status = statusEvent.getStatus();
        this.count(status);
    }

    private void count(Object obj) {
        int i = 0;
        while (i < this.seen.size()) {
            Object c = this.seen.get(i);
            if (ResumableDownloadSummaryStatus.isEqual(obj, c)) {
                Integer count = (Integer)this.counts.get(i);
                this.counts.set(i, count + 1);
                return;
            }
            ++i;
        }
        this.seen.add(obj);
        this.counts.add(1);
    }

    private static IStatus getStatus(Object obj) {
        if (obj instanceof IStatus) {
            return (IStatus)obj;
        }
        if (obj instanceof ResumeableDownload.Retrieved) {
            ResumeableDownload.Retrieved r = (ResumeableDownload.Retrieved)obj;
            return r.getTotalStatus();
        }
        assert (false);
        return null;
    }

    private static String getMaxSeverityAsString(IStatus status) {
        if (status.matches(8)) {
            return "CANCEL";
        }
        if (status.matches(4)) {
            return "ERROR";
        }
        if (status.matches(2)) {
            return "WARNING";
        }
        if (status.matches(1)) {
            return "INFO";
        }
        return "OK";
    }

    private static int getMaxSeverity(IStatus status) {
        if (status.matches(8)) {
            return 8;
        }
        if (status.matches(4)) {
            return 4;
        }
        if (status.matches(2)) {
            return 2;
        }
        if (status.matches(1)) {
            return 1;
        }
        return 0;
    }

    private static CicMultiStatus getSummaryMessage(IStatus status, Object source) {
        CicMultiStatus return_value = status.matches(8) ? Statuses.CANCEL.getMultiStatus(status.getCode(), null, Messages.ResumeableDownloadSummaryStatus_retrieve_canceled_summary_msg, source) : (status.matches(4) ? Statuses.ERROR.getMultiStatus(status.getCode(), null, Messages.ResumeableDownloadSummaryStatus_retrieve_failed_summary_msg, source) : Statuses.OK.getMultiStatus(status.getCode(), null, Messages.ResumeableDownloadSummaryStatus_retrieve_succeeded_summary_msg, source));
        return return_value;
    }

    public ICicStatus getStatus() {
        IStatus last = this.getLastRetrievalStatus();
        if (last == null) {
            return null;
        }
        int severityForElapsedTime = last.isOK() ? 0 : 1;
        CicMultiStatus ms = ResumableDownloadSummaryStatus.getSummaryMessage(last, this.retriever.getSource());
        this.addSeenWithCounts(ms, last);
        long elapsed = this.doneTime != -1L ? this.doneTime - this.startTime : System.currentTimeMillis() - this.startTime;
        String strElapsed = LogUtil.toElapsedTime(elapsed);
        ms.add(ResumableDownloadSummaryStatus.getElapsedTimeStatus(severityForElapsedTime, strElapsed));
        if (log.isDebugLoggable()) {
            log.status(ms);
        }
        return ms;
    }

    private static IStatus getElapsedTimeStatus(int severity, String strElapsed) {
        ICicStatus statusTimeElapsed = Statuses.ST.createStatus(severity, 0, null, Messages.ResumeableDownloadSummaryStatus_time_elapsed, strElapsed);
        return statusTimeElapsed;
    }

    public String toString() {
        ArrayList<String> seenStrings = new ArrayList<String>(this.seen.size());
        int i = 0;
        while (i < this.seen.size()) {
            Object o = this.seen.get(i);
            IStatus status = ResumableDownloadSummaryStatus.getStatus(o);
            if (status != null) {
                String str = NLS.bind("{0}x{1}-{2}", this.counts.get(i), ResumableDownloadSummaryStatus.getMaxSeverityAsString(status), status.getCode());
                Throwable t = MultiStatusUtil.getStatusOnSubException(status);
                if (t != null) {
                    str = String.valueOf(str) + NLS.bind(" ({0})", (Object)t.toString());
                }
                seenStrings.add(i, str);
            }
            ++i;
        }
        return seenStrings.toString();
    }

    private static String getIntermediateStatusMessage(IStatus status) {
        if (status.matches(4)) {
            return NLS.bind(Messages.ResumeableDownloadSummaryStatus_retrieve_intermediate_error_msg, (Object)status.getMessage());
        }
        if (status.matches(2)) {
            return NLS.bind(Messages.ResumeableDownloadSummaryStatus_retrieve_intermediate_warning_msg, (Object)status.getMessage());
        }
        return NLS.bind(Messages.ResumeableDownloadSummaryStatus_retrieve_intermediate_msg, (Object)status.getMessage());
    }

    private void addSeenWithCounts(CicMultiStatus ms, IStatus reported) {
        int reportedSeverity = ResumableDownloadSummaryStatus.getMaxSeverity(reported);
        int i = 0;
        while (i < this.seen.size()) {
            Object obj = this.seen.get(i);
            IStatus status = ResumableDownloadSummaryStatus.getStatus(obj);
            Integer count = (Integer)this.counts.get(i);
            int statusSeverity = ResumableDownloadSummaryStatus.getMaxSeverity(status);
            if (statusSeverity > reportedSeverity) {
                IStatus recodedStatus = MultiStatusUtil.recodeStatus(status, new MultiStatusUtil.IStatusRecoder(){

                    @Override
                    public boolean needsRecoding(IStatus s) {
                        return !s.isMultiStatus();
                    }

                    @Override
                    public IStatus recode(IStatus s) {
                        String msg = ResumableDownloadSummaryStatus.getIntermediateStatusMessage(s);
                        return new IntermediateProblemStatus(s, 0, msg);
                    }

                    @Override
                    public IStatus recode(IStatus multiStatus, IStatus[] children) {
                        throw new AssertionError((Object)"should never be called");
                    }
                });
                this.addWithCount(ms, recodedStatus, count);
            } else {
                this.addWithCount(ms, status, count);
            }
            ++i;
        }
    }

    private void addWithCount(CicMultiStatus ms, IStatus status, Integer count) {
        if (count == 1) {
            ms.add(status);
        } else {
            String msg = NLS.bind(Messages.ResumeableDownloadSummaryStatus_seen_count_times, (Object)count, (Object)status.getMessage());
            CountStatus statusWithCount = new CountStatus(status, count, msg);
            ms.add(statusWithCount);
        }
    }

    private IStatus getLastRetrievalStatus() {
        int i = this.seen.size() - 1;
        while (i >= 0) {
            IStatus status;
            Object obj = this.seen.get(i);
            if (obj instanceof ResumeableDownload.Retrieved) {
                ResumeableDownload.Retrieved r = (ResumeableDownload.Retrieved)obj;
                return r.getTotalStatus();
            }
            if (obj instanceof IStatus && (status = (IStatus)obj).matches(8)) {
                return status;
            }
            --i;
        }
        return null;
    }

    private static boolean isEqual(Object a, Object b) {
        if (a instanceof IStatus) {
            IStatus statusA = (IStatus)a;
            if (b instanceof IStatus) {
                IStatus statusB = (IStatus)b;
                return ResumableDownloadSummaryStatus.isEqualStatus(statusA, statusB);
            }
            return false;
        }
        if (a instanceof ResumeableDownload.Retrieved) {
            ResumeableDownload.Retrieved retrievedA = (ResumeableDownload.Retrieved)a;
            if (b instanceof ResumeableDownload.Retrieved) {
                ResumeableDownload.Retrieved retrievedB = (ResumeableDownload.Retrieved)b;
                return ResumableDownloadSummaryStatus.isEqualRetrieved(retrievedA, retrievedB);
            }
        }
        return false;
    }

    private static boolean isEqualRetrieved(ResumeableDownload.Retrieved a, ResumeableDownload.Retrieved b) {
        return ResumableDownloadSummaryStatus.isEqualStatus(a.getTotalStatus(), b.getTotalStatus());
    }

    private static boolean isEqualStatus(IStatus a, IStatus b) {
        return MultiStatusUtil.isDeepEqualStatus(STATUS_EQUAL_OP, a, b);
    }

    private static boolean isEqualException(Throwable a, Throwable b) {
        if (a == b) {
            return true;
        }
        if (a != null && b != null) {
            if (a.getClass() != b.getClass()) {
                return false;
            }
            if (a instanceof DownloadPrematureEOFException) {
                DownloadPrematureEOFException eofA = (DownloadPrematureEOFException)a;
                DownloadPrematureEOFException eofB = (DownloadPrematureEOFException)b;
                return eofA.getReasons() == eofB.getReasons();
            }
            return a.toString().equals(b.toString());
        }
        return false;
    }

    public static class CountStatus
    extends AbstractWrappedStatus
    implements ICountStatus {
        private final Integer count;

        public CountStatus(IStatus status, Integer count, String message) {
            super(status, message);
            this.count = count;
        }

        @Override
        public Integer getCount() {
            return this.count;
        }

        public String toString() {
            String format = "Encountered {0} times: {1}";
            return NLS.bind(format, (Object)this.count, (Object)this.getWrappedStatus().getMessage());
        }
    }

    public static interface ICountStatus
    extends IWrappedStatus {
        public Integer getCount();
    }

    public static class IntermediateProblemStatus
    extends AbstractWrappedStatus
    implements IDownloaded.IIntermediateProblemStatus {
        private final int severity;

        public IntermediateProblemStatus(IStatus status, int severity, String message) {
            super(status, message);
            this.severity = severity;
        }

        @Override
        public int getSeverity() {
            return this.severity;
        }

        public String toString() {
            String format = "Intermediate {0}: {1}";
            return NLS.bind(format, (Object)ResumableDownloadSummaryStatus.getMaxSeverityAsString(this), (Object)this.getWrappedStatus().getMessage());
        }
    }
}

