/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.downloads.AbstractHostInfo;
import com.ibm.cic.common.downloads.CredentialRequested;
import com.ibm.cic.common.downloads.CredentialTarget;
import com.ibm.cic.common.downloads.ProxyInfo;
import com.ibm.cic.common.downloads.ProxyProtocol;
import java.net.MalformedURLException;
import java.net.URL;

public class HostInfoCredentials {
    private static final String PROXY_REALM = "proxy";
    public static final String PROXY_AUTHSCHEME = "";
    private static final URL PROXY_DUMMY_URL = HostInfoCredentials.initDummyProxyURL();
    private static final URL HOST_DUMMY_URL = HostInfoCredentials.initDummyHostURL();

    private static URL initDummyProxyURL() {
        try {
            return new URL("http://com.ibm.cic.common.core.ProxyCredentials");
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
    }

    private static URL initDummyHostURL() {
        try {
            return new URL("http://com.ibm.cic.common.core.ProxyCredentials");
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
    }

    private static String getProxyRealm(String scheme, String host, int port) {
        StringBuffer sb = new StringBuffer();
        sb.append(scheme);
        sb.append("://");
        sb.append(host);
        sb.append(':');
        sb.append(port);
        sb.append('/');
        sb.append(PROXY_REALM);
        return sb.toString();
    }

    private static String getHostRealm(String host, int port, String realm) {
        StringBuffer sb = new StringBuffer();
        sb.append(host);
        sb.append(':');
        sb.append(port);
        sb.append('/');
        sb.append(realm);
        return sb.toString();
    }

    public static boolean isSocksProxyRealm(String realm) {
        return realm.startsWith(ProxyProtocol.SOCKS.getKey());
    }

    public static CredentialTarget getCredentialTargetForProxyRequest(CredentialRequested requested) {
        String proxyRealm = HostInfoCredentials.getProxyRealm(requested.getScheme(), requested.getHost(), requested.getPort());
        CredentialTarget ct = new CredentialTarget(PROXY_DUMMY_URL, proxyRealm, PROXY_AUTHSCHEME);
        return ct;
    }

    public static CredentialTarget getCredentialTargetForHostRequest(CredentialRequested requested) {
        String hostRealm = HostInfoCredentials.getHostRealm(requested.getHost(), requested.getPort(), requested.getRealm());
        CredentialTarget ct = new CredentialTarget(HOST_DUMMY_URL, hostRealm, requested.getScheme());
        return ct;
    }

    public static CredentialTarget getCredentialTargetForHostRequest1003(CredentialRequested requested) {
        StringBuffer buf = new StringBuffer("http://" + requested.getHost());
        if (requested.getPort() != -1) {
            buf.append(':');
            buf.append(String.valueOf(requested.getPort()));
        }
        try {
            URL url = new URL(buf.toString());
            return new CredentialTarget(url, requested.getRealm(), requested.getScheme());
        }
        catch (MalformedURLException e) {
            throw new AssertionError();
        }
    }

    public static CredentialTarget getCredentialTargetForProxyRequest1003(AbstractHostInfo hostInfo, CredentialRequested requested) {
        return new CredentialTarget(PROXY_DUMMY_URL, HostInfoCredentials.getProxyRealm1003(hostInfo), PROXY_AUTHSCHEME);
    }

    private static String getProxyRealm1003(AbstractHostInfo hostInfo) {
        ProxyInfo pinfo;
        String protocol = "http";
        if (hostInfo instanceof ProxyInfo && (pinfo = (ProxyInfo)hostInfo).useSocks()) {
            protocol = "SOCKS";
        }
        return new StringBuffer().append(protocol).append("://").append(hostInfo.getHost()).append(':').append(hostInfo.getPort()).append('/').append(PROXY_REALM).toString();
    }
}

