/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.downloads;

import com.ibm.cic.common.core.internal.ComIbmCicCommonCorePlugin;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.digest.RepositoryDigest;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.IStatusCodes;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.downloads.FileCacheManager;
import com.ibm.cic.common.downloads.IDownloader;
import com.ibm.cic.common.downloads.IFileContentInfo;
import java.io.File;
import java.util.Date;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class FileCacheInfo
implements IStatusCodes {
    private final IFileContentInfo m_remoteFileContentInfo;
    private boolean m_shouldBeCached;
    private File m_tmpLocalFile = null;
    private Date m_lastAccessTime = null;
    private RepositoryDigest m_repDigest = null;
    private IStatus m_status = Status.OK_STATUS;

    public FileCacheInfo(IFileContentInfo fileContentInfo, boolean a_useTimeout, IDownloader downloader, IProgressMonitor progressMonitor) {
        this.m_remoteFileContentInfo = fileContentInfo;
        try {
            this.m_shouldBeCached = downloader.locationShouldBeCached(this.m_remoteFileContentInfo.getFileLocation());
            if (this.m_shouldBeCached) {
                this.m_tmpLocalFile = TempUtil.createTempFile("FCM_" + fileContentInfo.getFileName().getFileName(), "");
                this.m_status = downloader.downloadToFile(fileContentInfo, this.m_tmpLocalFile, progressMonitor);
                if (a_useTimeout) {
                    this.setTimeout();
                }
            } else {
                this.m_tmpLocalFile = FileURLUtil.locationToFile(fileContentInfo.getFileLocation().toString());
            }
        }
        catch (CoreException e) {
            this.m_status = e.getStatus();
        }
        catch (Exception e) {
            this.m_status = new Status(4, ComIbmCicCommonCorePlugin.getPluginId(), 0, "", (Throwable)e);
        }
        if (!this.m_status.isOK()) {
            FileCacheManager.log.debug("Bad status creating FileCacheInfo {0}", this.m_status);
            this.delete();
            this.m_tmpLocalFile = null;
        }
    }

    boolean shouldBeCached() {
        return this.m_shouldBeCached;
    }

    public ICicLocation getRemotePath() {
        return this.m_remoteFileContentInfo.getFileLocation();
    }

    public boolean timeoutExpired(long timeOut) {
        if (!this.hasTimeoutSet()) {
            return false;
        }
        Date currentTime = new Date();
        return timeOut < currentTime.getTime() - this.m_lastAccessTime.getTime();
    }

    public boolean hasTimeoutSet() {
        return this.m_lastAccessTime != null;
    }

    public void setTimeout() {
        this.m_lastAccessTime = new Date();
    }

    public IStatus getStatus() {
        return this.m_status;
    }

    public File getFile() {
        return this.m_tmpLocalFile;
    }

    public void delete() {
        if (this.shouldBeCached() && !FileUtil.delete(this.m_tmpLocalFile)) {
            FileCacheManager.log.warning("Can't delete temp file {0}", this.m_tmpLocalFile);
        }
    }

    public String toString() {
        StringBuffer buf = new StringBuffer();
        if (this.m_remoteFileContentInfo != null) {
            buf.append(this.m_remoteFileContentInfo.getFileLocation().toString());
        } else {
            buf.append("null");
        }
        buf.append(" ->");
        if (this.m_tmpLocalFile != null) {
            buf.append(this.m_tmpLocalFile.getAbsolutePath());
        } else {
            buf.append("null");
        }
        if (this.hasTimeoutSet()) {
            buf.append(this.m_lastAccessTime.toString());
        } else {
            buf.append(" NoTimeout");
        }
        buf.append(this.m_status.toString());
        return buf.toString();
    }

    public IFileContentInfo getRemoteFileInfo() {
        return this.m_remoteFileContentInfo;
    }

    public RepositoryDigest getRepDigest() {
        return this.m_repDigest;
    }

    public void setRepDigest(RepositoryDigest repDig) {
        this.m_repDigest = repDig;
    }
}

