/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.artifactrepo;

import com.ibm.cic.common.core.artifactrepo.impl.AbstractArtifactLocator;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.URLContentLocator;
import com.ibm.cic.common.core.utils.FileURLUtil;
import com.ibm.cic.common.core.utils.UserNames;
import com.ibm.cic.common.downloads.DownloadHandler;
import com.ibm.cic.common.downloads.DownloadRetryLevel;
import com.ibm.cic.common.downloads.IContentInfo;
import com.ibm.cic.common.downloads.IDownloadSession;
import com.ibm.cic.common.downloads.IDownloadedFile;
import com.ibm.cic.common.downloads.ITransferMonitor;
import com.ibm.cic.common.downloads.ResumableDownloadProgress;
import com.ibm.cic.common.downloads.TransferManager;
import java.io.File;
import java.net.URL;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;

public class URLRemoteArtifactLocator
extends AbstractArtifactLocator {
    private final URL url;

    public URLRemoteArtifactLocator(IRepository artifactRepo, URL url, IArtifact artifact, IContentInfo contentInfo) {
        super(artifactRepo, artifact, contentInfo);
        this.url = url;
    }

    @Override
    public UserNames getUserNames() {
        return new UserNames(this.getLogicalName(), this.url.toString());
    }

    @Override
    public IStatus validateExists(int severity, IProgressMonitor monitor) {
        return URLContentLocator.validateURLExists(severity, this.getArtifactRepository().getUserNames(), this, this.url, monitor);
    }

    public URL getWebURL() {
        return this.url;
    }

    @Override
    public File revealFile() {
        File file = FileURLUtil.toFile(this.url);
        return file;
    }

    @Override
    protected DownloadRetryLevel retryLevel(Exception exception) {
        DownloadHandler handler = TransferManager.INSTANCE.getHandler(this.url.getProtocol());
        if (handler == null) {
            return super.retryLevel(exception);
        }
        return handler.retryLevel(exception);
    }

    @Override
    protected IDownloadedFile doDownloadToFileNoValidationNoResumeRetry(IDownloadSession session, IPath destinationLocation, ITransferMonitor transferPerformance, ResumableDownloadProgress.IResumableDownloadProgress progress, long[] outReadBytes) {
        return URLContentLocator.downloadToFileNoValidationNoResumeRetry(this, session, this.url, destinationLocation, transferPerformance, progress, outReadBytes);
    }

    @Override
    public String toString() {
        String s = super.toString();
        return String.valueOf(s) + " at " + this.url.toString();
    }
}

