/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.internal.artifactrepo;

import com.ibm.cic.common.core.internal.volrepo.DiskMounter;
import com.ibm.cic.common.core.repository.CicFileLocation;
import com.ibm.cic.common.core.volrepo.DiskTagFile;
import com.ibm.cic.common.core.volrepo.VolumeBase;
import com.ibm.cic.common.logging.Logger;
import java.io.File;
import org.eclipse.core.runtime.CoreException;

public class ScanForDiskUtil {
    private static final Logger log = Logger.getLogger(ScanForDiskUtil.class);

    private ScanForDiskUtil() {
    }

    public static DiskMounter findOfferingThenDiskFolder(File dir, String wantedDiskSetId, int wantedDiskNumber) {
        String[] names = dir.list();
        if (names == null) {
            log.debug("dir.list() returns no files for dir ''{0}''", dir);
            return null;
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            String name = stringArray[n2];
            File f = new File(dir, name);
            if (!f.isDirectory()) {
                log.debug("Skipping ''{0}'': not a directory", name);
            } else {
                log.debug("Scanning directory ''{0}''", f);
                DiskMounter disk = ScanForDiskUtil.findDiskFolder(f, wantedDiskSetId, wantedDiskNumber);
                if (disk != null) {
                    return disk;
                }
            }
            ++n2;
        }
        return null;
    }

    public static boolean isDiskFolderCandidate(File diskDir, String wantedDiskSetId, int wantedDiskNumber) {
        return ScanForDiskUtil.isDiskFolderCandidate(diskDir.getName(), wantedDiskSetId, wantedDiskNumber);
    }

    public static boolean isDiskFolderCandidate(String name, String wantedDiskSetId, int wantedDiskNumber) {
        String requiredName = VolumeBase.getDiskPathAsString(wantedDiskNumber);
        if (!requiredName.equals(name)) {
            log.debug("''{0}'': name is not ''{1}''", name, requiredName);
            return false;
        }
        return true;
    }

    public static DiskMounter findDiskFolder(File dir, String wantedDiskSetId, int wantedDiskNumber) {
        String[] names = dir.list();
        if (names == null) {
            log.debug("No entries found in ''{0}''", dir);
            return null;
        }
        String[] stringArray = names;
        int n = names.length;
        int n2 = 0;
        while (n2 < n) {
            block11: {
                String name = stringArray[n2];
                File f = new File(dir, name);
                if (!f.isDirectory()) {
                    log.debug("Skipping ''{0}'': not a directory", name);
                } else if (ScanForDiskUtil.isDiskFolderCandidate(name, wantedDiskSetId, wantedDiskNumber)) {
                    DiskMounter canMountDisk = null;
                    try {
                        boolean askForDisk = false;
                        String diskLabel = null;
                        canMountDisk = new DiskMounter(askForDisk, new CicFileLocation(f.toString()), diskLabel, wantedDiskSetId, wantedDiskNumber - 1);
                    }
                    catch (CoreException e) {
                        log.debug("Skipping ''{0}'': mount as disk failed", name);
                        if (log.isDebugLoggable()) {
                            log.status(e.getStatus());
                        }
                        break block11;
                    }
                    assert (canMountDisk != null);
                    DiskTagFile.DiskTagProperties foundProperties = canMountDisk.getMountedDisk().getDiskTagProperties();
                    String foundId = foundProperties.getProperty("diskSetId");
                    if (foundId == null) {
                        log.debug("Skipping ''{0}'': no disk set id found", name);
                    } else {
                        log.debug("Found ''{0}'': disk {1} of disk set id {1}.", f.toString(), foundProperties.getDiskNumber(), foundId);
                        return canMountDisk;
                    }
                }
            }
            ++n2;
        }
        return null;
    }
}

