/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.cmd;

import com.ibm.cic.common.core.cmd.ACmdParam;
import com.ibm.cic.common.core.cmd.CmdIterator;
import com.ibm.cic.common.core.internal.Messages;
import com.ibm.cic.common.core.utils.Statuses;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;

public class CmdParamPackage
extends ACmdParam {
    private static final String VERSION_SEP = "_";
    private static final String FEATURE_SEP = ",";
    private static final Pattern PATTERN = Pattern.compile("(.+?)(?:_(\\d+(?:\\.\\d+(?:\\.\\d+(?:\\.[-_a-zA-Z0-9]*)?)?)?))?(?:,(.*))?$");
    private IdVersionFeatures value;

    public CmdParamPackage(String id, String header) {
        super(id, header);
    }

    @Override
    public CmdParamPackage makeCopy() {
        assert (this.value == null);
        return new CmdParamPackage(this.id(), this.getHeader());
    }

    @Override
    public Object getObjVal() {
        return this.value;
    }

    @Override
    public String getStrVal() {
        return this.value == null ? null : this.value.toString();
    }

    @Override
    protected IStatus loadCommandLineData(CmdIterator cmdData, boolean testOnly) {
        String arg = cmdData.getCurrentArg();
        if (!testOnly) {
            cmdData.consumeCurrentArg();
        }
        this.value = IdVersionFeatures.parse(arg);
        if (this.value == null) {
            return Statuses.ERROR.get(8009, Messages.Cmd_Error_Incorrect_Parameter_BadPackage, arg);
        }
        return Status.OK_STATUS;
    }

    public static class IdVersionFeatures {
        public final String id;
        public final String version;
        public final String features;

        public static IdVersionFeatures parse(String arg) {
            Matcher matcher = PATTERN.matcher(arg);
            if (!matcher.matches()) {
                return null;
            }
            return new IdVersionFeatures(matcher.group(1), matcher.group(2), matcher.group(3));
        }

        public IdVersionFeatures(String id, String version, String features) {
            this.id = id;
            this.version = version;
            this.features = features;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append(this.id);
            if (this.version != null) {
                sb.append(CmdParamPackage.VERSION_SEP).append(this.version);
            }
            if (this.features != null) {
                sb.append(CmdParamPackage.FEATURE_SEP).append(this.features);
            }
            return sb.toString();
        }
    }
}

