/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.auth;

import com.ibm.cic.common.core.auth.Messages;
import com.ibm.cic.common.core.auth.PasswordManager;
import com.ibm.cic.common.core.utils.Encodings;
import com.ibm.cic.common.core.utils.FileUtil;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.Util;
import com.ibm.cic.common.downloads.CredentialStore;
import java.io.File;
import java.io.IOException;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Map;
import java.util.Properties;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.preferences.ConfigurationScope;
import org.eclipse.core.runtime.preferences.IEclipsePreferences;
import org.eclipse.equinox.internal.security.storage.friends.InternalExchangeUtils;
import org.eclipse.equinox.security.storage.ISecurePreferences;
import org.eclipse.equinox.security.storage.SecurePreferencesFactory;
import org.eclipse.equinox.security.storage.StorageException;

public class AuthorizationInfoFromSecureStorage {
    private static final String ORG_ECLIPSE_EQUINOX_SECURITY_PREFERENCES = "org.eclipse.equinox.security.preferences.";
    private static Hashtable<String, Hashtable> authorizationInfo = new Hashtable(5);
    public static final String KEY_PERSIST = "persist";
    public static final String KEY_USER_ID = "uid";
    public static final String KEY_DOMAIN = "domain";
    public static final String KEY_PWD = "pwd";

    private static String getNodeKey(URL url, String host_realm, String authScheme) {
        StringBuffer buf = new StringBuffer();
        if (!host_realm.equals("")) {
            String[] splits = host_realm.split("/");
            buf.append(splits[0]);
            if (splits.length > 1 && !splits[1].isEmpty()) {
                buf.append('/').append(splits[1]);
            }
        } else {
            String path;
            buf.append(url.getHost());
            int port = url.getPort();
            if (port != -1) {
                buf.append(":");
                buf.append(port);
            }
            if (!(path = url.getPath()).equals("")) {
                buf.append("/");
                buf.append(path);
            }
        }
        if (!authScheme.equals("")) {
            buf.append("/");
            buf.append(authScheme.toLowerCase());
        }
        return buf.toString();
    }

    public static synchronized Map getAuthorizationInfo(URL url, String realm, String authScheme) {
        Hashtable authSchemeToInfo;
        Map<String, String> result = null;
        Hashtable realmToAuthScheme = authorizationInfo.get(url.toString());
        if (realmToAuthScheme != null && (authSchemeToInfo = (Hashtable)realmToAuthScheme.get(realm)) != null) {
            result = (Map)authSchemeToInfo.get(authScheme.toLowerCase());
        }
        if (result == null) {
            result = new HashMap();
            ISecurePreferences root = SecurePreferencesFactory.getDefault();
            ISecurePreferences node = root.node(AuthorizationInfoFromSecureStorage.getNodeKey(url, realm, authScheme));
            String[] keys = node.keys();
            try {
                String[] stringArray = keys;
                int n = keys.length;
                int n2 = 0;
                while (n2 < n) {
                    String key = stringArray[n2];
                    String value = node.get(key, "");
                    if (!value.equals("")) {
                        result.put(key, value);
                    }
                    ++n2;
                }
            }
            catch (StorageException e) {
                result = null;
            }
            if (result != null) {
                if (result.isEmpty()) {
                    result = null;
                } else {
                    Hashtable authSchemeToInfo2;
                    realmToAuthScheme = authorizationInfo.get(url.toString());
                    if (realmToAuthScheme == null) {
                        realmToAuthScheme = new Hashtable(5);
                        authorizationInfo.put(url.toString(), realmToAuthScheme);
                    }
                    if ((authSchemeToInfo2 = (Hashtable)realmToAuthScheme.get(realm)) == null) {
                        authSchemeToInfo2 = new Hashtable(5);
                        realmToAuthScheme.put(realm, authSchemeToInfo2);
                    }
                    authSchemeToInfo2.put(authScheme.toLowerCase(), result);
                }
            }
        }
        return result;
    }

    public static synchronized void addAuthorizationInfo(URL url, String realm, String authScheme, Map info) throws StorageException {
        Hashtable<String, Map> authSchemeToInfo;
        Hashtable<String, Hashtable<String, Map>> realmToAuthScheme = authorizationInfo.get(url.toString());
        if (realmToAuthScheme == null) {
            realmToAuthScheme = new Hashtable<String, Hashtable<String, Map>>(5);
            authorizationInfo.put(url.toString(), realmToAuthScheme);
        }
        if ((authSchemeToInfo = (Hashtable<String, Map>)realmToAuthScheme.get(realm)) == null) {
            authSchemeToInfo = new Hashtable<String, Map>(5);
            realmToAuthScheme.put(realm, authSchemeToInfo);
        }
        authSchemeToInfo.put(authScheme.toLowerCase(), info);
        ISecurePreferences root = SecurePreferencesFactory.getDefault();
        ISecurePreferences node = root.node(AuthorizationInfoFromSecureStorage.getNodeKey(url, realm, authScheme));
        for (Map.Entry entry : info.entrySet()) {
            node.put((String)entry.getKey(), entry.getValue().toString(), true);
        }
        PasswordManager.INSTANCE.savePasswordUsage();
        try {
            root.flush();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static synchronized void flushAuthorizationInfo(URL serverUrl, String realm, String authScheme) throws CoreException {
        SecurePreferencesFactory.getDefault().node(AuthorizationInfoFromSecureStorage.getNodeKey(serverUrl, realm, authScheme)).clear();
        authorizationInfo.remove(serverUrl.toString());
    }

    public static File getStorageFile() {
        File f = null;
        URL url = InternalExchangeUtils.defaultStorageLocation();
        try {
            f = new File(url.toURI());
        }
        catch (URISyntaxException e) {
            f = new File(url.getPath());
        }
        return f;
    }

    public static void setSecureStoragePreferences() {
        String securityAlgorithm = Util.getSecurityAlgorihm();
        IEclipsePreferences eclipseNode = ConfigurationScope.INSTANCE.getNode("org.eclipse.equinox.security");
        if (eclipseNode == null) {
            throw new IllegalStateException(Messages.AuthorizationInfo_UnableToSetEncryption);
        }
        eclipseNode.put("org.eclipse.equinox.security.preferences.cipher", securityAlgorithm);
        eclipseNode.put("org.eclipse.equinox.security.preferences.keyFactory", securityAlgorithm);
    }

    public static void flushStorageFile() throws IOException {
        SecurePreferencesFactory.getDefault().flush();
    }

    public static void deleteStorage() {
        CredentialStore.INSTANCE.removeAllCredentials();
        File storageFile = AuthorizationInfoFromSecureStorage.getStorageFile();
        if (storageFile.exists()) {
            storageFile.delete();
        }
        AuthorizationInfoFromSecureStorage.clearCache();
    }

    public static void clearCache() {
        ISecurePreferences defaultStorage = SecurePreferencesFactory.getDefault();
        defaultStorage.clear();
        defaultStorage.removeNode();
        InternalExchangeUtils.defaultStorageDelete();
        authorizationInfo.clear();
    }

    public static IStatus verifySecureStorageFile(boolean isInteractiveMode) {
        IStatus result = Status.OK_STATUS;
        File f = AuthorizationInfoFromSecureStorage.getStorageFile();
        if (f.exists()) {
            try {
                boolean foundNonCapilanoProvider = false;
                int encryptedEntriesCount = 0;
                Properties props = FileUtil.readProperties(f);
                for (Map.Entry<Object, Object> entry : props.entrySet()) {
                    String key = entry.getKey().toString();
                    String value = entry.getValue().toString();
                    if (key.startsWith(ORG_ECLIPSE_EQUINOX_SECURITY_PREFERENCES)) continue;
                    ++encryptedEntriesCount;
                    if (value.startsWith("com.ibm.cic.security.storage.capilanopasswordprovider")) continue;
                    foundNonCapilanoProvider = true;
                    break;
                }
                if (encryptedEntriesCount > 0 && foundNonCapilanoProvider) {
                    result = isInteractiveMode ? Statuses.ERROR.get(Messages.AuthorizationInfo_OldSecureStorageFile_InteractiveMode, f.getAbsolutePath()) : Statuses.ERROR.get(Messages.AuthorizationInfo_OldSecureStorageFile, f.getAbsolutePath());
                }
            }
            catch (IOException e) {
                result = Statuses.ERROR.get(e, Messages.AuthorizationInfo_UnableToReadStorageFile, f.getAbsolutePath());
            }
        }
        return result;
    }

    public static IStatus verifyMasterPasswordFile(String filepath) {
        IStatus result = Status.OK_STATUS;
        if (filepath == null) {
            result = Statuses.ERROR.get(Messages.AuthorizationInfo_incorrect_master_password_value, new Object[0]);
        } else {
            try {
                File file = new File(filepath);
                if (!file.exists()) {
                    result = Statuses.ERROR.get(Messages.AuthorizationInfo_master_password_file_dont_exist, new Object[0]);
                } else {
                    String contents = Encodings.UTF8.read(file);
                    if (contents.trim().isEmpty()) {
                        result = Statuses.ERROR.get(Messages.AuthorizationInfo_empty_master_password_file, new Object[0]);
                    }
                }
            }
            catch (IOException e) {
                result = Statuses.ERROR.get(e, Messages.AuthorizationInfo_cant_read_master_password_file, new Object[0]);
            }
        }
        return result;
    }
}

