/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.impl;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractContentLocator;
import com.ibm.cic.common.core.artifactrepo.impl.ArtifactToPathUtil;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.utils.PathUtil;
import com.ibm.cic.common.core.utils.TempUtil;
import com.ibm.cic.common.downloads.DownloadInProgressManager;
import com.ibm.cic.common.downloads.IContentInfo;
import java.io.File;
import org.eclipse.core.runtime.IPath;

public abstract class AbstractArtifactLocator
extends AbstractContentLocator
implements IArtifactLocator {
    private final IRepository artifactRepoInstance;
    private IArtifact artifact;

    public AbstractArtifactLocator(IRepository artifactRepoInstance, IArtifact artifact, IContentInfo expectedContentInfo) {
        super(artifact.getContentInfo(), expectedContentInfo);
        this.artifactRepoInstance = artifactRepoInstance;
        this.artifact = artifact;
    }

    @Override
    public IArtifact getArtifact() {
        return this.artifact;
    }

    @Override
    public IArtifactKey getArtifactKey() {
        return this.artifact.getKey();
    }

    public String getLogicalName() {
        return this.artifact.toUserString();
    }

    @Override
    public IRepository getArtifactRepository() {
        return this.artifactRepoInstance;
    }

    @Override
    public IRepository getArtifactWriteRepository() {
        return this.artifactRepoInstance;
    }

    protected void setArtifact(IArtifact artifact) {
        this.artifact = artifact;
    }

    @Override
    protected String getResumeableDownloadId(IPath destination) {
        IPath path = ArtifactToPathUtil.getArtifactPath(this.artifact);
        String flattened = PathUtil.flatten(path, '_');
        String defaultId = this.artifact.getKey().getId().getId();
        if (defaultId == null) {
            defaultId = "";
        }
        String resumeableDownloadId = this.calcHashNameResumeableId(flattened, defaultId);
        return resumeableDownloadId;
    }

    @Override
    protected DownloadInProgressManager.NonValidatedDownload createNonValidatedDownloadRequest(TempUtil.UniqueTempDir dipRoot, IPath destination) {
        DownloadInProgressManager dipm = DownloadInProgressManager.INSTANCE;
        IArtifactKey key = this.getArtifactKey();
        IPath inProgressPath = DownloadInProgressManager.getNonValidatedArtifactDir(dipRoot.getUniqueTempDir()).append(this.getResumeableDownloadId(destination));
        DownloadInProgressManager.NonValidatedDownload nrd = dipm.getNonValidatedDownload(key, dipRoot, inProgressPath, destination);
        return nrd;
    }

    @Override
    public File revealFile() {
        return null;
    }

    public String toString() {
        return this.artifact.toString();
    }
}

