/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.base;

import com.ibm.cic.common.core.artifactrepo.IArtifactLocator;
import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IContentLocator;
import com.ibm.cic.common.core.artifactrepo.base.AddArtifacts;
import com.ibm.cic.common.core.artifactrepo.base.AddMultiThreadArtifacts;
import com.ibm.cic.common.core.artifactrepo.base.ArtifactsByDiskOperation;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperationMultiple;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.AbstractDiskOperation;
import com.ibm.cic.common.core.artifactrepo.impl.IVolumeAccessByDisk;
import com.ibm.cic.common.core.artifactrepo.impl.Messages;
import com.ibm.cic.common.core.artifactrepo.impl.RepoAs;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.ICicLocation;
import com.ibm.cic.common.core.repository.IRepository;
import com.ibm.cic.common.core.repository.StatusCodes;
import com.ibm.cic.common.core.utils.CicMultiStatus;
import com.ibm.cic.common.core.utils.SplitProgressMonitor;
import com.ibm.cic.common.core.utils.Statuses;
import com.ibm.cic.common.core.utils.UserOptions;
import com.ibm.cic.common.downloads.DownloadTrace;
import com.ibm.cic.common.downloads.TransferManager;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.SubProgressMonitor;

public class AddArtifactsByDisk
extends ArtifactsByDiskOperation {
    public static final IArtifactOperationMultiple INSTANCE = new AddArtifactsByDisk();
    public static final Comparator SORT_BY_DECREASING_DOWNLOAD_SIZE = new DecreasingDownloadSizeComparator();

    protected AddArtifactsByDisk() {
        super(true);
    }

    public static IArtifactOperation.IArtifactOperationInput createGetRequest(IArtifact artifact, IContentLocator locator) {
        return new AddArtifacts.AddInput(artifact, locator);
    }

    @Override
    protected void doExecute(IArtifactSession session, IArtifactOperation.IOperationContext target, IMultiArtifactOperationArguments args, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        if (!(target instanceof AddGroupedContext)) {
            throw new IllegalArgumentException();
        }
        AddGroupedContext context = (AddGroupedContext)target;
        if (context.getSource() == null) {
            throw new IllegalArgumentException();
        }
        if (context.getTarget() == null) {
            throw new IllegalArgumentException();
        }
        AddArtifactsOnDisk diskOperation = new AddArtifactsOnDisk(this, context);
        super.doExecuteDiskOperation(session, diskOperation, target, args, options, monitor);
    }

    private static class AddArtifactsOnDisk
    extends AbstractDiskOperation
    implements IVolumeAccessByDisk.IDiskOperation {
        private final AddGroupedContext context;

        AddArtifactsOnDisk(IArtifactOperationMultiple op, AddGroupedContext context) {
            super(op);
            this.context = context;
        }

        @Override
        public CicMultiStatus getMultiStatus() {
            String msg = Messages.add_artifacts_failed;
            return Statuses.ST.createMultiStatus(15, msg, new Object[0]);
        }

        @Override
        public IArtifact getArtifact(IArtifactOperation.IArtifactOperationRecord record) {
            return AddArtifacts.getAddInputArtifact(record);
        }

        private IContentLocator getContentLocator(IArtifactOperation.IArtifactOperationRecord record) {
            return AddArtifacts.getAddInput(record).getLocator();
        }

        @Override
        public IRepository getSourceRepo(IArtifactOperation.IOperationContext ctxt) {
            return ((AddGroupedContext)ctxt).getSource();
        }

        @Override
        public IArtifactOperation.IOperationContext getSubContext(IRepository repo) {
            return new AddGroupedContext(repo, this.context.getTarget());
        }

        private int getNumThreads() {
            if (!UserOptions.isAddThreads()) {
                return 0;
            }
            IRepository source = this.context.getSource();
            IVolumeAccessByDisk byDisk = RepoAs.IVolumeAccessByDisk(source);
            if (byDisk != null) {
                return 0;
            }
            ICicLocation location = source.getLocation();
            URL url = location.toURL();
            if (!TransferManager.INSTANCE.shouldUseMultipleThreads(url)) {
                return 0;
            }
            int n = UserOptions.getAddThreads();
            return n;
        }

        @Override
        public IStatus useDisk(IArtifactSession session, IRepository repo, IVolumeAccessByDisk.IDisk disk, IVolumeAccessByDisk.IDiskSetDisks allUsedDisks, IMultiArtifactOperationArguments diskArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
            IMultiArtifactOperationArguments simpleAddArgs = AddArtifacts.INSTANCE.createArguments();
            int n = diskArgs.getRecordCount();
            MultiArtifactOperationOptions.ProcessRecordListener fireEvents = options.getFireEvents();
            fireEvents.onBeforeUseDisk(repo, disk, allUsedDisks, diskArgs);
            SplitProgressMonitor spm = new SplitProgressMonitor(monitor, new int[]{1 * n, 9 * n});
            try {
                int nThreads = this.getNumThreads();
                DownloadTrace.traceThreads.debug("Using {0} threads to add {1} artifacts from {2} to {3}", nThreads, diskArgs.getRecordCount(), this.context.getSource().getLocation(), this.context.getTarget().getLocation());
                if (nThreads == 0) {
                    IStatus status = this.makeSimpleAddArgs(session, repo, diskArgs, simpleAddArgs, options, nThreads, spm.next());
                    if (status.matches(12)) {
                        IStatus iStatus = status;
                        return iStatus;
                    }
                    AddArtifacts.INSTANCE.execute(session, AddArtifacts.createOperationTarget(this.context.getTarget()), options, simpleAddArgs, spm.next());
                } else {
                    AddMultiThreadArtifacts artifacts = new AddMultiThreadArtifacts(nThreads);
                    IStatus status = this.makeSimpleAddArgs(session, repo, diskArgs, simpleAddArgs, options, nThreads, spm.next());
                    if (status.matches(12)) {
                        IStatus iStatus = status;
                        return iStatus;
                    }
                    artifacts.execute(session, AddArtifacts.createOperationTarget(this.context.getTarget()), options, simpleAddArgs, spm.next());
                }
                IStatus iStatus = simpleAddArgs.getFailedOperationStatus();
                return iStatus;
            }
            finally {
                fireEvents.onUsedDisk(repo, disk, allUsedDisks, diskArgs);
                spm.done();
            }
        }

        private IStatus makeSimpleAddArgs(IArtifactSession session, IRepository repo, IMultiArtifactOperationArguments diskArgs, IMultiArtifactOperationArguments simpleAddArgs, MultiArtifactOperationOptions options, int nThreads, IProgressMonitor locateMonitor) {
            int n = diskArgs.getRecordCount();
            locateMonitor.beginTask("", n);
            ArrayList<IArtifactOperation.IArtifactOperationRecord> foundRecords = new ArrayList<IArtifactOperation.IArtifactOperationRecord>(n);
            for (IArtifactOperation.IArtifactOperationRecord record : diskArgs.getRecords()) {
                IArtifact artifact = this.getArtifact(record);
                IContentLocator locator = this.getContentLocator(record);
                if (locator == null) {
                    IArtifactLocator[] refLocator = new IArtifactLocator[1];
                    IStatus status = RepoAs.IArtifactGet(repo).getArtifactLocator(session, artifact, (IProgressMonitor)new SubProgressMonitor(locateMonitor, 1), refLocator);
                    if (StatusCodes.isContentNotFound(status)) {
                        status = StatusCodes.recodeNotFoundToSeverity(status, 4);
                        record.getHistory().setHistoryStatus(session, status);
                        if (options.getContinueOnError()) continue;
                        return status;
                    }
                    if (status.matches(4)) {
                        record.getHistory().setHistoryStatus(session, status);
                        if (options.getContinueOnError()) continue;
                        return status;
                    }
                    if (status.matches(8)) {
                        diskArgs.setFailedOperationStatus(status);
                        return status;
                    }
                    locator = refLocator[0];
                    AddArtifacts.AddInput addInput = AddArtifacts.getAddInput(record);
                    addInput.setLocator(refLocator[0]);
                } else {
                    locateMonitor.worked(1);
                }
                foundRecords.add(record);
            }
            if (options.getProcessingOrder().equals(MultiArtifactOperationOptions.ArgumentProcessingOrder.OPTIMIZE_TIME) && RepoAs.IVolumeAccessByDisk(this.context.getSource()) == null && nThreads != 0) {
                Collections.sort(foundRecords, SORT_BY_DECREASING_DOWNLOAD_SIZE);
            }
            simpleAddArgs.addRecords(foundRecords);
            locateMonitor.done();
            return Status.OK_STATUS;
        }
    }

    public static class AddGroupedContext
    extends IArtifactOperation.AbstractOperationContext {
        private final IRepository source;
        private final IRepository target;

        public AddGroupedContext(IRepository source, IRepository target) {
            this.source = source;
            this.target = target;
        }

        IRepository getSource() {
            return this.source;
        }

        IRepository getTarget() {
            return this.target;
        }

        @Override
        public void release() {
        }
    }

    private static class DecreasingDownloadSizeComparator
    implements Comparator {
        private DecreasingDownloadSizeComparator() {
        }

        public int compare(Object o1, Object o2) {
            IArtifactOperation.IArtifactOperationRecord a1 = (IArtifactOperation.IArtifactOperationRecord)o1;
            IArtifactOperation.IArtifactOperationRecord a2 = (IArtifactOperation.IArtifactOperationRecord)o2;
            long s1 = AddArtifacts.getAddInputArtifactDownloadSize(a1);
            long s2 = AddArtifacts.getAddInputArtifactDownloadSize(a2);
            if (s1 == Long.MIN_VALUE && s2 == Long.MIN_VALUE) {
                return 0;
            }
            if (s1 == Long.MIN_VALUE) {
                return 1;
            }
            if (s2 == Long.MIN_VALUE) {
                return -1;
            }
            long l = s2 - s1;
            return l > 0L ? 2 : (l < 0L ? -2 : 0);
        }
    }
}

