/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.artifactrepo.base;

import com.ibm.cic.common.core.artifactrepo.IArtifactSession;
import com.ibm.cic.common.core.artifactrepo.IReadArtifactRepo;
import com.ibm.cic.common.core.artifactrepo.base.ArtifactOperationMultiple;
import com.ibm.cic.common.core.artifactrepo.base.IArtifactOperation;
import com.ibm.cic.common.core.artifactrepo.base.IMultiArtifactOperationArguments;
import com.ibm.cic.common.core.artifactrepo.base.MultiArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.base.SingleArtifactOperationOptions;
import com.ibm.cic.common.core.artifactrepo.impl.IArtifactTocUpdate;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.repository.ArcRepositoryAdapter;
import java.io.IOException;
import java.util.ArrayList;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.SubProgressMonitor;

abstract class AbstractModifyArtifactsAndUpdateToc
extends ArtifactOperationMultiple {
    protected AbstractModifyArtifactsAndUpdateToc(boolean supportsSuspendResume) {
        super(supportsSuspendResume);
    }

    public static IArtifactOperation.IOperationContext createOperationTarget(IReadArtifactRepo repo) {
        return new Context(repo);
    }

    @Override
    protected void doExecute(IArtifactSession session, IArtifactOperation.IOperationContext target, IMultiArtifactOperationArguments multiArgs, MultiArtifactOperationOptions options, IProgressMonitor monitor) {
        block39: {
            Object onBeforeObj;
            boolean needsTocUpdate;
            IReadArtifactRepo repo;
            Context getTarget;
            block38: {
                block37: {
                    if (!(target instanceof Context)) {
                        throw new IllegalArgumentException();
                    }
                    getTarget = (Context)target;
                    repo = getTarget.getRepo();
                    needsTocUpdate = false;
                    onBeforeObj = null;
                    try {
                        onBeforeObj = this.onBeforeExecute(session, repo, options);
                        break block37;
                    }
                    catch (CoreException e) {
                        multiArgs.setFailedOperationStatus(e.getStatus());
                        try {
                            if (needsTocUpdate) {
                                int n = multiArgs.getRecords().size();
                                IArtifactOperation.IArtifactOperationRecord opRecord = multiArgs.getRecord(n - 1);
                                if (opRecord.getInput().getClass() != MarkUpdateTocInput.class) {
                                    throw new AssertionError();
                                }
                                ArrayList<IArtifact> listArtifacts = new ArrayList<IArtifact>(n);
                                IArtifactTocUpdate tocUpdate = (IArtifactTocUpdate)repo.getAdapter(IArtifactTocUpdate.class);
                                int i = 0;
                                while (i < n - 1) {
                                    IArtifact artifact;
                                    IArtifactOperation.IArtifactOperationRecord record = multiArgs.getRecord(i);
                                    if (this.isSuccessRecord(record) && (artifact = this.getArtifactForToc(record)) != null) {
                                        listArtifacts.add(artifact);
                                    }
                                    ++i;
                                }
                                IArtifact[] artifacts = listArtifacts.toArray(new IArtifact[listArtifacts.size()]);
                                IStatus status = this.doUpdateToc(tocUpdate, session, artifacts, (IProgressMonitor)new SubProgressMonitor(monitor, 0, 4));
                                opRecord.getHistory().setHistoryStatus(session, status);
                            }
                        }
                        finally {
                            this.onAfterExecute(session, repo, options, onBeforeObj);
                        }
                    }
                    return;
                }
                try {
                    if (repo == null) {
                        throw new IllegalArgumentException();
                    }
                    if (!options.getOperationFlags().matches(2)) break block38;
                    try {
                        if (repo.hasArtifactToc(session, (IProgressMonitor)new SubProgressMonitor(monitor, 0))) {
                            multiArgs.addInput(new MarkUpdateTocInput());
                            IArtifactTocUpdate tocUpdate = (IArtifactTocUpdate)repo.getAdapter(IArtifactTocUpdate.class);
                            if (tocUpdate == null) {
                                throw new AssertionError();
                            }
                            needsTocUpdate = true;
                        }
                        break block38;
                    }
                    catch (CoreException e) {
                        multiArgs.setFailedOperationStatus(e.getStatus());
                        try {
                            if (needsTocUpdate) {
                                int n = multiArgs.getRecords().size();
                                IArtifactOperation.IArtifactOperationRecord opRecord = multiArgs.getRecord(n - 1);
                                if (opRecord.getInput().getClass() != MarkUpdateTocInput.class) {
                                    throw new AssertionError();
                                }
                                ArrayList<IArtifact> listArtifacts = new ArrayList<IArtifact>(n);
                                IArtifactTocUpdate tocUpdate = (IArtifactTocUpdate)repo.getAdapter(IArtifactTocUpdate.class);
                                int i = 0;
                                while (i < n - 1) {
                                    IArtifact artifact;
                                    IArtifactOperation.IArtifactOperationRecord record = multiArgs.getRecord(i);
                                    if (this.isSuccessRecord(record) && (artifact = this.getArtifactForToc(record)) != null) {
                                        listArtifacts.add(artifact);
                                    }
                                    ++i;
                                }
                                IArtifact[] artifacts = listArtifacts.toArray(new IArtifact[listArtifacts.size()]);
                                IStatus status = this.doUpdateToc(tocUpdate, session, artifacts, (IProgressMonitor)new SubProgressMonitor(monitor, 0, 4));
                                opRecord.getHistory().setHistoryStatus(session, status);
                            }
                        }
                        finally {
                            this.onAfterExecute(session, repo, options, onBeforeObj);
                        }
                    }
                    return;
                }
                catch (Throwable throwable) {}
            }
            try {
                if (options.getOperationFlags().matches(1)) {
                    this.updateFiles(session, getTarget, multiArgs, options, repo, monitor);
                }
            }
            finally {
                try {
                    if (needsTocUpdate) {
                        int n = multiArgs.getRecords().size();
                        IArtifactOperation.IArtifactOperationRecord opRecord = multiArgs.getRecord(n - 1);
                        if (opRecord.getInput().getClass() != MarkUpdateTocInput.class) {
                            throw new AssertionError();
                        }
                        ArrayList<IArtifact> listArtifacts = new ArrayList<IArtifact>(n);
                        IArtifactTocUpdate tocUpdate = (IArtifactTocUpdate)repo.getAdapter(IArtifactTocUpdate.class);
                        int i = 0;
                        while (i < n - 1) {
                            IArtifact artifact;
                            IArtifactOperation.IArtifactOperationRecord record = multiArgs.getRecord(i);
                            if (this.isSuccessRecord(record) && (artifact = this.getArtifactForToc(record)) != null) {
                                listArtifacts.add(artifact);
                            }
                            ++i;
                        }
                        IArtifact[] artifacts = listArtifacts.toArray(new IArtifact[listArtifacts.size()]);
                        IStatus status = this.doUpdateToc(tocUpdate, session, artifacts, (IProgressMonitor)new SubProgressMonitor(monitor, 0, 4));
                        opRecord.getHistory().setHistoryStatus(session, status);
                    }
                    break block39;
                }
                finally {
                    this.onAfterExecute(session, repo, options, onBeforeObj);
                }
            }
            {
            }
        }
    }

    protected void updateFiles(IArtifactSession session, Context context, IMultiArtifactOperationArguments multiArgs, MultiArtifactOperationOptions options, IReadArtifactRepo repo, IProgressMonitor monitor) {
        boolean keepCopying = true;
        monitor.beginTask("", multiArgs.getRecords().size());
        try {
            for (IArtifactOperation.IArtifactOperationRecord dlRecord : multiArgs.getRecords()) {
                IStatus status = dlRecord.getLastStatus();
                if (status != IArtifactOperation.STATUS_OK_REQUESTED || !keepCopying || multiArgs.isCanceled()) continue;
                MultiArtifactOperationOptions.ProcessRecordListener fireRecordProcessing = options.getFireEvents();
                fireRecordProcessing.onBeforeRecord(options, dlRecord);
                boolean performed = this.doSingleRecord(context, repo, session, options.getSingleArtifactOptions(), dlRecord, (IProgressMonitor)new SubProgressMonitor(monitor, 1, 4));
                fireRecordProcessing.onProcessedRecord(options, multiArgs, dlRecord, performed);
                if (!performed) continue;
                IStatus dlStatus = dlRecord.getLastStatus();
                if (dlStatus.getSeverity() == 8) {
                    multiArgs.setCanceled();
                    continue;
                }
                boolean isError = dlStatus.matches(4);
                if (options.getContinueOnError() || !isError) continue;
                keepCopying = false;
            }
        }
        finally {
            monitor.done();
        }
    }

    protected Object onBeforeExecute(IArtifactSession session, IReadArtifactRepo repo, MultiArtifactOperationOptions options) throws CoreException {
        ArcRepositoryAdapter adapter = (ArcRepositoryAdapter)repo.getAdapter(ArcRepositoryAdapter.class);
        if (adapter != null) {
            try {
                adapter.getArcHandler().openToAddOrDeleteFiles();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return null;
    }

    protected void onAfterExecute(IArtifactSession session, IReadArtifactRepo repo, MultiArtifactOperationOptions options, Object onBeforeObject) {
        ArcRepositoryAdapter adapter = (ArcRepositoryAdapter)repo.getAdapter(ArcRepositoryAdapter.class);
        if (adapter != null) {
            adapter.getArcHandler().close();
        }
    }

    protected abstract IStatus doUpdateToc(IArtifactTocUpdate var1, IArtifactSession var2, IArtifact[] var3, IProgressMonitor var4);

    protected abstract boolean doSingleRecord(Context var1, IReadArtifactRepo var2, IArtifactSession var3, SingleArtifactOperationOptions var4, IArtifactOperation.IArtifactOperationRecord var5, IProgressMonitor var6);

    protected abstract boolean isSuccessRecord(IArtifactOperation.IArtifactOperationRecord var1);

    protected abstract IArtifact getArtifactForToc(IArtifactOperation.IArtifactOperationRecord var1);

    public static class Context
    extends IArtifactOperation.AbstractOperationContext {
        private final IReadArtifactRepo repo;

        public Context(IReadArtifactRepo repo) {
            this.repo = repo;
        }

        public IReadArtifactRepo getRepo() {
            return this.repo;
        }

        @Override
        public void release() {
        }
    }

    public static class MarkUpdateTocInput
    implements IArtifactOperation.IArtifactOperationInput {
        public String toString() {
            StringBuffer sb = new StringBuffer();
            sb.append("MarkUpdateTocInput");
            return sb.toString();
        }
    }
}

