/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.os400.utils;

import com.ibm.as400.access.AS400;
import com.ibm.as400.access.AS400Bin4;
import com.ibm.as400.access.AS400Text;
import com.ibm.as400.access.ProgramCall;
import com.ibm.as400.access.ProgramParameter;
import com.ibm.cic.common.logging.Logger;
import java.util.StringTokenizer;
import java.util.Vector;

public class CheckUserAuthorizations {
    private static final String S_SEPARATOR = ";";
    private static final String S_REQAUTHORITIES = "*ALLOBJ; *SECADM";
    private static final String S_USRFORMAT = "USRI0300";
    private static final String S_USRCMD = "/QSYS.LIB/QSYRUSRI.PGM";
    private static final String S_CURRENTUSRPRF = "*CURRENT";
    private static final String[] SPECIALAUTH = new String[]{"*ALLOBJ", "*SECADM", "*JOBCTL", "*SPLCTL", "*SAVSYS", "*SERVICE", "*AUDIT", "*IOSYSCFG"};

    public static boolean checkAllobjSecadmSpecialAuthorities() throws Exception {
        AS400 as400 = new AS400();
        ProgramCall pc = new ProgramCall(as400);
        AS400Text convert4 = new AS400Text(768, as400.getCcsid(), as400);
        ProgramParameter[] parmlist = new ProgramParameter[]{new ProgramParameter(768), new ProgramParameter(new AS400Bin4().toBytes(768)), new ProgramParameter(new AS400Text(8, as400.getCcsid(), as400).toBytes((Object)S_USRFORMAT)), new ProgramParameter(new AS400Text(10, as400.getCcsid(), as400).toBytes((Object)S_CURRENTUSRPRF)), new ProgramParameter(new byte[4])};
        pc.setProgram(S_USRCMD, parmlist);
        if (!pc.run()) {
            Logger.getGlobalLogger().warning(String.valueOf(CheckUserAuthorizations.class.getName()) + ": Program Call is not running!");
            return false;
        }
        String output = (String)convert4.toObject(parmlist[0].getOutputData());
        String sysSpecAuths = output.substring(83, 91);
        Vector<String> currentUserAuth = new Vector<String>();
        int i = 0;
        while (i < sysSpecAuths.length()) {
            if (sysSpecAuths.charAt(i) == 'Y') {
                currentUserAuth.add(SPECIALAUTH[i]);
            }
            ++i;
        }
        StringTokenizer parseString = new StringTokenizer(CheckUserAuthorizations.getReqAuthorities(), S_SEPARATOR);
        Vector<String> authV = new Vector<String>();
        while (parseString.hasMoreTokens()) {
            authV.add(parseString.nextToken().trim());
        }
        int i2 = 0;
        while (i2 < currentUserAuth.size()) {
            if (authV.contains(currentUserAuth.elementAt(i2))) {
                authV.remove(currentUserAuth.elementAt(i2));
            }
            ++i2;
        }
        if (authV.size() > 0) {
            Logger.getGlobalLogger().debug(String.valueOf(CheckUserAuthorizations.class.getName()) + ": nonAdmin User.");
            return false;
        }
        Logger.getGlobalLogger().debug(String.valueOf(CheckUserAuthorizations.class.getName()) + ": nonAdmin User.");
        return true;
    }

    private static String getReqAuthorities() {
        return S_REQAUTHORITIES;
    }
}

