/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.core.console.manager.rules;

import com.ibm.cic.common.core.console.manager.rules.IConLineMatcher;
import java.util.ArrayList;
import java.util.List;

public class ConLineRules {
    public static final char DEF_END_RULE = '}';
    public static final char DEF_START_RULE = '{';
    public static final String BEGIN_RULE = "${";
    private static final String ARG_DELIM = ":";
    public static final String RULE_EQUALS = "equals";
    public static final String RULE_CONTAINS = "contains";
    public static final String RULE_ENDS_WITH = "endsWith";
    public static final String RULE_STARTS_WITH = "startsWith";
    public static final String RULE_SKIP_UNTIL = "skipUntil";
    public static final String RULE_OR = "or";
    public static final String RULE_AND = "and";
    public static final String RULE_NOT = "not";
    public static final String RULE_NO_OUTPUT = "noOutput";
    public static final String DEF_CONTAINS = "${contains:";
    public static final String DEF_EQUALS = "${equals:";
    public static final String DEF_ENDS_WITH = "${endsWith:";
    public static final String DEF_SKIP_UNTIL = "${skipUntil:";
    public static final String DEF_STARTS_WITH = "${startsWith:";
    public static final String DEF_OR = "${or:";
    public static final String DEF_AND = "${and:";
    public static final String DEF_NOT = "${not:";
    public static final String DEF_NO_OUTPUT = "${noOutput}";

    private static int getRuleEndIndex(String s, int fromIndex) {
        int length = s.length();
        int brackets = 0;
        if (ConLineRules.isRule(s, fromIndex)) {
            int i = fromIndex;
            while (i < length) {
                char c = s.charAt(i);
                if (c == '{') {
                    ++brackets;
                } else if (c == '}' && --brackets == 0) {
                    return i;
                }
                ++i;
            }
        }
        return length;
    }

    public static boolean isRule(String a_rule, int a_index) {
        return a_rule.indexOf(BEGIN_RULE, a_index) == a_index;
    }

    public static IConLineMatcher createMatcher(String a_ruleString) {
        return ConLineRules.createMatcher(a_ruleString, 0);
    }

    public static IConLineMatcher createMatcher(String a_ruleString, int index) {
        IConLineMatcher return_value = null;
        String ruleName = RULE_CONTAINS;
        String ruleArg = "";
        if (ConLineRules.isRule(a_ruleString, index)) {
            int ruleIndex = BEGIN_RULE.length() + index;
            int argIndex = a_ruleString.indexOf(ARG_DELIM, ruleIndex);
            int endIndex = ConLineRules.getRuleEndIndex(a_ruleString, index);
            if (argIndex < 0) {
                ruleName = a_ruleString.substring(ruleIndex, endIndex);
            } else {
                ruleName = a_ruleString.substring(ruleIndex, argIndex);
                ruleArg = a_ruleString.substring(argIndex + 1, endIndex);
            }
        } else {
            ruleArg = a_ruleString.substring(index);
        }
        return_value = ConLineRules.createMatcher(ruleName, ruleArg);
        return return_value;
    }

    public static IConLineMatcher createMatcher(String a_ruleName, String a_ruleArg) {
        IConLineMatcher return_value = null;
        if (RULE_EQUALS.equals(a_ruleName)) {
            return new Equals(a_ruleArg);
        }
        if (RULE_ENDS_WITH.equals(a_ruleName)) {
            return new EndsWith(a_ruleArg);
        }
        if (RULE_CONTAINS.equals(a_ruleName)) {
            return new Contains(a_ruleArg);
        }
        if (RULE_STARTS_WITH.equals(a_ruleName)) {
            return new StartsWith(a_ruleArg);
        }
        if (RULE_SKIP_UNTIL.equals(a_ruleName)) {
            return new SkipUntil(a_ruleArg);
        }
        if (RULE_OR.equals(a_ruleName)) {
            return new Or(a_ruleArg);
        }
        if (RULE_AND.equals(a_ruleName)) {
            return new And(a_ruleArg);
        }
        if (RULE_NOT.equals(a_ruleName)) {
            return new Not(a_ruleArg);
        }
        if (RULE_NO_OUTPUT.equals(a_ruleName)) {
            return new NoOutput();
        }
        return return_value;
    }

    public static abstract class AStringValueMatcher
    implements IConLineMatcher {
        private final String m_ruleName;
        protected String m_val;

        public AStringValueMatcher(String a_ruleName, String a_val) {
            this.m_ruleName = a_ruleName;
            this.m_val = this.normalize(a_val);
        }

        private String normalize(String s) {
            if (s == null) {
                return s;
            }
            String result = "";
            String[] lines = s.split("\n", -1);
            if (lines.length <= 1) {
                result = s;
            } else {
                String[] stringArray = lines;
                int n = lines.length;
                int n2 = 0;
                while (n2 < n) {
                    String line2 = stringArray[n2];
                    String line = line2.trim();
                    if (line.length() != 0) {
                        result = line;
                        break;
                    }
                    ++n2;
                }
            }
            int i = result.indexOf(123);
            if (i >= 0) {
                result = result.substring(0, i);
            }
            result = result.replace("&", "");
            return result;
        }

        public String toString() {
            return String.valueOf(this.m_ruleName) + " --> " + '\"' + this.m_val + '\"';
        }
    }

    public static class And
    extends Or {
        public And(String a_val) {
            super(a_val);
        }

        @Override
        public int matches(String a_line) {
            for (IConLineMatcher rule : this.m_rules) {
                if (rule.matches(a_line) != -1) continue;
                return -1;
            }
            return 1;
        }
    }

    public static class Contains
    extends AStringValueMatcher {
        public Contains(String a_val) {
            super(ConLineRules.RULE_CONTAINS, a_val);
        }

        @Override
        public int matches(String a_line) {
            if (a_line.contains(this.m_val)) {
                return 1;
            }
            return -1;
        }
    }

    public static class EndsWith
    extends AStringValueMatcher {
        public EndsWith(String a_val) {
            super(ConLineRules.RULE_ENDS_WITH, a_val);
        }

        @Override
        public int matches(String a_line) {
            if (a_line.endsWith(this.m_val)) {
                return 1;
            }
            return -1;
        }
    }

    public static class Equals
    extends AStringValueMatcher {
        public Equals(String a_val) {
            super(ConLineRules.RULE_EQUALS, a_val);
        }

        @Override
        public int matches(String a_line) {
            if (this.m_val.equals(a_line)) {
                return 1;
            }
            return -1;
        }
    }

    public static class NoOutput
    implements IConLineMatcher {
        public String toString() {
            return "noOutput\n";
        }

        @Override
        public int matches(String a_line) {
            return -1;
        }
    }

    public static class Not
    implements IConLineMatcher {
        IConLineMatcher m_val;

        public String toString() {
            return "not\n" + this.m_val;
        }

        public Not(String a_val) {
            this.m_val = ConLineRules.createMatcher(a_val);
        }

        @Override
        public int matches(String a_line) {
            if (this.m_val == null) {
                return -1;
            }
            if (this.m_val.matches(a_line) == 1) {
                return -1;
            }
            if (this.m_val.matches(a_line) == -1) {
                return 1;
            }
            return 0;
        }
    }

    public static class Or
    implements IConLineMatcher {
        protected List<IConLineMatcher> m_rules = new ArrayList<IConLineMatcher>();

        public Or(String a_val) {
            int index = 0;
            do {
                IConLineMatcher rule;
                if ((rule = ConLineRules.createMatcher(a_val, index)) == null) continue;
                this.m_rules.add(rule);
            } while ((index = ConLineRules.getRuleEndIndex(a_val, index) + 1) < a_val.length());
        }

        @Override
        public int matches(String a_line) {
            for (IConLineMatcher rule : this.m_rules) {
                if (rule.matches(a_line) != 1) continue;
                return 1;
            }
            return -1;
        }
    }

    public static class SkipUntil
    implements IConLineMatcher {
        IConLineMatcher m_val;

        public String toString() {
            return "skipUntil\n" + this.m_val;
        }

        public SkipUntil(String a_val) {
            this.m_val = ConLineRules.createMatcher(a_val);
        }

        @Override
        public int matches(String a_line) {
            if (this.m_val == null) {
                return -1;
            }
            if (this.m_val.matches(a_line) == 1) {
                return 1;
            }
            return 0;
        }
    }

    public static class StartsWith
    extends AStringValueMatcher {
        public StartsWith(String a_val) {
            super(ConLineRules.RULE_STARTS_WITH, a_val);
        }

        @Override
        public int matches(String a_line) {
            if (a_line.startsWith(this.m_val)) {
                return 1;
            }
            return -1;
        }
    }
}

