/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.commonNativeAdapterData;

import com.ibm.cic.common.commonNativeAdapterData.AbstractDuringPhasesCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.DelayedProcessingNativeData;
import com.ibm.cic.common.commonNativeAdapterData.DuringPhases;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.IDuringPhasesCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.ZipArtifact;
import com.ibm.cic.common.core.model.IInstallableUnit;
import com.ibm.cic.common.core.model.Phases;
import com.ibm.cic.common.core.model.adapterdata.ArtifactCommonAttributes;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.cic.common.core.model.adapterdata.IArtifact;
import com.ibm.cic.common.core.model.adapterdata.IArtifactKey;
import com.ibm.cic.common.core.utils.UserOptions;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.Path;

public class ZipCommonNativeData
extends AbstractDuringPhasesCommonNativeData {
    private ZipArtifact artifact;
    private final String destination;
    private final String perm;
    private final boolean overwrite;
    private final List files = new ArrayList();

    public ZipCommonNativeData(IInstallableUnit iu, String destination) {
        this(null, null, new ZipArtifact(iu, (IPath)Path.EMPTY), destination, null, false);
    }

    public ZipCommonNativeData(IInstallableUnit iu, String destination, IPath path) {
        this(null, null, new ZipArtifact(iu, path), destination, null, false);
    }

    public ZipCommonNativeData(IInstallableUnit iu, String destination, String rawKey) {
        this(null, iu, destination, rawKey, null, null, false);
    }

    ZipCommonNativeData(IDuringPhasesCommonNativeData parent, IInstallableUnit iu, String destination, String rawKey, DuringPhases phases, String perm, boolean overwrite) {
        this(parent, phases, new ZipArtifact(iu, rawKey), destination, perm, overwrite);
    }

    ZipCommonNativeData(IDuringPhasesCommonNativeData parent, IInstallableUnit iu, String destination, ArtifactCommonAttributes aca, DuringPhases phases, String perm, boolean overwrite) {
        this(parent, phases, new ZipArtifact(aca), destination, perm, overwrite);
    }

    private ZipCommonNativeData(IDuringPhasesCommonNativeData parent, DuringPhases phases, ZipArtifact artifact, String destination, String perm, boolean overwrite) {
        super(parent, phases);
        this.artifact = artifact;
        artifact.setData(this);
        this.destination = destination;
        this.perm = perm;
        this.overwrite = overwrite;
    }

    @Override
    protected int getFirstPhaseToInstall() {
        int phaseToInstall;
        int first = this.getDuringPhases().getFirstPhase();
        if (!UserOptions.CIC_FORCE_ZIP_INSTALL_DURING_INSTALL_PHASE.isSet()) {
            return first;
        }
        if (Phases.isInstallationPhase((int)first)) {
            phaseToInstall = first;
        } else {
            int last = this.getDuringPhases().getLastPhase();
            phaseToInstall = Phases.getUndoPhase((int)last);
        }
        return phaseToInstall;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof ZipCommonNativeData)) {
            return false;
        }
        ZipCommonNativeData rhs = (ZipCommonNativeData)obj;
        return rhs.getKey().equals(this.getKey()) && rhs.destination.equals(this.destination);
    }

    public int hashCode() {
        return this.artifact.hashCode() * 13 + this.destination.hashCode();
    }

    public IArtifact getArtifact() {
        return this.artifact;
    }

    public void setArtifact(IArtifact artifact) {
        this.artifact = (ZipArtifact)artifact;
    }

    private IArtifactKey getKey() {
        return this.artifact == null ? null : this.artifact.getKey();
    }

    public String getDestination() {
        return this.destination;
    }

    public String getElementName() {
        return this.getArtifactCommonAttributes() != null ? "artifact" : "zip";
    }

    public String getPerm() {
        return this.perm;
    }

    public boolean isOverwrite() {
        return this.overwrite;
    }

    protected CommonAdapterData.NameValuePairs getAttrNameValuePairs() {
        CommonAdapterData.NameValuePairs pairs = new CommonAdapterData.NameValuePairs();
        ArtifactCommonAttributes aca = this.getArtifactCommonAttributes();
        if (aca != null) {
            pairs.add("type", (Object)aca.getType()).add("id", (Object)aca.getId()).add("version", (Object)aca.getVersion()).addIf(aca.isActive(), "active", (Object)aca.getType());
        } else {
            pairs.add("key", (Object)(this.artifact == null ? "" : this.artifact.getLegacyXMLKeyString()));
        }
        DuringPhases duringPhases = this.getDuringPhases();
        return pairs.add("destination", (Object)this.getDestination()).addIf(this.perm != null, "perm", (Object)this.getPerm()).addIf(!duringPhases.equals(DEFAULT_PHASES), "duringPhases", (Object)duringPhases).addIfTrue("overwrite", this.overwrite);
    }

    private ArtifactCommonAttributes getArtifactCommonAttributes() {
        ZipArtifact zipArtifact = (ZipArtifact)this.getArtifact();
        return zipArtifact == null ? null : zipArtifact.getCommonAttributes();
    }

    @Override
    public void addChild(ICommonNativeData child) {
        this.files.add(child);
    }

    public CommonAdapterData[] getChildren() {
        return this.files.toArray(new CommonAdapterData[this.files.size()]);
    }

    public HashSet getDelayedDeleteFiles() {
        HashSet<String> return_value = new HashSet<String>();
        for (Object obj : this.files) {
            if (!(obj instanceof DelayedProcessingNativeData)) continue;
            return_value.add(((DelayedProcessingNativeData)obj).getFileName());
        }
        return return_value;
    }
}

