/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.cic.common.commonNativeAdapterData;

import com.ibm.cic.common.commonNativeAdapterData.AbstractDuringPhasesCommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.DuringPhases;
import com.ibm.cic.common.commonNativeAdapterData.ICommonNativeData;
import com.ibm.cic.common.commonNativeAdapterData.IDuringPhasesCommonNativeData;
import com.ibm.cic.common.core.model.Phases;
import com.ibm.cic.common.core.model.adapterdata.CommonAdapterData;
import com.ibm.icu.util.StringTokenizer;
import java.util.ArrayList;
import java.util.List;

public class PerformCommonNativeData
extends AbstractDuringPhasesCommonNativeData {
    private List operations = new ArrayList();

    public PerformCommonNativeData(String phasesStr, int performIndex) {
        super(null, new DuringPhases(PerformCommonNativeData.parsePhasesChecked(phasesStr)));
    }

    public PerformCommonNativeData(DuringPhases phases, int performIndex) {
        super(null, phases);
    }

    public PerformCommonNativeData(long phases, int performIndex) {
        super(null, new DuringPhases(phases));
    }

    public boolean isPhaseSet(int phase) {
        return this.getDuringPhases().isPhaseSet(phase);
    }

    @Override
    public void addChild(ICommonNativeData child) {
        this.addOperation(child);
    }

    private void addOperation(ICommonNativeData operation) {
        this.operations.add(operation);
        if (operation instanceof IDuringPhasesCommonNativeData) {
            IDuringPhasesCommonNativeData child = (IDuringPhasesCommonNativeData)((Object)operation);
            child.setDuringPhasesParent(this);
        }
    }

    public CommonAdapterData[] getChildren() {
        return this.getOperations();
    }

    public ICommonNativeData[] getOperations() {
        return this.operations.toArray(new ICommonNativeData[this.operations.size()]);
    }

    public static long parsePhases(String phasesStr) {
        long phases = 0L;
        StringTokenizer st = new StringTokenizer(phasesStr, " \t,");
        while (st.hasMoreTokens()) {
            int phase;
            String token = st.nextToken();
            if (token.equalsIgnoreCase("configuration")) {
                token = "post_install_configure";
            }
            if ((phase = Phases.nameToPhase((String)token)) == -1) {
                return -1L;
            }
            phases |= 1L << phase;
        }
        return phases;
    }

    private static long parsePhasesChecked(String phasesStr) {
        long result = PerformCommonNativeData.parsePhases(phasesStr);
        if (result == -1L) {
            throw new IllegalArgumentException(phasesStr);
        }
        return result;
    }

    public String getElementName() {
        return "perform";
    }

    protected CommonAdapterData.NameValuePairs getAttrNameValuePairs() {
        return new CommonAdapterData.NameValuePairs("duringPhases", (Object)this.getPhases());
    }

    public Object clone() throws CloneNotSupportedException {
        PerformCommonNativeData result = (PerformCommonNativeData)super.clone();
        List originalOperations = result.operations;
        result.operations = new ArrayList(originalOperations.size());
        for (ICommonNativeData child : originalOperations) {
            result.addOperation((ICommonNativeData)child.clone());
        }
        return result;
    }
}

